/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.linked;

import gnu.trove.TIntCollection;
import gnu.trove.function.TIntFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.procedure.TIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

public class TIntLinkedList
implements TIntList,
Externalizable {
    int no_entry_value;
    int size;
    TIntLink head;
    TIntLink tail;

    public TIntLinkedList() {
        this.tail = this.head = null;
    }

    public TIntLinkedList(int n) {
        this.tail = this.head = null;
        this.no_entry_value = n;
    }

    public TIntLinkedList(TIntList tIntList) {
        this.tail = this.head = null;
        this.no_entry_value = tIntList.getNoEntryValue();
        TIntIterator tIntIterator = tIntList.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            this.add(n);
        }
    }

    @Override
    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(int n) {
        TIntLink tIntLink = new TIntLink(n);
        if (TIntLinkedList.no(this.head)) {
            this.head = tIntLink;
            this.tail = tIntLink;
        } else {
            tIntLink.setPrevious(this.tail);
            this.tail.setNext(tIntLink);
            this.tail = tIntLink;
        }
        ++this.size;
        return true;
    }

    @Override
    public void add(int[] nArray) {
        for (int n : nArray) {
            this.add(n);
        }
    }

    @Override
    public void add(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n + i];
            this.add(n3);
        }
    }

    @Override
    public void insert(int n, int n2) {
        TIntLinkedList tIntLinkedList = new TIntLinkedList();
        tIntLinkedList.add(n2);
        this.insert(n, tIntLinkedList);
    }

    @Override
    public void insert(int n, int[] nArray) {
        this.insert(n, TIntLinkedList.link(nArray, 0, nArray.length));
    }

    @Override
    public void insert(int n, int[] nArray, int n2, int n3) {
        this.insert(n, TIntLinkedList.link(nArray, n2, n3));
    }

    void insert(int n, TIntLinkedList tIntLinkedList) {
        TIntLink tIntLink = this.getLinkAt(n);
        this.size += tIntLinkedList.size;
        if (tIntLink == this.head) {
            tIntLinkedList.tail.setNext(this.head);
            this.head.setPrevious(tIntLinkedList.tail);
            this.head = tIntLinkedList.head;
            return;
        }
        if (TIntLinkedList.no(tIntLink)) {
            if (this.size == 0) {
                this.head = tIntLinkedList.head;
                this.tail = tIntLinkedList.tail;
            } else {
                this.tail.setNext(tIntLinkedList.head);
                tIntLinkedList.head.setPrevious(this.tail);
                this.tail = tIntLinkedList.tail;
            }
        } else {
            TIntLink tIntLink2 = tIntLink.getPrevious();
            tIntLink.getPrevious().setNext(tIntLinkedList.head);
            tIntLinkedList.tail.setNext(tIntLink);
            tIntLink.setPrevious(tIntLinkedList.tail);
            tIntLinkedList.head.setPrevious(tIntLink2);
        }
    }

    static TIntLinkedList link(int[] nArray, int n, int n2) {
        TIntLinkedList tIntLinkedList = new TIntLinkedList();
        for (int i = 0; i < n2; ++i) {
            tIntLinkedList.add(nArray[n + i]);
        }
        return tIntLinkedList;
    }

    @Override
    public int get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index " + n + " exceeds size " + this.size);
        }
        TIntLink tIntLink = this.getLinkAt(n);
        if (TIntLinkedList.no(tIntLink)) {
            return this.no_entry_value;
        }
        return tIntLink.getValue();
    }

    public TIntLink getLinkAt(int n) {
        if (n >= this.size()) {
            return null;
        }
        if (n <= this.size() >>> 1) {
            return TIntLinkedList.getLink(this.head, 0, n, true);
        }
        return TIntLinkedList.getLink(this.tail, this.size() - 1, n, false);
    }

    private static TIntLink getLink(TIntLink tIntLink, int n, int n2) {
        return TIntLinkedList.getLink(tIntLink, n, n2, true);
    }

    private static TIntLink getLink(TIntLink tIntLink, int n, int n2, boolean bl) {
        int n3 = n;
        while (TIntLinkedList.got(tIntLink)) {
            if (n3 == n2) {
                return tIntLink;
            }
            n3 += bl ? 1 : -1;
            tIntLink = bl ? tIntLink.getNext() : tIntLink.getPrevious();
        }
        return null;
    }

    @Override
    public int set(int n, int n2) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index " + n + " exceeds size " + this.size);
        }
        TIntLink tIntLink = this.getLinkAt(n);
        if (TIntLinkedList.no(tIntLink)) {
            throw new IndexOutOfBoundsException("at offset " + n);
        }
        int n3 = tIntLink.getValue();
        tIntLink.setValue(n2);
        return n3;
    }

    @Override
    public void set(int n, int[] nArray) {
        this.set(n, nArray, 0, nArray.length);
    }

    @Override
    public void set(int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[n2 + i];
            this.set(n + i, n4);
        }
    }

    @Override
    public int replace(int n, int n2) {
        return this.set(n, n2);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    @Override
    public boolean remove(int n) {
        boolean bl = false;
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (tIntLink.getValue() == n) {
                bl = true;
                this.removeLink(tIntLink);
            }
            tIntLink = tIntLink.getNext();
        }
        return bl;
    }

    private void removeLink(TIntLink tIntLink) {
        if (TIntLinkedList.no(tIntLink)) {
            return;
        }
        --this.size;
        TIntLink tIntLink2 = tIntLink.getPrevious();
        TIntLink tIntLink3 = tIntLink.getNext();
        if (TIntLinkedList.got(tIntLink2)) {
            tIntLink2.setNext(tIntLink3);
        } else {
            this.head = tIntLink3;
        }
        if (TIntLinkedList.got(tIntLink3)) {
            tIntLink3.setPrevious(tIntLink2);
        } else {
            this.tail = tIntLink2;
        }
        tIntLink.setNext(null);
        tIntLink.setPrevious(null);
    }

    @Override
    public boolean containsAll(Collection collection) {
        if (this.isEmpty()) {
            return false;
        }
        for (Object e : collection) {
            if (e instanceof Integer) {
                Integer n = (Integer)e;
                if (this.contains(n)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TIntCollection tIntCollection) {
        if (this.isEmpty()) {
            return false;
        }
        TIntIterator tIntIterator = tIntCollection.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(int[] nArray) {
        if (this.isEmpty()) {
            return false;
        }
        for (int n : nArray) {
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Integer n : collection) {
            if (!this.add(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(TIntCollection tIntCollection) {
        boolean bl = false;
        TIntIterator tIntIterator = tIntCollection.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            if (!this.add(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(int[] nArray) {
        boolean bl = false;
        for (int n : nArray) {
            if (!this.add(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(TIntCollection tIntCollection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (tIntCollection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(int[] nArray) {
        Arrays.sort(nArray);
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (Arrays.binarySearch(nArray, tIntIterator.next()) >= 0) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (!collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(TIntCollection tIntCollection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (!tIntCollection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(int[] nArray) {
        Arrays.sort(nArray);
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (Arrays.binarySearch(nArray, tIntIterator.next()) < 0) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public int removeAt(int n) {
        TIntLink tIntLink = this.getLinkAt(n);
        if (TIntLinkedList.no(tIntLink)) {
            throw new ArrayIndexOutOfBoundsException("no elemenet at " + n);
        }
        int n2 = tIntLink.getValue();
        this.removeLink(tIntLink);
        return n2;
    }

    @Override
    public void remove(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.removeAt(n);
        }
    }

    @Override
    public void transformValues(TIntFunction tIntFunction) {
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            tIntLink.setValue(tIntFunction.execute(tIntLink.getValue()));
            tIntLink = tIntLink.getNext();
        }
    }

    @Override
    public void reverse() {
        TIntLink tIntLink = this.head;
        TIntLink tIntLink2 = this.tail;
        TIntLink tIntLink3 = this.head;
        while (TIntLinkedList.got(tIntLink3)) {
            TIntLink tIntLink4 = tIntLink3.getNext();
            TIntLink tIntLink5 = tIntLink3.getPrevious();
            TIntLink tIntLink6 = tIntLink3;
            tIntLink3 = tIntLink3.getNext();
            tIntLink6.setNext(tIntLink5);
            tIntLink6.setPrevious(tIntLink4);
        }
        this.head = tIntLink2;
        this.tail = tIntLink;
    }

    @Override
    public void reverse(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("from > to : " + n + ">" + n2);
        }
        TIntLink tIntLink = this.getLinkAt(n);
        TIntLink tIntLink2 = this.getLinkAt(n2);
        TIntLink tIntLink3 = null;
        TIntLink tIntLink4 = tIntLink.getPrevious();
        for (TIntLink tIntLink5 = tIntLink; tIntLink5 != tIntLink2; tIntLink5 = tIntLink5.getNext()) {
            TIntLink tIntLink6 = tIntLink5.getNext();
            TIntLink tIntLink7 = tIntLink5.getPrevious();
            tIntLink3 = tIntLink5;
            tIntLink3.setNext(tIntLink7);
            tIntLink3.setPrevious(tIntLink6);
        }
        if (TIntLinkedList.got(tIntLink3)) {
            tIntLink4.setNext(tIntLink3);
            tIntLink2.setPrevious(tIntLink4);
        }
        tIntLink.setNext(tIntLink2);
        tIntLink2.setPrevious(tIntLink);
    }

    @Override
    public void shuffle(Random random) {
        for (int i = 0; i < this.size; ++i) {
            TIntLink tIntLink = this.getLinkAt(random.nextInt(this.size()));
            this.removeLink(tIntLink);
            this.add(tIntLink.getValue());
        }
    }

    @Override
    public TIntList subList(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("begin index " + n + " greater than end index " + n2);
        }
        if (this.size < n) {
            throw new IllegalArgumentException("begin index " + n + " greater than last index " + this.size);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException("end index < " + this.size);
        }
        TIntLinkedList tIntLinkedList = new TIntLinkedList();
        TIntLink tIntLink = this.getLinkAt(n);
        for (int i = n; i < n2; ++i) {
            tIntLinkedList.add(tIntLink.getValue());
            tIntLink = tIntLink.getNext();
        }
        return tIntLinkedList;
    }

    @Override
    public int[] toArray() {
        return this.toArray(new int[this.size], 0, this.size);
    }

    @Override
    public int[] toArray(int n, int n2) {
        return this.toArray(new int[n2], n, 0, n2);
    }

    @Override
    public int[] toArray(int[] nArray) {
        return this.toArray(nArray, 0, this.size);
    }

    @Override
    public int[] toArray(int[] nArray, int n, int n2) {
        return this.toArray(nArray, n, 0, n2);
    }

    @Override
    public int[] toArray(int[] nArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return nArray;
        }
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        TIntLink tIntLink = this.getLinkAt(n);
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = tIntLink.getValue();
            tIntLink = tIntLink.getNext();
        }
        return nArray;
    }

    @Override
    public boolean forEach(TIntProcedure tIntProcedure) {
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (!tIntProcedure.execute(tIntLink.getValue())) {
                return false;
            }
            tIntLink = tIntLink.getNext();
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TIntProcedure tIntProcedure) {
        TIntLink tIntLink = this.tail;
        while (TIntLinkedList.got(tIntLink)) {
            if (!tIntProcedure.execute(tIntLink.getValue())) {
                return false;
            }
            tIntLink = tIntLink.getPrevious();
        }
        return true;
    }

    @Override
    public void sort() {
        this.sort(0, this.size);
    }

    @Override
    public void sort(int n, int n2) {
        TIntList tIntList = this.subList(n, n2);
        int[] nArray = tIntList.toArray();
        Arrays.sort(nArray);
        this.set(n, nArray);
    }

    @Override
    public void fill(int n) {
        this.fill(0, this.size, n);
    }

    @Override
    public void fill(int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        TIntLink tIntLink = this.getLinkAt(n);
        if (n2 > this.size) {
            int n4;
            for (n4 = n; n4 < this.size; ++n4) {
                tIntLink.setValue(n3);
                tIntLink = tIntLink.getNext();
            }
            for (n4 = this.size; n4 < n2; ++n4) {
                this.add(n3);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                tIntLink.setValue(n3);
                tIntLink = tIntLink.getNext();
            }
        }
    }

    @Override
    public int binarySearch(int n) {
        return this.binarySearch(n, 0, this.size());
    }

    @Override
    public int binarySearch(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (n3 > this.size) {
            throw new IndexOutOfBoundsException("end index > size: " + n3 + " > " + this.size);
        }
        if (n3 < n2) {
            return -(n2 + 1);
        }
        int n4 = n2;
        TIntLink tIntLink = this.getLinkAt(n2);
        int n5 = n3;
        while (n4 < n5) {
            int n6 = n4 + n5 >>> 1;
            TIntLink tIntLink2 = TIntLinkedList.getLink(tIntLink, n4, n6);
            if (tIntLink2.getValue() == n) {
                return n6;
            }
            if (tIntLink2.getValue() < n) {
                n4 = n6 + 1;
                tIntLink = tIntLink2.next;
                continue;
            }
            n5 = n6 - 1;
        }
        return -(n4 + 1);
    }

    @Override
    public int indexOf(int n) {
        return this.indexOf(0, n);
    }

    @Override
    public int indexOf(int n, int n2) {
        int n3 = n;
        TIntLink tIntLink = this.getLinkAt(n);
        while (TIntLinkedList.got(tIntLink.getNext())) {
            if (tIntLink.getValue() == n2) {
                return n3;
            }
            ++n3;
            tIntLink = tIntLink.getNext();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        return this.lastIndexOf(0, n);
    }

    @Override
    public int lastIndexOf(int n, int n2) {
        if (this.isEmpty()) {
            return -1;
        }
        int n3 = -1;
        int n4 = n;
        TIntLink tIntLink = this.getLinkAt(n);
        while (TIntLinkedList.got(tIntLink.getNext())) {
            if (tIntLink.getValue() == n2) {
                n3 = n4;
            }
            ++n4;
            tIntLink = tIntLink.getNext();
        }
        return n3;
    }

    @Override
    public boolean contains(int n) {
        if (this.isEmpty()) {
            return false;
        }
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (tIntLink.getValue() == n) {
                return true;
            }
            tIntLink = tIntLink.getNext();
        }
        return false;
    }

    @Override
    public TIntIterator iterator() {
        return new TIntIterator(){
            TIntLink l;
            TIntLink current;
            {
                this.l = TIntLinkedList.this.head;
            }

            @Override
            public int next() {
                if (TIntLinkedList.no(this.l)) {
                    throw new NoSuchElementException();
                }
                int n = this.l.getValue();
                this.current = this.l;
                this.l = this.l.getNext();
                return n;
            }

            @Override
            public boolean hasNext() {
                return TIntLinkedList.got(this.l);
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                TIntLinkedList.this.removeLink(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public TIntList grep(TIntProcedure tIntProcedure) {
        TIntLinkedList tIntLinkedList = new TIntLinkedList();
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (tIntProcedure.execute(tIntLink.getValue())) {
                tIntLinkedList.add(tIntLink.getValue());
            }
            tIntLink = tIntLink.getNext();
        }
        return tIntLinkedList;
    }

    @Override
    public TIntList inverseGrep(TIntProcedure tIntProcedure) {
        TIntLinkedList tIntLinkedList = new TIntLinkedList();
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (!tIntProcedure.execute(tIntLink.getValue())) {
                tIntLinkedList.add(tIntLink.getValue());
            }
            tIntLink = tIntLink.getNext();
        }
        return tIntLinkedList;
    }

    @Override
    public int max() {
        int n = Integer.MIN_VALUE;
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (n < tIntLink.getValue()) {
                n = tIntLink.getValue();
            }
            tIntLink = tIntLink.getNext();
        }
        return n;
    }

    @Override
    public int min() {
        int n = Integer.MAX_VALUE;
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            if (n > tIntLink.getValue()) {
                n = tIntLink.getValue();
            }
            tIntLink = tIntLink.getNext();
        }
        return n;
    }

    @Override
    public int sum() {
        int n = 0;
        TIntLink tIntLink = this.head;
        while (TIntLinkedList.got(tIntLink)) {
            n += tIntLink.getValue();
            tIntLink = tIntLink.getNext();
        }
        return n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this.no_entry_value);
        objectOutput.writeInt(this.size);
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            objectOutput.writeInt(n);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this.no_entry_value = objectInput.readInt();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(objectInput.readInt());
        }
    }

    static boolean got(Object object) {
        return object != null;
    }

    static boolean no(Object object) {
        return object == null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TIntLinkedList tIntLinkedList = (TIntLinkedList)object;
        if (this.no_entry_value != tIntLinkedList.no_entry_value) {
            return false;
        }
        if (this.size != tIntLinkedList.size) {
            return false;
        }
        TIntIterator tIntIterator = this.iterator();
        TIntIterator tIntIterator2 = tIntLinkedList.iterator();
        while (tIntIterator.hasNext()) {
            if (!tIntIterator2.hasNext()) {
                return false;
            }
            if (tIntIterator.next() == tIntIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = HashFunctions.hash(this.no_entry_value);
        n = 31 * n + this.size;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            n = 31 * n + HashFunctions.hash(tIntIterator.next());
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            stringBuilder.append(n);
            if (!tIntIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    class RemoveProcedure
    implements TIntProcedure {
        boolean changed = false;

        RemoveProcedure() {
        }

        @Override
        public boolean execute(int n) {
            if (TIntLinkedList.this.remove(n)) {
                this.changed = true;
            }
            return true;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    static class TIntLink {
        int value;
        TIntLink previous;
        TIntLink next;

        TIntLink(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public TIntLink getPrevious() {
            return this.previous;
        }

        public void setPrevious(TIntLink tIntLink) {
            this.previous = tIntLink;
        }

        public TIntLink getNext() {
            return this.next;
        }

        public void setNext(TIntLink tIntLink) {
            this.next = tIntLink;
        }
    }
}

