/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.linked;

import gnu.trove.list.TLinkable;
import gnu.trove.procedure.TObjectProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TLinkedList
extends AbstractSequentialList
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected TLinkable _head;
    protected TLinkable _tail;
    protected int _size = 0;

    @Override
    public ListIterator listIterator(int n) {
        return new IteratorImpl(n);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void add(int n, TLinkable tLinkable) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index:" + n);
        }
        this.insert(n, tLinkable);
    }

    @Override
    public boolean add(TLinkable tLinkable) {
        this.insert(this._size, tLinkable);
        return true;
    }

    @Override
    public void addFirst(TLinkable tLinkable) {
        this.insert(0, tLinkable);
    }

    @Override
    public void addLast(TLinkable tLinkable) {
        this.insert(this.size(), tLinkable);
    }

    @Override
    public void clear() {
        if (null != this._head) {
            for (TLinkable tLinkable = this._head.getNext(); tLinkable != null; tLinkable = tLinkable.getNext()) {
                TLinkable tLinkable2 = tLinkable.getPrevious();
                tLinkable2.setNext(null);
                tLinkable.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        for (TLinkable tLinkable = this._head; tLinkable != null; tLinkable = tLinkable.getNext()) {
            objectArray[n++] = tLinkable;
        }
        return objectArray;
    }

    public Object[] toUnlinkedArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        TLinkable tLinkable = this._head;
        while (tLinkable != null) {
            objectArray[n] = tLinkable;
            TLinkable tLinkable2 = tLinkable;
            tLinkable = tLinkable.getNext();
            tLinkable2.setNext(null);
            tLinkable2.setPrevious(null);
            ++n;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return objectArray;
    }

    public TLinkable[] toUnlinkedArray(TLinkable[] tLinkableArray) {
        int n = this.size();
        if (tLinkableArray.length < n) {
            tLinkableArray = (TLinkable[])Array.newInstance(tLinkableArray.getClass().getComponentType(), n);
        }
        int n2 = 0;
        TLinkable tLinkable = this._head;
        while (tLinkable != null) {
            tLinkableArray[n2] = tLinkable;
            TLinkable tLinkable2 = tLinkable;
            tLinkable = tLinkable.getNext();
            tLinkable2.setNext(null);
            tLinkable2.setPrevious(null);
            ++n2;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return tLinkableArray;
    }

    @Override
    public boolean contains(Object object) {
        for (TLinkable tLinkable = this._head; tLinkable != null; tLinkable = tLinkable.getNext()) {
            if (!object.equals(tLinkable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TLinkable get(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this._size);
        }
        if (n > this._size >> 1) {
            TLinkable tLinkable = this._tail;
            for (int i = this._size - 1; i > n; --i) {
                tLinkable = tLinkable.getPrevious();
            }
            return tLinkable;
        }
        TLinkable tLinkable = this._head;
        for (int i = 0; i < n; ++i) {
            tLinkable = tLinkable.getNext();
        }
        return tLinkable;
    }

    @Override
    public TLinkable getFirst() {
        return this._head;
    }

    @Override
    public TLinkable getLast() {
        return this._tail;
    }

    public TLinkable getNext(TLinkable tLinkable) {
        return tLinkable.getNext();
    }

    public TLinkable getPrevious(TLinkable tLinkable) {
        return tLinkable.getPrevious();
    }

    @Override
    public TLinkable removeFirst() {
        TLinkable tLinkable = this._head;
        if (tLinkable == null) {
            return null;
        }
        TLinkable tLinkable2 = tLinkable.getNext();
        tLinkable.setNext(null);
        if (null != tLinkable2) {
            tLinkable2.setPrevious(null);
        }
        this._head = tLinkable2;
        if (--this._size == 0) {
            this._tail = null;
        }
        return tLinkable;
    }

    @Override
    public TLinkable removeLast() {
        TLinkable tLinkable = this._tail;
        if (tLinkable == null) {
            return null;
        }
        TLinkable tLinkable2 = tLinkable.getPrevious();
        tLinkable.setPrevious(null);
        if (null != tLinkable2) {
            tLinkable2.setNext(null);
        }
        this._tail = tLinkable2;
        if (--this._size == 0) {
            this._head = null;
        }
        return tLinkable;
    }

    protected void insert(int n, TLinkable tLinkable) {
        if (this._size == 0) {
            this._head = this._tail = tLinkable;
        } else if (n == 0) {
            tLinkable.setNext(this._head);
            this._head.setPrevious(tLinkable);
            this._head = tLinkable;
        } else if (n == this._size) {
            this._tail.setNext(tLinkable);
            tLinkable.setPrevious(this._tail);
            this._tail = tLinkable;
        } else {
            TLinkable tLinkable2 = this.get(n);
            TLinkable tLinkable3 = tLinkable2.getPrevious();
            if (tLinkable3 != null) {
                tLinkable3.setNext(tLinkable);
            }
            tLinkable.setPrevious(tLinkable3);
            tLinkable.setNext(tLinkable2);
            tLinkable2.setPrevious(tLinkable);
        }
        ++this._size;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof TLinkable) {
            TLinkable tLinkable = (TLinkable)object;
            TLinkable tLinkable2 = tLinkable.getPrevious();
            TLinkable tLinkable3 = tLinkable.getNext();
            if (tLinkable3 == null && tLinkable2 == null) {
                if (object != this._head) {
                    return false;
                }
                this._tail = null;
                this._head = null;
            } else if (tLinkable3 == null) {
                tLinkable.setPrevious(null);
                tLinkable2.setNext(null);
                this._tail = tLinkable2;
            } else if (tLinkable2 == null) {
                tLinkable.setNext(null);
                tLinkable3.setPrevious(null);
                this._head = tLinkable3;
            } else {
                tLinkable2.setNext(tLinkable3);
                tLinkable3.setPrevious(tLinkable2);
                tLinkable.setNext(null);
                tLinkable.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(TLinkable tLinkable, TLinkable tLinkable2) {
        if (tLinkable == this._head) {
            this.addFirst(tLinkable2);
        } else if (tLinkable == null) {
            this.addLast(tLinkable2);
        } else {
            TLinkable tLinkable3 = tLinkable.getPrevious();
            tLinkable2.setNext(tLinkable);
            tLinkable3.setNext(tLinkable2);
            tLinkable2.setPrevious(tLinkable3);
            tLinkable.setPrevious(tLinkable2);
            ++this._size;
        }
    }

    public void addAfter(TLinkable tLinkable, TLinkable tLinkable2) {
        if (tLinkable == this._tail) {
            this.addLast(tLinkable2);
        } else if (tLinkable == null) {
            this.addFirst(tLinkable2);
        } else {
            TLinkable tLinkable3 = tLinkable.getNext();
            tLinkable2.setPrevious(tLinkable);
            tLinkable2.setNext(tLinkable3);
            tLinkable.setNext(tLinkable2);
            tLinkable3.setPrevious(tLinkable2);
            ++this._size;
        }
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        for (TLinkable tLinkable = this._head; tLinkable != null; tLinkable = tLinkable.getNext()) {
            boolean bl = tObjectProcedure.execute(tLinkable);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this._size);
        objectOutput.writeObject(this._head);
        objectOutput.writeObject(this._tail);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this._size = objectInput.readInt();
        this._head = (TLinkable)objectInput.readObject();
        this._tail = (TLinkable)objectInput.readObject();
    }

    protected final class IteratorImpl
    implements ListIterator {
        private int _nextIndex = 0;
        private TLinkable _next;
        private TLinkable _lastReturned;

        IteratorImpl(int n) {
            if (n < 0 || n > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = n;
            if (n == 0) {
                this._next = TLinkedList.this._head;
            } else if (n == TLinkedList.this._size) {
                this._next = null;
            } else if (n < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int i = 0; i < n; ++i) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int i = TLinkedList.this._size - 1; i > n; --i) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        public final void add(TLinkable tLinkable) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(tLinkable);
            } else {
                TLinkedList.this.addBefore(this._next, tLinkable);
            }
        }

        @Override
        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        @Override
        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public final TLinkable next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int nextIndex() {
            return this._nextIndex;
        }

        public final TLinkable previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._nextIndex == TLinkedList.this._size ? (this._next = TLinkedList.this._tail) : (this._next = this._next.getPrevious());
            --this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        public final void set(TLinkable tLinkable) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            this.swap(this._lastReturned, tLinkable);
            this._lastReturned = tLinkable;
        }

        private void swap(TLinkable tLinkable, TLinkable tLinkable2) {
            TLinkable tLinkable3 = tLinkable.getPrevious();
            TLinkable tLinkable4 = tLinkable.getNext();
            TLinkable tLinkable5 = tLinkable2.getPrevious();
            TLinkable tLinkable6 = tLinkable2.getNext();
            if (tLinkable4 == tLinkable2) {
                if (tLinkable3 != null) {
                    tLinkable3.setNext(tLinkable2);
                }
                tLinkable2.setPrevious(tLinkable3);
                tLinkable2.setNext(tLinkable);
                tLinkable.setPrevious(tLinkable2);
                tLinkable.setNext(tLinkable6);
                if (tLinkable6 != null) {
                    tLinkable6.setPrevious(tLinkable);
                }
            } else if (tLinkable6 == tLinkable) {
                if (tLinkable5 != null) {
                    tLinkable5.setNext(tLinkable2);
                }
                tLinkable2.setPrevious(tLinkable);
                tLinkable2.setNext(tLinkable4);
                tLinkable.setPrevious(tLinkable5);
                tLinkable.setNext(tLinkable2);
                if (tLinkable4 != null) {
                    tLinkable4.setPrevious(tLinkable2);
                }
            } else {
                tLinkable.setNext(tLinkable6);
                tLinkable.setPrevious(tLinkable5);
                if (tLinkable5 != null) {
                    tLinkable5.setNext(tLinkable);
                }
                if (tLinkable6 != null) {
                    tLinkable6.setPrevious(tLinkable);
                }
                tLinkable2.setNext(tLinkable4);
                tLinkable2.setPrevious(tLinkable3);
                if (tLinkable3 != null) {
                    tLinkable3.setNext(tLinkable2);
                }
                if (tLinkable4 != null) {
                    tLinkable4.setPrevious(tLinkable2);
                }
            }
            if (TLinkedList.this._head == tLinkable) {
                TLinkedList.this._head = tLinkable2;
            } else if (TLinkedList.this._head == tLinkable2) {
                TLinkedList.this._head = tLinkable;
            }
            if (TLinkedList.this._tail == tLinkable) {
                TLinkedList.this._tail = tLinkable2;
            } else if (TLinkedList.this._tail == tLinkable2) {
                TLinkedList.this._tail = tLinkable;
            }
            if (this._lastReturned == tLinkable) {
                this._lastReturned = tLinkable2;
            } else if (this._lastReturned == tLinkable2) {
                this._lastReturned = tLinkable;
            }
            if (this._next == tLinkable) {
                this._next = tLinkable2;
            } else if (this._next == tLinkable2) {
                this._next = tLinkable;
            }
        }
    }
}

