/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TCustomObjectHash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.strategy.HashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCustomHashMap
extends TCustomObjectHash
implements TMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient Object[] _values;

    public TCustomHashMap() {
    }

    public TCustomHashMap(HashingStrategy hashingStrategy) {
        super(hashingStrategy);
    }

    public TCustomHashMap(HashingStrategy hashingStrategy, int n) {
        super(hashingStrategy, n);
    }

    public TCustomHashMap(HashingStrategy hashingStrategy, int n, float f) {
        super(hashingStrategy, n, f);
    }

    public TCustomHashMap(HashingStrategy hashingStrategy, Map map) {
        this(hashingStrategy, map.size());
        this.putAll(map);
    }

    public TCustomHashMap(HashingStrategy hashingStrategy, TCustomHashMap tCustomHashMap) {
        this(hashingStrategy, tCustomHashMap.size());
        this.putAll((Map)tCustomHashMap);
    }

    @Override
    public int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(Object object, Object object2) {
        int n = this.insertKey(object);
        return this.doPut(object2, n);
    }

    @Override
    public Object putIfAbsent(Object object, Object object2) {
        int n = this.insertKey(object);
        if (n < 0) {
            return this._values[-n - 1];
        }
        return this.doPut(object2, n);
    }

    private Object doPut(Object object, int n) {
        Object object2 = null;
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return object2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(map));
    }

    @Override
    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TObjectObjectProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(Object object, Object object2) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
                stringBuilder.append("=");
                stringBuilder.append(object2);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == FREE || objectArray2[n] == REMOVED || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectObjectProcedure tObjectObjectProcedure) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TObjectObjectProcedure tObjectObjectProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
                this.removeAt(n);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction tObjectFunction) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == FREE || objectArray2[n] == REMOVED) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int n3 = this.size();
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        this._set = new Object[n];
        Arrays.fill(this._set, FREE);
        this._values = new Object[n];
        int n4 = n2;
        while (n4-- > 0) {
            Object object = objectArray[n4];
            if (object == FREE || object == REMOVED) continue;
            int n5 = this.insertKey(object);
            if (n5 < 0) {
                this.throwObjectContractViolation(this._set[-n5 - 1], object, this.size(), n3, objectArray);
            }
            this._values[n5] = objectArray2[n4];
        }
    }

    public Object get(Object object) {
        int n = this.index(object);
        if (n < 0 || !this.strategy.equals(this._set[n], object)) {
            return null;
        }
        return this._values[n];
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    public Object remove(Object object) {
        Object object2 = null;
        int n = this.index(object);
        if (n >= 0) {
            object2 = this._values[n];
            this.removeAt(n);
        }
        return object2;
    }

    @Override
    public void removeAt(int n) {
        this._values[n] = null;
        super.removeAt(n);
    }

    public Collection values() {
        return new ValueView();
    }

    public Set keySet() {
        return new KeyView();
    }

    public Set entrySet() {
        return new EntryView();
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        if (null == object) {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != objectArray2[n]) continue;
                return true;
            }
        } else {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != objectArray2[n] && !this.strategy.equals(object, objectArray2[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this._size);
        int n = this._set.length;
        while (n-- > 0) {
            if (this._set[n] == REMOVED || this._set[n] == FREE) continue;
            objectOutput.writeObject(this._set[n]);
            objectOutput.writeObject(this._values[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 0) {
            super.readExternal(objectInput);
        }
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
        }
    }

    final class Entry
    implements Map.Entry {
        private Object key;
        private Object val;
        private final int index;

        Entry(Object object, Object object2, int n) {
            this.key = object;
            this.val = object2;
            this.index = n;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object object) {
            if (TCustomHashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            Object object2 = this.val;
            TCustomHashMap.this._values[this.index] = object;
            this.val = object;
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = this;
                Map.Entry entry2 = (Map.Entry)object;
                return (entry.getKey() == null ? entry2.getKey() == null : TCustomHashMap.this.strategy.equals(entry.getKey(), entry2.getKey())) && (entry.getValue() == null ? entry2.getValue() == null : entry.getValue().equals(entry2.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.key + "=" + this.val;
        }
    }

    protected class KeyView
    extends MapBackedView {
        protected KeyView() {
        }

        @Override
        public Iterator iterator() {
            return new TObjectHashIterator(TCustomHashMap.this);
        }

        @Override
        public boolean removeElement(Object object) {
            return null != TCustomHashMap.this.remove(object);
        }

        @Override
        public boolean containsElement(Object object) {
            return TCustomHashMap.this.contains(object);
        }
    }

    private abstract class MapBackedView
    extends AbstractSet
    implements Set,
    Iterable {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator iterator();

        public abstract boolean removeElement(Object var1);

        public abstract boolean containsElement(Object var1);

        @Override
        public boolean contains(Object object) {
            return this.containsElement(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.removeElement(object);
        }

        @Override
        public void clear() {
            TCustomHashMap.this.clear();
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TCustomHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator iterator = this.iterator();
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean isEmpty() {
            return TCustomHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public String toString() {
            Iterator iterator = this.iterator();
            if (!iterator.hasNext()) {
                return "{}";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            while (true) {
                Object e;
                stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
                if (!iterator.hasNext()) {
                    return stringBuilder.append('}').toString();
                }
                stringBuilder.append(", ");
            }
        }
    }

    protected class EntryView
    extends MapBackedView {
        protected EntryView() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator(TCustomHashMap.this);
        }

        public boolean removeElement(Map.Entry entry) {
            Object object;
            Object object2 = this.keyForEntry(entry);
            int n = TCustomHashMap.this.index(object2);
            if (n >= 0 && ((object = this.valueForEntry(entry)) == TCustomHashMap.this._values[n] || null != object && TCustomHashMap.this.strategy.equals(object, TCustomHashMap.this._values[n]))) {
                TCustomHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        public boolean containsElement(Map.Entry entry) {
            Object object = TCustomHashMap.this.get(this.keyForEntry(entry));
            Object v = entry.getValue();
            return v == object || null != object && TCustomHashMap.this.strategy.equals(object, v);
        }

        protected Object valueForEntry(Map.Entry entry) {
            return entry.getValue();
        }

        protected Object keyForEntry(Map.Entry entry) {
            return entry.getKey();
        }

        private final class EntryIterator
        extends TObjectHashIterator {
            EntryIterator(TCustomHashMap tCustomHashMap) {
                super(tCustomHashMap);
            }

            @Override
            public Entry objectAtIndex(int n) {
                return new Entry(TCustomHashMap.this._set[n], TCustomHashMap.this._values[n], n);
            }
        }
    }

    protected class ValueView
    extends MapBackedView {
        protected ValueView() {
        }

        @Override
        public Iterator iterator() {
            return new TObjectHashIterator(TCustomHashMap.this){

                @Override
                protected Object objectAtIndex(int n) {
                    return TCustomHashMap.this._values[n];
                }
            };
        }

        @Override
        public boolean containsElement(Object object) {
            return TCustomHashMap.this.containsValue(object);
        }

        @Override
        public boolean removeElement(Object object) {
            Object[] objectArray = TCustomHashMap.this._values;
            Object[] objectArray2 = TCustomHashMap.this._set;
            int n = objectArray.length;
            while (n-- > 0) {
                if ((objectArray2[n] == TObjectHash.FREE || objectArray2[n] == TObjectHash.REMOVED || object != objectArray[n]) && (null == objectArray[n] || !TCustomHashMap.this.strategy.equals(objectArray[n], object))) continue;
                TCustomHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }
    }

    private static final class EqProcedure
    implements TObjectObjectProcedure {
        private final Map _otherMap;

        EqProcedure(Map map) {
            this._otherMap = map;
        }

        @Override
        public final boolean execute(Object object, Object object2) {
            if (object2 == null && !this._otherMap.containsKey(object)) {
                return false;
            }
            Object v = this._otherMap.get(object);
            return v == object2 || v != null && v.equals(object2);
        }
    }

    private final class HashProcedure
    implements TObjectObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(Object object, Object object2) {
            this.h += HashFunctions.hash(object) ^ (object2 == null ? 0 : object2.hashCode());
            return true;
        }
    }
}

