/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TIntCollection;
import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TIntHash;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TIntObjectHashMap
extends TIntHash
implements TIntObjectMap,
Externalizable {
    static final long serialVersionUID = 1L;
    private final TIntObjectProcedure PUT_ALL_PROC = new TIntObjectProcedure(){

        @Override
        public boolean execute(int n, Object object) {
            TIntObjectHashMap.this.put(n, object);
            return true;
        }
    };
    protected transient Object[] _values;
    protected int no_entry_key;

    public TIntObjectHashMap() {
    }

    public TIntObjectHashMap(int n) {
        super(n);
        this.no_entry_key = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    public TIntObjectHashMap(int n, float f) {
        super(n, f);
        this.no_entry_key = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    public TIntObjectHashMap(int n, float f, int n2) {
        super(n, f);
        this.no_entry_key = n2;
    }

    public TIntObjectHashMap(TIntObjectMap tIntObjectMap) {
        this(tIntObjectMap.size(), 0.5f, tIntObjectMap.getNoEntryKey());
        this.putAll(tIntObjectMap);
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertKey(n4);
            this._values[n5] = objectArray[n3];
        }
    }

    @Override
    public int getNoEntryKey() {
        return this.no_entry_key;
    }

    @Override
    public boolean containsKey(int n) {
        return this.contains(n);
    }

    @Override
    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || null != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? null : this._values[n2];
    }

    @Override
    public Object put(int n, Object object) {
        int n2 = this.insertKey(n);
        return this.doPut(object, n2);
    }

    @Override
    public Object putIfAbsent(int n, Object object) {
        int n2 = this.insertKey(n);
        if (n2 < 0) {
            return this._values[-n2 - 1];
        }
        return this.doPut(object, n2);
    }

    private Object doPut(Object object, int n) {
        Object object2 = null;
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return object2;
    }

    @Override
    public Object remove(int n) {
        Object object = null;
        int n2 = this.index(n);
        if (n2 >= 0) {
            object = this._values[n2];
            this.removeAt(n2);
        }
        return object;
    }

    @Override
    protected void removeAt(int n) {
        this._values[n] = null;
        super.removeAt(n);
    }

    @Override
    public void putAll(Map map) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.put((Integer)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TIntObjectMap tIntObjectMap) {
        tIntObjectMap.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public TIntSet keySet() {
        return new KeyView();
    }

    @Override
    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    @Override
    public int[] keys(int[] nArray) {
        if (nArray.length < this._size) {
            nArray = new int[this._size];
        }
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    @Override
    public Collection valueCollection() {
        return new ValueView();
    }

    @Override
    public Object[] values() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    @Override
    public Object[] values(Object[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    @Override
    public TIntObjectIterator iterator() {
        return new TIntObjectHashIterator(this);
    }

    @Override
    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TIntObjectProcedure tIntObjectProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TIntObjectProcedure tIntObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n = nArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], objectArray[n])) continue;
                this.removeAt(n);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TIntObjectMap)) {
            return false;
        }
        TIntObjectMap tIntObjectMap = (TIntObjectMap)object;
        if (tIntObjectMap.size() != this.size()) {
            return false;
        }
        try {
            TIntObjectIterator tIntObjectIterator = this.iterator();
            while (tIntObjectIterator.hasNext()) {
                tIntObjectIterator.advance();
                int n = tIntObjectIterator.key();
                Object object2 = tIntObjectIterator.value();
                if (!(object2 == null ? tIntObjectMap.get(n) != null || !tIntObjectMap.containsKey(n) : !object2.equals(tIntObjectMap.get(n)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            n += HashFunctions.hash(this._set[n2]) ^ (objectArray[n2] == null ? 0 : objectArray[n2].hashCode());
        }
        return n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.no_entry_key);
        objectOutput.writeInt(this._size);
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            objectOutput.writeInt(this._set[n]);
            objectOutput.writeObject(this._values[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        super.readExternal(objectInput);
        this.no_entry_key = objectInput.readInt();
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInput.readInt();
            Object object = objectInput.readObject();
            this.put(n2, object);
        }
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TIntObjectProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(int n, Object object) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(n);
                stringBuilder.append("=");
                stringBuilder.append(object);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    class TIntObjectHashIterator
    extends THashPrimitiveIterator
    implements TIntObjectIterator {
        private final TIntObjectHashMap _map;

        public TIntObjectHashIterator(TIntObjectHashMap tIntObjectHashMap2) {
            super(tIntObjectHashMap2);
            this._map = tIntObjectHashMap2;
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public int key() {
            return this._map._set[this._index];
        }

        @Override
        public Object value() {
            return this._map._values[this._index];
        }

        @Override
        public Object setValue(Object object) {
            Object object2 = this.value();
            this._map._values[this._index] = object;
            return object2;
        }
    }

    private abstract class MapBackedView
    extends AbstractSet
    implements Set,
    Iterable {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator iterator();

        public abstract boolean removeElement(Object var1);

        public abstract boolean containsElement(Object var1);

        @Override
        public boolean contains(Object object) {
            return this.containsElement(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.removeElement(object);
        }

        @Override
        public void clear() {
            TIntObjectHashMap.this.clear();
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TIntObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator iterator = this.iterator();
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean isEmpty() {
            return TIntObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }

    protected class ValueView
    extends MapBackedView {
        protected ValueView() {
        }

        @Override
        public Iterator iterator() {
            return new TIntObjectValueHashIterator(TIntObjectHashMap.this){

                @Override
                protected Object objectAtIndex(int n) {
                    return TIntObjectHashMap.this._values[n];
                }
            };
        }

        @Override
        public boolean containsElement(Object object) {
            return TIntObjectHashMap.this.containsValue(object);
        }

        @Override
        public boolean removeElement(Object object) {
            Object[] objectArray = TIntObjectHashMap.this._values;
            byte[] byArray = TIntObjectHashMap.this._states;
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && (null == objectArray[n] || !objectArray[n].equals(object))) continue;
                TIntObjectHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        class TIntObjectValueHashIterator
        extends THashPrimitiveIterator
        implements Iterator {
            protected final TIntObjectHashMap _map;

            public TIntObjectValueHashIterator(TIntObjectHashMap tIntObjectHashMap) {
                super(tIntObjectHashMap);
                this._map = tIntObjectHashMap;
            }

            protected Object objectAtIndex(int n) {
                byte[] byArray = TIntObjectHashMap.this._states;
                Object object = this._map._values[n];
                if (byArray[n] != 1) {
                    return null;
                }
                return object;
            }

            public Object next() {
                this.moveToNextIndex();
                return this._map._values[this._index];
            }
        }
    }

    class KeyView
    implements TIntSet {
        KeyView() {
        }

        @Override
        public int getNoEntryValue() {
            return TIntObjectHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TIntObjectHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return TIntObjectHashMap.this._size == 0;
        }

        @Override
        public boolean contains(int n) {
            return TIntObjectHashMap.this.containsKey(n);
        }

        @Override
        public TIntIterator iterator() {
            return new TIntHashIterator(TIntObjectHashMap.this);
        }

        @Override
        public int[] toArray() {
            return TIntObjectHashMap.this.keys();
        }

        @Override
        public int[] toArray(int[] nArray) {
            return TIntObjectHashMap.this.keys(nArray);
        }

        @Override
        public boolean add(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int n) {
            return null != TIntObjectHashMap.this.remove(n);
        }

        @Override
        public boolean containsAll(Collection collection) {
            for (Object e : collection) {
                if (TIntObjectHashMap.this.containsKey((Integer)e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection tIntCollection) {
            if (tIntCollection == this) {
                return true;
            }
            TIntIterator tIntIterator = tIntCollection.iterator();
            while (tIntIterator.hasNext()) {
                if (TIntObjectHashMap.this.containsKey(tIntIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] nArray) {
            for (int n : nArray) {
                if (TIntObjectHashMap.this.containsKey(n)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection tIntCollection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] nArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(TIntCollection tIntCollection) {
            if (this == tIntCollection) {
                return false;
            }
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (tIntCollection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(int[] nArray) {
            boolean bl = false;
            Arrays.sort(nArray);
            int[] nArray2 = TIntObjectHashMap.this._set;
            byte[] byArray = TIntObjectHashMap.this._states;
            int n = nArray2.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || Arrays.binarySearch(nArray, nArray2[n]) >= 0) continue;
                TIntObjectHashMap.this.removeAt(n);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            for (Object e : collection) {
                int n;
                if (!(e instanceof Integer) || !this.remove(n = ((Integer)e).intValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(TIntCollection tIntCollection) {
            if (tIntCollection == this) {
                this.clear();
                return true;
            }
            boolean bl = false;
            TIntIterator tIntIterator = tIntCollection.iterator();
            while (tIntIterator.hasNext()) {
                int n = tIntIterator.next();
                if (!this.remove(n)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(int[] nArray) {
            boolean bl = false;
            int n = nArray.length;
            while (n-- > 0) {
                if (!this.remove(nArray[n])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            TIntObjectHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure tIntProcedure) {
            return TIntObjectHashMap.this.forEachKey(tIntProcedure);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof TIntSet)) {
                return false;
            }
            TIntSet tIntSet = (TIntSet)object;
            if (tIntSet.size() != this.size()) {
                return false;
            }
            int n = TIntObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TIntObjectHashMap.this._states[n] != 1 || tIntSet.contains(TIntObjectHashMap.this._set[n])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            int n2 = TIntObjectHashMap.this._states.length;
            while (n2-- > 0) {
                if (TIntObjectHashMap.this._states[n2] != 1) continue;
                n += HashFunctions.hash(TIntObjectHashMap.this._set[n2]);
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            boolean bl = true;
            int n = TIntObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TIntObjectHashMap.this._states[n] != 1) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(TIntObjectHashMap.this._set[n]);
            }
            return stringBuilder.toString();
        }

        class TIntHashIterator
        extends THashPrimitiveIterator
        implements TIntIterator {
            private final TIntHash _hash;

            public TIntHashIterator(TIntHash tIntHash) {
                super(tIntHash);
                this._hash = tIntHash;
            }

            @Override
            public int next() {
                this.moveToNextIndex();
                return this._hash._set[this._index];
            }
        }
    }
}

