/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TLongCollection;
import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TLongHash;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TLongObjectHashMap
extends TLongHash
implements TLongObjectMap,
Externalizable {
    static final long serialVersionUID = 1L;
    private final TLongObjectProcedure PUT_ALL_PROC = new TLongObjectProcedure(){

        @Override
        public boolean execute(long l, Object object) {
            TLongObjectHashMap.this.put(l, object);
            return true;
        }
    };
    protected transient Object[] _values;
    protected long no_entry_key;

    public TLongObjectHashMap() {
    }

    public TLongObjectHashMap(int n) {
        super(n);
        this.no_entry_key = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
    }

    public TLongObjectHashMap(int n, float f) {
        super(n, f);
        this.no_entry_key = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
    }

    public TLongObjectHashMap(int n, float f, long l) {
        super(n, f);
        this.no_entry_key = l;
    }

    public TLongObjectHashMap(TLongObjectMap tLongObjectMap) {
        this(tLongObjectMap.size(), 0.5f, tLongObjectMap.getNoEntryKey());
        this.putAll(tLongObjectMap);
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertKey(l);
            this._values[n4] = objectArray[n3];
        }
    }

    @Override
    public long getNoEntryKey() {
        return this.no_entry_key;
    }

    @Override
    public boolean containsKey(long l) {
        return this.contains(l);
    }

    @Override
    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || null != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(long l) {
        int n = this.index(l);
        return n < 0 ? null : this._values[n];
    }

    @Override
    public Object put(long l, Object object) {
        int n = this.insertKey(l);
        return this.doPut(object, n);
    }

    @Override
    public Object putIfAbsent(long l, Object object) {
        int n = this.insertKey(l);
        if (n < 0) {
            return this._values[-n - 1];
        }
        return this.doPut(object, n);
    }

    private Object doPut(Object object, int n) {
        Object object2 = null;
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return object2;
    }

    @Override
    public Object remove(long l) {
        Object object = null;
        int n = this.index(l);
        if (n >= 0) {
            object = this._values[n];
            this.removeAt(n);
        }
        return object;
    }

    @Override
    protected void removeAt(int n) {
        this._values[n] = null;
        super.removeAt(n);
    }

    @Override
    public void putAll(Map map) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.put((Long)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TLongObjectMap tLongObjectMap) {
        tLongObjectMap.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public TLongSet keySet() {
        return new KeyView();
    }

    @Override
    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    @Override
    public long[] keys(long[] lArray) {
        if (lArray.length < this._size) {
            lArray = new long[this._size];
        }
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    @Override
    public Collection valueCollection() {
        return new ValueView();
    }

    @Override
    public Object[] values() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    @Override
    public Object[] values(Object[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    @Override
    public TLongObjectIterator iterator() {
        return new TLongObjectHashIterator(this);
    }

    @Override
    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TLongObjectProcedure tLongObjectProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongObjectProcedure.execute(lArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TLongObjectProcedure tLongObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n = lArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || tLongObjectProcedure.execute(lArray[n], objectArray[n])) continue;
                this.removeAt(n);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TLongObjectMap)) {
            return false;
        }
        TLongObjectMap tLongObjectMap = (TLongObjectMap)object;
        if (tLongObjectMap.size() != this.size()) {
            return false;
        }
        try {
            TLongObjectIterator tLongObjectIterator = this.iterator();
            while (tLongObjectIterator.hasNext()) {
                tLongObjectIterator.advance();
                long l = tLongObjectIterator.key();
                Object object2 = tLongObjectIterator.value();
                if (!(object2 == null ? tLongObjectMap.get(l) != null || !tLongObjectMap.containsKey(l) : !object2.equals(tLongObjectMap.get(l)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            n += HashFunctions.hash(this._set[n2]) ^ (objectArray[n2] == null ? 0 : objectArray[n2].hashCode());
        }
        return n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.no_entry_key);
        objectOutput.writeInt(this._size);
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            objectOutput.writeLong(this._set[n]);
            objectOutput.writeObject(this._values[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        super.readExternal(objectInput);
        this.no_entry_key = objectInput.readLong();
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInput.readLong();
            Object object = objectInput.readObject();
            this.put(l, object);
        }
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TLongObjectProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(long l, Object object) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(l);
                stringBuilder.append("=");
                stringBuilder.append(object);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    class TLongObjectHashIterator
    extends THashPrimitiveIterator
    implements TLongObjectIterator {
        private final TLongObjectHashMap _map;

        public TLongObjectHashIterator(TLongObjectHashMap tLongObjectHashMap2) {
            super(tLongObjectHashMap2);
            this._map = tLongObjectHashMap2;
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public long key() {
            return this._map._set[this._index];
        }

        @Override
        public Object value() {
            return this._map._values[this._index];
        }

        @Override
        public Object setValue(Object object) {
            Object object2 = this.value();
            this._map._values[this._index] = object;
            return object2;
        }
    }

    private abstract class MapBackedView
    extends AbstractSet
    implements Set,
    Iterable {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator iterator();

        public abstract boolean removeElement(Object var1);

        public abstract boolean containsElement(Object var1);

        @Override
        public boolean contains(Object object) {
            return this.containsElement(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.removeElement(object);
        }

        @Override
        public void clear() {
            TLongObjectHashMap.this.clear();
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TLongObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator iterator = this.iterator();
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean isEmpty() {
            return TLongObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }

    protected class ValueView
    extends MapBackedView {
        protected ValueView() {
        }

        @Override
        public Iterator iterator() {
            return new TLongObjectValueHashIterator(TLongObjectHashMap.this){

                @Override
                protected Object objectAtIndex(int n) {
                    return TLongObjectHashMap.this._values[n];
                }
            };
        }

        @Override
        public boolean containsElement(Object object) {
            return TLongObjectHashMap.this.containsValue(object);
        }

        @Override
        public boolean removeElement(Object object) {
            Object[] objectArray = TLongObjectHashMap.this._values;
            byte[] byArray = TLongObjectHashMap.this._states;
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && (null == objectArray[n] || !objectArray[n].equals(object))) continue;
                TLongObjectHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        class TLongObjectValueHashIterator
        extends THashPrimitiveIterator
        implements Iterator {
            protected final TLongObjectHashMap _map;

            public TLongObjectValueHashIterator(TLongObjectHashMap tLongObjectHashMap) {
                super(tLongObjectHashMap);
                this._map = tLongObjectHashMap;
            }

            protected Object objectAtIndex(int n) {
                byte[] byArray = TLongObjectHashMap.this._states;
                Object object = this._map._values[n];
                if (byArray[n] != 1) {
                    return null;
                }
                return object;
            }

            public Object next() {
                this.moveToNextIndex();
                return this._map._values[this._index];
            }
        }
    }

    class KeyView
    implements TLongSet {
        KeyView() {
        }

        @Override
        public long getNoEntryValue() {
            return TLongObjectHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TLongObjectHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return TLongObjectHashMap.this._size == 0;
        }

        @Override
        public boolean contains(long l) {
            return TLongObjectHashMap.this.containsKey(l);
        }

        @Override
        public TLongIterator iterator() {
            return new TLongHashIterator(TLongObjectHashMap.this);
        }

        @Override
        public long[] toArray() {
            return TLongObjectHashMap.this.keys();
        }

        @Override
        public long[] toArray(long[] lArray) {
            return TLongObjectHashMap.this.keys(lArray);
        }

        @Override
        public boolean add(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(long l) {
            return null != TLongObjectHashMap.this.remove(l);
        }

        @Override
        public boolean containsAll(Collection collection) {
            for (Object e : collection) {
                if (TLongObjectHashMap.this.containsKey((Long)e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TLongCollection tLongCollection) {
            if (tLongCollection == this) {
                return true;
            }
            TLongIterator tLongIterator = tLongCollection.iterator();
            while (tLongIterator.hasNext()) {
                if (TLongObjectHashMap.this.containsKey(tLongIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(long[] lArray) {
            for (long l : lArray) {
                if (TLongObjectHashMap.this.containsKey(l)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TLongCollection tLongCollection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long[] lArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            TLongIterator tLongIterator = this.iterator();
            while (tLongIterator.hasNext()) {
                if (collection.contains(tLongIterator.next())) continue;
                tLongIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(TLongCollection tLongCollection) {
            if (this == tLongCollection) {
                return false;
            }
            boolean bl = false;
            TLongIterator tLongIterator = this.iterator();
            while (tLongIterator.hasNext()) {
                if (tLongCollection.contains(tLongIterator.next())) continue;
                tLongIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(long[] lArray) {
            boolean bl = false;
            Arrays.sort(lArray);
            long[] lArray2 = TLongObjectHashMap.this._set;
            byte[] byArray = TLongObjectHashMap.this._states;
            int n = lArray2.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || Arrays.binarySearch(lArray, lArray2[n]) >= 0) continue;
                TLongObjectHashMap.this.removeAt(n);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            for (Object e : collection) {
                long l;
                if (!(e instanceof Long) || !this.remove(l = ((Long)e).longValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(TLongCollection tLongCollection) {
            if (tLongCollection == this) {
                this.clear();
                return true;
            }
            boolean bl = false;
            TLongIterator tLongIterator = tLongCollection.iterator();
            while (tLongIterator.hasNext()) {
                long l = tLongIterator.next();
                if (!this.remove(l)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(long[] lArray) {
            boolean bl = false;
            int n = lArray.length;
            while (n-- > 0) {
                if (!this.remove(lArray[n])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            TLongObjectHashMap.this.clear();
        }

        @Override
        public boolean forEach(TLongProcedure tLongProcedure) {
            return TLongObjectHashMap.this.forEachKey(tLongProcedure);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof TLongSet)) {
                return false;
            }
            TLongSet tLongSet = (TLongSet)object;
            if (tLongSet.size() != this.size()) {
                return false;
            }
            int n = TLongObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TLongObjectHashMap.this._states[n] != 1 || tLongSet.contains(TLongObjectHashMap.this._set[n])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            int n2 = TLongObjectHashMap.this._states.length;
            while (n2-- > 0) {
                if (TLongObjectHashMap.this._states[n2] != 1) continue;
                n += HashFunctions.hash(TLongObjectHashMap.this._set[n2]);
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            boolean bl = true;
            int n = TLongObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TLongObjectHashMap.this._states[n] != 1) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(TLongObjectHashMap.this._set[n]);
            }
            return stringBuilder.toString();
        }

        class TLongHashIterator
        extends THashPrimitiveIterator
        implements TLongIterator {
            private final TLongHash _hash;

            public TLongHashIterator(TLongHash tLongHash) {
                super(tLongHash);
                this._hash = tLongHash;
            }

            @Override
            public long next() {
                this.moveToNextIndex();
                return this._hash._set[this._index];
            }
        }
    }
}

