/*
 * Decompiled with CFR 0.152.
 */
package rainwarrior.hooks;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.InvalidKeyException;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import rainwarrior.hooks.DefaultModTileHandler;
import rainwarrior.hooks.DefaultTileHandler;
import rainwarrior.hooks.ITileHandler;
import rainwarrior.hooks.ImmovableTileHandler;
import rainwarrior.hooks.MovingTileRegistry$;
import rainwarrior.trussmod.TrussMod$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class MovingTileRegistry$
implements ITileHandler {
    public static final MovingTileRegistry$ MODULE$;
    private Multimap blockRegistry;
    private Map blockMap;
    private Map idMap;
    private Map idMetaMap;
    private Map modMap;
    private Map handlerNameMap;
    private ITileHandler defaultHandler;
    private final Regex rId;
    private final Regex rIdMeta;
    private volatile byte bitmap$0;

    static {
        new MovingTileRegistry$();
    }

    private Multimap blockRegistry$lzycompute() {
        MovingTileRegistry$ movingTileRegistry$ = this;
        synchronized (movingTileRegistry$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Field field = GameRegistry.class.getDeclaredField("blockRegistry");
                ((AccessibleObject)field).setAccessible(true);
                this.blockRegistry = (Multimap)field.get(null);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.blockRegistry;
        }
    }

    private Map blockMap$lzycompute() {
        MovingTileRegistry$ movingTileRegistry$ = this;
        synchronized (movingTileRegistry$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blockMap = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.collectionAsScalaIterable(this.blockRegistry().entries()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3 apply(Map.Entry e) {
                        ModContainer k = (ModContainer)e.getKey();
                        BlockProxy v = (BlockProxy)e.getValue();
                        return new Tuple3((Object)e, (Object)k, (Object)v);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2 apply(Tuple3 x$1) {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            ModContainer k = (ModContainer)tuple3._2();
                            BlockProxy v = (BlockProxy)tuple3._3();
                            Tuple2 tuple2 = new Tuple2((Object)((Block)v), (Object)k.getModId());
                            return tuple2;
                        }
                        throw new MatchError((Object)tuple3);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.blockMap;
        }
    }

    public Multimap blockRegistry() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.blockRegistry$lzycompute() : this.blockRegistry;
    }

    public Map blockMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blockMap$lzycompute() : this.blockMap;
    }

    public Map idMap() {
        return this.idMap;
    }

    public void idMap_$eq(Map x$1) {
        this.idMap = x$1;
    }

    public Map idMetaMap() {
        return this.idMetaMap;
    }

    public void idMetaMap_$eq(Map x$1) {
        this.idMetaMap = x$1;
    }

    public Map modMap() {
        return this.modMap;
    }

    public void modMap_$eq(Map x$1) {
        this.modMap = x$1;
    }

    public Map handlerNameMap() {
        return this.handlerNameMap;
    }

    public void handlerNameMap_$eq(Map x$1) {
        this.handlerNameMap = x$1;
    }

    public ITileHandler defaultHandler() {
        return this.defaultHandler;
    }

    public void defaultHandler_$eq(ITileHandler x$1) {
        this.defaultHandler = x$1;
    }

    public ITileHandler resolveHandler(String handler) {
        return (ITileHandler)this.handlerNameMap().getOrElse((Object)handler, (Function0)new Serializable(handler){
            public static final long serialVersionUID = 0L;
            private final String handler$1;

            public final Nothing$ apply() {
                throw new InvalidKeyException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No mod handler named '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.handler$1})));
            }
            {
                this.handler$1 = handler$1;
            }
        });
    }

    public void setDefaultHandler(String handler) {
        this.defaultHandler_$eq(this.resolveHandler(handler));
    }

    public Regex rId() {
        return this.rId;
    }

    public Regex rIdMeta() {
        return this.rIdMeta;
    }

    public void setHandler(String mod, String handler) {
        ITileHandler h = this.resolveHandler(handler);
        String string = mod;
        Option option = this.rId().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String id = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.idMap_$eq(this.idMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id)).toInt())), (Object)h)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Option option2 = this.rIdMeta().unapplySeq((Object)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String id = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String meta = (String)((LinearSeqOptimized)option2.get()).apply(1);
                this.idMetaMap_$eq(this.idMetaMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(id)).toInt(), new StringOps(Predef$.MODULE$.augmentString(meta)).toInt())), (Object)h)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string2 = string;
                if (!("default" != null ? !"default".equals(string2) : string2 != null)) {
                    this.defaultHandler_$eq(h);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string3 = string;
                    if (!("vanilla" != null ? !"vanilla".equals(string3) : string3 != null)) {
                        this.modMap_$eq(this.modMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)None$.MODULE$), (Object)h)));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.modMap_$eq(this.modMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Some((Object)string)), (Object)h)));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
    }

    public ITileHandler getHandler(int id, int meta) {
        return (ITileHandler)this.idMetaMap().getOrElse((Object)new Tuple2.mcII.sp(id, meta), (Function0)new Serializable(id){
            public static final long serialVersionUID = 0L;
            public final int id$1;

            public final ITileHandler apply() {
                return (ITileHandler)MovingTileRegistry$.MODULE$.idMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.id$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getHandler.1 $outer;

                    public final ITileHandler apply() {
                        Block block = Block.field_71973_m[this.$outer.id$1];
                        return (ITileHandler)MovingTileRegistry$.MODULE$.modMap().getOrElse((Object)MovingTileRegistry$.MODULE$.blockMap().get((Object)block), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ITileHandler apply() {
                                return MovingTileRegistry$.MODULE$.defaultHandler();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.id$1 = id$1;
            }
        });
    }

    @Override
    public boolean canMove(World world, int x, int y, int z) {
        boolean bl;
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[id];
        if (block != null) {
            bl = this.getHandler(id, meta).canMove(world, x, y, z);
        } else {
            TrussMod$.MODULE$.log().severe(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canMove: invalid block: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{block})));
            bl = false;
        }
        return bl;
    }

    @Override
    public void move(World world, int x, int y, int z, ForgeDirection dirTo) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[id];
        if (block != null) {
            this.getHandler(id, meta).move(world, x, y, z, dirTo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            TrussMod$.MODULE$.log().severe(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"move: invalid block: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{block})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private MovingTileRegistry$() {
        MODULE$ = this;
        this.idMap = Predef$.MODULE$.Map().empty();
        this.idMetaMap = Predef$.MODULE$.Map().empty();
        this.modMap = Predef$.MODULE$.Map().empty();
        this.handlerNameMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"default-soft"), (Object)new DefaultTileHandler()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"default-hard"), (Object)new DefaultModTileHandler()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"immovable"), (Object)new ImmovableTileHandler())}));
        this.defaultHandler = this.resolveHandler("default-hard");
        this.rId = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(\\d+)"})).raw((Seq)Nil$.MODULE$))).r();
        this.rIdMeta = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(\\d+)m(\\d+)"})).raw((Seq)Nil$.MODULE$))).r();
    }
}

