/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import portablejim.veinminer.api.VeinminerStartCheck;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.event.EntityDropHook;
import portablejim.veinminer.lib.Logger;
import portablejim.veinminer.lib.ModInfo;
import portablejim.veinminer.network.ConnectionHandler;
import portablejim.veinminer.network.PacketHandler;
import portablejim.veinminer.proxy.CommonProxy;
import portablejim.veinminer.server.MinerCommand;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;

@Mod(modid="VeinMiner", name="Vein Miner", version="0.8.3", acceptedMinecraftVersions="[1.5,1.6)", certificateFingerprint="ad915af2d8bfa7bff330f4bb5a0a4551ef9e0aed")
@NetworkMod(clientSideRequired=false, serverSideRequired=false, channels={"portablejim_vm"}, packetHandler=PacketHandler.class, connectionHandler=ConnectionHandler.class, versionBounds="[0.8,0.9)")
public class VeinMiner {
    ConfigurationValues configurationValues;
    @Mod.Metadata(value="VeinMiner")
    public static ModMetadata metadata;
    @Mod.Instance(value="VeinMiner")
    public static VeinMiner instance;
    @SidedProxy(clientSide="portablejim.veinminer.proxy.ClientProxy", serverSide="portablejim.veinminer.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        this.configurationValues = new ConfigurationValues(event.getSuggestedConfigurationFile());
        proxy.setupConfig(this.configurationValues);
        proxy.registerKeybind();
        metadata = event.getModMetadata();
        VeinMiner.metadata.modId = "VeinMiner";
        VeinMiner.metadata.name = "Vein Miner";
        VeinMiner.metadata.description = "When a configured block is harvested a chain reaction is initiated to break connected blocks of the same type. Takes durability and health for each block mined.";
        VeinMiner.metadata.version = "0.8.3";
        VeinMiner.metadata.url = "http://minecraft.curseforge.com/mc-mods/veinminer/";
        VeinMiner.metadata.updateUrl = "";
        VeinMiner.metadata.authorList = Lists.newArrayList((Object[])new String[]{"portablejim"});
        VeinMiner.metadata.credits = "Inspired by ConnectedDestruction by DaftPVF (currently maintained by bspkrs).";
        VeinMiner.metadata.requiredMods = Sets.newHashSet((Object[])new ArtifactVersion[]{new DefaultArtifactVersion("Forge", true)});
        VeinMiner.metadata.autogenerated = false;
        LanguageRegistry.instance().loadLocalization("/assets/veinminer/lang/en_US.lang", "en_US", false);
    }

    @Mod.FingerprintWarning
    public void fingerprintWarning(FMLFingerprintViolationEvent event) {
        FMLLog.getLogger().warning(String.format("%s mod is not properly signed.", "VeinMiner"));
        FMLLog.getLogger().warning("This may be a copy somebody has modified, or it may be I just forgot to sign it myself.");
        FMLLog.getLogger().warning("Whatever the reason, it's probably ok.");
        FMLLog.getLogger().warning(String.format("Expected fingerprint: %s", event.expectedFingerprint));
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        String fileName;
        MinecraftForge.EVENT_BUS.register((Object)new EntityDropHook());
        ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("VeinMiner");
        if (thisMod != null && ((fileName = thisMod.getSource().getName()).contains("-dev") || !fileName.contains(".jar"))) {
            ModInfo.DEBUG_MODE = true;
            Logger.debug("Enabling debug mode", new Object[0]);
        }
    }

    @Mod.ServerStarted
    public void serverStarted(FMLServerStartedEvent event) {
        new MinerServer(this.configurationValues);
        ServerCommandManager serverCommandManger = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        serverCommandManger.func_71560_a((ICommand)new MinerCommand());
    }

    public void blockMined(World world, EntityPlayerMP player, int x, int y, int z, boolean harvestBlockSuccess, BlockID blockId) {
        Logger.debug("Block mined at %d,%d,%d, result %b, block id is %d:%d", x, y, z, harvestBlockSuccess, blockId.id, blockId.metadata);
        if (blockId.id > Block.field_71973_m.length || Block.field_71973_m[blockId.id] == null || !player.func_71062_b(Block.field_71973_m[blockId.id])) {
            return;
        }
        if (!harvestBlockSuccess) {
            VeinminerStartCheck startEvent = new VeinminerStartCheck(player, blockId.id, blockId.metadata);
            MinecraftForge.EVENT_BUS.post((Event)startEvent);
            if (!startEvent.allowVeinminerStart) {
                return;
            }
        }
        MinerInstance ins = new MinerInstance(world, player, x, y, z, blockId, MinerServer.instance);
        ins.mineVein(x, y, z);
    }
}

