/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.asm;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.HashMap;
import java.util.logging.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import portablejim.veinminer.asm.GenericTransformer;
import portablejim.veinminer.lib.Logger;
import portablejim.veinminer.util.BlockID;

public class ItemInWorldManagerTransformer
extends GenericTransformer
implements IClassTransformer {
    final String targetClassName = "portablejim/veinminer/VeinMiner";
    final String targetClassType = "Lportablejim/veinminer/VeinMiner;";
    final String targetMethodName = "blockMined";
    final String targetMethodType = "(%s%sIIIZ%s)V";
    final String blockIdClassName = "portablejim/veinminer/util/BlockID";

    public ItemInWorldManagerTransformer() {
        srgMappings = new HashMap();
        srgMappings.put("uncheckedTryHarvestBlock", "func_73082_a");
        srgMappings.put("tryHarvestBlock", "func_73084_b");
        srgMappings.put("theWorld", "field_73092_a");
        srgMappings.put("thisPlayerMP", "field_73090_b");
        srgMappings.put("destroyBlockInWorldPartially", "func_72888_f");
        srgMappings.put("onBlockClicked", "func_73074_a");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if ("net.minecraft.item.ItemInWorldManager".equals(transformedName)) {
            this.obfuscated = !transformedName.equals(name);
            bytes = this.transformItemInWorldManager(name, bytes);
        }
        return bytes;
    }

    private InsnList buildBlockIdFunctionCall(String obfuscatedClassName, String worldType, int blockVarIndex) {
        InsnList blockIdFunctionCall = new InsnList();
        blockIdFunctionCall.add((AbstractInsnNode)new TypeInsnNode(187, "portablejim/veinminer/util/BlockID"));
        blockIdFunctionCall.add((AbstractInsnNode)new InsnNode(89));
        blockIdFunctionCall.add((AbstractInsnNode)new VarInsnNode(25, 0));
        blockIdFunctionCall.add((AbstractInsnNode)new FieldInsnNode(180, obfuscatedClassName.replace(".", "/"), this.getCorrectName("theWorld"), (String)this.typemap.get(this.getCorrectName("theWorld"))));
        blockIdFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 1));
        blockIdFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 2));
        blockIdFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 3));
        blockIdFunctionCall.add((AbstractInsnNode)new MethodInsnNode(183, "portablejim/veinminer/util/BlockID", "<init>", String.format("(%sIII)V", worldType)));
        blockIdFunctionCall.add((AbstractInsnNode)new VarInsnNode(58, blockVarIndex));
        return blockIdFunctionCall;
    }

    private int insertCallAfterTryHarvestBlockFunction(MethodNode curMethod, String obfuscatedClassName) throws IndexOutOfBoundsException {
        return this.insertCallAfterTryHarvestBlockFunction(curMethod, obfuscatedClassName, 0);
    }

    private int insertCallAfterTryHarvestBlockFunction(MethodNode curMethod, String obfuscatedClassName, int startIndex) throws IndexOutOfBoundsException {
        LocalVariablesSorter varSorter = new LocalVariablesSorter(curMethod.access, curMethod.desc, (MethodVisitor)curMethod);
        String worldType = (String)this.typemap.get(this.getCorrectName("theWorld"));
        String playerType = (String)this.typemap.get(this.getCorrectName("thisPlayerMP"));
        while (!this.isMethodWithName(curMethod.instructions.get(startIndex), "tryHarvestBlock")) {
            ++startIndex;
        }
        while (curMethod.instructions.get(--startIndex).getType() == 2) {
        }
        int blockVarIndex = varSorter.newLocal(Type.getType(BlockID.class));
        curMethod.instructions.insert(curMethod.instructions.get(startIndex), this.buildBlockIdFunctionCall(obfuscatedClassName, worldType, blockVarIndex));
        ++startIndex;
        while (!this.isMethodWithName(curMethod.instructions.get(startIndex), "tryHarvestBlock")) {
            ++startIndex;
        }
        int newVarIndex = varSorter.newLocal(Type.BOOLEAN_TYPE);
        VarInsnNode newVar = new VarInsnNode(54, newVarIndex);
        curMethod.instructions.insert(curMethod.instructions.get(startIndex), (AbstractInsnNode)newVar);
        ++startIndex;
        InsnList veinMinerFunctionCall = new InsnList();
        veinMinerFunctionCall.add((AbstractInsnNode)new FieldInsnNode(178, "portablejim/veinminer/VeinMiner", "instance", "Lportablejim/veinminer/VeinMiner;"));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(25, 0));
        veinMinerFunctionCall.add((AbstractInsnNode)new FieldInsnNode(180, obfuscatedClassName.replace(".", "/"), this.getCorrectName("theWorld"), (String)this.typemap.get(this.getCorrectName("theWorld"))));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(25, 0));
        veinMinerFunctionCall.add((AbstractInsnNode)new FieldInsnNode(180, obfuscatedClassName.replace(".", "/"), this.getCorrectName("thisPlayerMP"), (String)this.typemap.get(this.getCorrectName("thisPlayerMP"))));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 1));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 2));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, 3));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(21, newVarIndex));
        veinMinerFunctionCall.add((AbstractInsnNode)new VarInsnNode(25, blockVarIndex));
        String blockIdClassType = String.format("L%s;", "portablejim/veinminer/util/BlockID");
        veinMinerFunctionCall.add((AbstractInsnNode)new MethodInsnNode(182, "portablejim/veinminer/VeinMiner", "blockMined", String.format("(%s%sIIIZ%s)V", worldType, playerType, blockIdClassType)));
        curMethod.instructions.insert(curMethod.instructions.get(startIndex), veinMinerFunctionCall);
        ++startIndex;
        while (curMethod.instructions.get(startIndex).getOpcode() != 87) {
            ++startIndex;
        }
        curMethod.instructions.remove(curMethod.instructions.get(startIndex));
        return startIndex;
    }

    public byte[] transformItemInWorldManager(String obfuscatedClassName, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (FieldNode variable : classNode.fields) {
            String srgVariableName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(obfuscatedClassName, variable.name, variable.desc);
            if (!this.getCorrectName("theWorld").equals(srgVariableName) && !this.getCorrectName("thisPlayerMP").equals(srgVariableName)) continue;
            this.typemap.put(srgVariableName, variable.desc);
        }
        try {
            for (MethodNode curMethod : classNode.methods) {
                String srgFunctionName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(obfuscatedClassName, curMethod.name, curMethod.desc);
                if (this.getCorrectName("uncheckedTryHarvestBlock").equals(srgFunctionName)) {
                    Logger.debug("Inserting call to uncheckedTryHarvestBlock (%s)", srgFunctionName);
                    this.insertCallAfterTryHarvestBlockFunction(curMethod, obfuscatedClassName);
                    continue;
                }
                if (!this.getCorrectName("onBlockClicked").equals(srgFunctionName)) continue;
                Logger.debug("Inserting call to onBlockClicked (%s)", srgFunctionName);
                int afterFirst = this.insertCallAfterTryHarvestBlockFunction(curMethod, obfuscatedClassName);
                this.insertCallAfterTryHarvestBlockFunction(curMethod, obfuscatedClassName, afterFirst);
            }
        }
        catch (IndexOutOfBoundsException e) {
            FMLLog.getLogger().log(Level.WARNING, "[%s] Problem inserting all required code. This mod may not function correctly. Please report a bug.", "Vein Miner");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

