/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.configuration;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.util.BlockID;

public class ConfigurationSettings {
    private ConfigurationValues configValues;
    private List[] blockWhitelist;
    private ArrayList blockCongruenceList;
    private HashMap blockCongruenceMap;
    private Set[] toolIds;
    private int blockLimit;
    private int radiusLimit;
    private int blocksPerTick;
    private boolean enableAllBlocks;
    private boolean enableAllTools;
    private int preferredMode;

    public ConfigurationSettings(ConfigurationValues configValues) {
        this.configValues = configValues;
        this.toolIds = new Set[ToolType.values().length];
        for (ToolType tool : ToolType.values()) {
            this.toolIds[tool.ordinal()] = new HashSet();
        }
        this.blockWhitelist = new ArrayList[ToolType.values().length];
        for (ToolType tool : ToolType.values()) {
            this.blockWhitelist[tool.ordinal()] = new ArrayList();
        }
        this.blockCongruenceList = new ArrayList();
        this.blockCongruenceMap = new HashMap();
        this.parseConfigValues();
    }

    private void parseConfigValues() {
        this.setBlockWhitelist(ToolType.AXE, this.configValues.AXE_BLOCK_ID_LIST);
        this.setBlockWhitelist(ToolType.PICKAXE, this.configValues.PICKAXE_BLOCK_ID_LIST);
        this.setBlockWhitelist(ToolType.SHOVEL, this.configValues.SHOVEL_BLOCK_ID_LIST);
        this.setToolIds(ToolType.AXE, this.configValues.AXE_ID_LIST);
        this.setToolIds(ToolType.PICKAXE, this.configValues.PICKAXE_ID_LIST);
        this.setToolIds(ToolType.SHOVEL, this.configValues.SHOVEL_ID_LIST);
        this.setBlockLimit(this.configValues.BLOCK_LIMIT);
        this.setBlocksPerTick(this.configValues.BLOCKS_PER_TICK);
        this.setRadiusLimit(this.configValues.RADIUS_LIMIT);
        this.setBlockCongruenceList(this.configValues.BLOCK_EQUIVALENCY_LIST);
        this.setEnableAllBlocks(this.configValues.ENABLE_ALL_BLOCKS);
        this.setEnableAllTools(this.configValues.ENABLE_ALL_TOOLS);
        this.setPreferredMode(this.configValues.CLIENT_PREFERRED_MODE, "sneak");
    }

    public boolean getEnableAllBlocks() {
        return this.enableAllBlocks;
    }

    void setEnableAllBlocks(boolean enableAllBlocks) {
        this.enableAllBlocks = enableAllBlocks;
    }

    public boolean getEnableAllTools() {
        return this.enableAllTools;
    }

    void setEnableAllTools(boolean enableAllTools) {
        this.enableAllTools = enableAllTools;
    }

    void setBlockWhitelist(ToolType tool, String whitelist) {
        String[] blocksString;
        for (String blockString : blocksString = whitelist.split(",")) {
            BlockID newBlock = new BlockID(blockString, ":");
            this.blockWhitelist[tool.ordinal()].add(newBlock);
        }
    }

    public void addBlockToWhitelist(ToolType tool, BlockID block) {
        this.blockWhitelist[tool.ordinal()].add(block);
    }

    public void removeBlockFromWhitelist(ToolType tool, BlockID block) {
        this.blockWhitelist[tool.ordinal()].remove(block);
    }

    public void clearBlockWhitelist() {
        for (ToolType tool : ToolType.values()) {
            this.blockWhitelist[tool.ordinal()].clear();
        }
    }

    public String getBlockWhitelist(ToolType tool) {
        return Joiner.on((char)',').join((Iterable)this.blockWhitelist[tool.ordinal()]);
    }

    public boolean whiteListHasBlockId(ToolType tool, BlockID targetBlock) {
        return this.blockWhitelist[tool.ordinal()].contains(targetBlock);
    }

    void setBlockCongruenceList(String congruenceList) {
        String[] blocksString;
        for (String congruentBlocks : blocksString = congruenceList.split(",")) {
            int newId = this.blockCongruenceList.size();
            HashSet<BlockID> newCongruentBlocks = new HashSet<BlockID>();
            if (!congruentBlocks.contains("=")) continue;
            for (String blockString : congruentBlocks.split("=")) {
                BlockID newBlockId = new BlockID(blockString);
                newCongruentBlocks.add(newBlockId);
                if (this.blockCongruenceMap.containsKey(newBlockId)) {
                    newId = (Integer)this.blockCongruenceMap.get(newBlockId);
                }
                this.blockCongruenceMap.put(newBlockId, newId);
            }
            newCongruentBlocks.addAll(newCongruentBlocks);
            if (newId < this.blockCongruenceList.size()) {
                ((Set)this.blockCongruenceList.get(newId)).addAll(newCongruentBlocks);
                continue;
            }
            this.blockCongruenceList.add(newId, newCongruentBlocks);
        }
    }

    public String getBlockCongruenceList() {
        ArrayList<String> congruenceGroups = new ArrayList<String>();
        for (Set group : this.blockCongruenceList) {
            congruenceGroups.add(Joiner.on((char)'-').join((Iterable)group));
        }
        return Joiner.on((char)',').join(congruenceGroups);
    }

    public HashMap getBlockCongruenceMap() {
        return this.blockCongruenceMap;
    }

    public Set getCongruentBlocks(BlockID targetBlock) {
        int listId = (Integer)this.blockCongruenceMap.get(targetBlock);
        return (Set)this.blockCongruenceList.get(listId);
    }

    public boolean areBlocksCongruent(BlockID block1, BlockID block2) {
        BlockID block1NoMeta = new BlockID(block1.id, block1.metadata);
        block1NoMeta.metadata = -1;
        BlockID block2NoMeta = new BlockID(block2.id, block2.metadata);
        block2NoMeta.metadata = -1;
        if (!this.blockCongruenceMap.containsKey(block1) && !this.blockCongruenceMap.containsKey(block1NoMeta)) {
            return false;
        }
        int targetBlock1 = this.blockCongruenceMap.containsKey(block1) ? (Integer)this.blockCongruenceMap.get(block1) : (Integer)this.blockCongruenceMap.get(block1NoMeta);
        if (!this.blockCongruenceMap.containsKey(block2) && !this.blockCongruenceMap.containsKey(block2NoMeta)) {
            return false;
        }
        int targetBlock2 = this.blockCongruenceMap.containsKey(block2) ? (Integer)this.blockCongruenceMap.get(block2) : (Integer)this.blockCongruenceMap.get(block2NoMeta);
        return targetBlock1 == targetBlock2;
    }

    void setToolIds(ToolType tool, String ids) {
        String[] toolsString;
        for (String idString : toolsString = ids.split(",")) {
            int newToolId;
            try {
                newToolId = Integer.parseInt(idString);
            }
            catch (NumberFormatException e) {
                continue;
            }
            this.toolIds[tool.ordinal()].add(newToolId);
        }
    }

    public void addTool(ToolType tool, int id) {
        this.toolIds[tool.ordinal()].add(id);
    }

    public void removeTool(ToolType tool, int id) {
        this.toolIds[tool.ordinal()].remove(id);
    }

    public String getToolIds(ToolType tool) {
        return Joiner.on((char)',').join((Iterable)this.toolIds[tool.ordinal()]);
    }

    public int getBlockLimit() {
        return this.blockLimit;
    }

    public void setBlockLimit(int blockLimit) {
        if (blockLimit < -1) {
            this.radiusLimit = -1;
        }
        this.blockLimit = blockLimit;
    }

    public int getRadiusLimit() {
        return this.radiusLimit;
    }

    public void setRadiusLimit(int radiusLimit) {
        if (radiusLimit < -1) {
            radiusLimit = -1;
        } else if (radiusLimit > 1000) {
            radiusLimit = 100;
        }
        this.radiusLimit = radiusLimit;
    }

    public int getBlocksPerTick() {
        return this.blocksPerTick;
    }

    public void setBlocksPerTick(int blocksPerTick) {
        if (blocksPerTick < -1) {
            blocksPerTick = -1;
        } else if (blocksPerTick > 1000) {
            blocksPerTick = 100;
        }
        this.blocksPerTick = blocksPerTick;
    }

    public boolean toolIsOfType(ItemStack tool, ToolType type) {
        return tool == null || this.toolIds[type.ordinal()].contains(tool.field_77993_c);
    }

    boolean setPreferredMode(String modeString, String fallback) {
        if ("auto".equals(modeString)) {
            this.preferredMode = 0;
            return true;
        }
        if ("sneak".equals(modeString)) {
            this.preferredMode = 1;
            return true;
        }
        if ("no_sneak".equals(modeString)) {
            this.preferredMode = 2;
            return true;
        }
        if (fallback != null) {
            this.setPreferredMode(fallback, null);
        }
        return false;
    }

    public int getPreferredMode() {
        return this.preferredMode;
    }

    public String getPreferredModeString() {
        switch (this.preferredMode) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "sneak";
            }
            case 2: {
                return "no_sneak";
            }
        }
        return "";
    }

    public void saveConfigs() {
        this.configValues.AXE_BLOCK_ID_LIST = this.getBlockWhitelist(ToolType.AXE);
        this.configValues.PICKAXE_BLOCK_ID_LIST = this.getBlockWhitelist(ToolType.PICKAXE);
        this.configValues.SHOVEL_BLOCK_ID_LIST = this.getBlockWhitelist(ToolType.SHOVEL);
        this.configValues.AXE_ID_LIST = this.getToolIds(ToolType.AXE);
        this.configValues.PICKAXE_ID_LIST = this.getToolIds(ToolType.PICKAXE);
        this.configValues.SHOVEL_ID_LIST = this.getToolIds(ToolType.SHOVEL);
        this.configValues.BLOCK_LIMIT = this.getBlockLimit();
        this.configValues.BLOCKS_PER_TICK = this.getBlocksPerTick();
        this.configValues.RADIUS_LIMIT = this.getRadiusLimit();
        this.configValues.BLOCK_EQUIVALENCY_LIST = this.getBlockCongruenceList();
        this.configValues.ENABLE_ALL_BLOCKS = this.getEnableAllBlocks();
        this.configValues.ENABLE_ALL_TOOLS = this.getEnableAllTools();
        this.configValues.CLIENT_PREFERRED_MODE = this.getPreferredModeString();
        this.configValues.saveConfigFile();
    }

    public static enum ToolType {
        PICKAXE,
        SHOVEL,
        AXE;

    }
}

