/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerEvent;
import portablejim.veinminer.api.VeinminerPostUseTool;
import portablejim.veinminer.api.VeinminerStartCheck;
import portablejim.veinminer.api.VeinminerToolCheck;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.event.InstanceTicker;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.server.PlayerStatus;
import portablejim.veinminer.util.BlockID;
import portablejim.veinminer.util.ItemStackID;
import portablejim.veinminer.util.Point;

public class MinerInstance {
    public MinerServer serverInstance;
    private ConcurrentLinkedQueue destroyQueue = new ConcurrentLinkedQueue();
    private HashSet awaitingEntityDrop = new HashSet();
    private LinkedHashMap drops = new LinkedHashMap();
    private World world;
    private EntityPlayerMP player;
    private BlockID targetBlock;
    private boolean finished;
    private ItemStack usedItem;
    private int numBlocksMined;
    private Point initalBlock;
    private static final int MIN_HUNGER = 1;

    public MinerInstance(World world, EntityPlayerMP player, int x, int y, int z, BlockID blockID, MinerServer server) {
        this.world = world;
        this.player = player;
        this.targetBlock = blockID;
        this.finished = false;
        this.serverInstance = server;
        this.usedItem = player.func_71045_bC();
        this.numBlocksMined = 1;
        this.initalBlock = new Point(x, y, z);
        this.serverInstance.addInstance(this);
        TickRegistry.registerTickHandler((ITickHandler)new InstanceTicker(this), (Side)Side.SERVER);
    }

    private boolean shouldContinue() {
        String playerName;
        PlayerStatus playerStatus;
        FoodStats food;
        if (!this.serverInstance.getConfigurationSettings().getEnableAllTools() && this.player.func_71045_bC() == null) {
            VeinminerToolCheck toolCheck = new VeinminerToolCheck(this.player);
            MinecraftForge.EVENT_BUS.post((Event)toolCheck);
            if (toolCheck.allowTool) {
                this.finished = false;
            } else {
                Block testBlock = Block.field_71981_t;
                PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck((EntityPlayer)this.player, testBlock, false);
                MinecraftForge.EVENT_BUS.post((Event)event);
                boolean bl = this.finished = !event.success;
            }
        }
        if (this.usedItem == null) {
            if (this.player.func_71045_bC() != null) {
                this.finished = true;
            }
        } else if (this.player.func_71045_bC() == null || !this.player.func_71045_bC().func_77969_a(this.usedItem)) {
            this.finished = true;
        }
        if ((food = this.player.func_71024_bL()).func_75116_a() < 1) {
            this.finished = true;
            String problem = "mod.veinminer.finished.tooHungry";
            if (this.serverInstance.playerHasClient(this.player.func_70023_ak())) {
                this.player.func_71035_c(problem);
            } else {
                this.player.func_71035_c(LanguageRegistry.instance().getStringLocalization(problem));
            }
        }
        if ((playerStatus = this.serverInstance.getPlayerStatus(playerName = this.player.func_70023_ak())) == null) {
            this.finished = true;
        } else if (playerStatus == PlayerStatus.DISABLED || playerStatus == PlayerStatus.INACTIVE || playerStatus == PlayerStatus.SNEAK_ACTIVE && !this.player.func_70093_af() || playerStatus == PlayerStatus.SNEAK_INACTIVE && this.player.func_70093_af()) {
            this.finished = true;
        }
        int blockLimit = this.serverInstance.getConfigurationSettings().getBlockLimit();
        if (this.numBlocksMined >= blockLimit && blockLimit != -1) {
            this.finished = true;
        }
        return !this.finished;
    }

    private boolean toolAllowedForBlock(ItemStack tool, BlockID block) {
        for (ConfigurationSettings.ToolType type : ConfigurationSettings.ToolType.values()) {
            if (!this.serverInstance.getConfigurationSettings().toolIsOfType(tool, type)) continue;
            return this.serverInstance.getConfigurationSettings().whiteListHasBlockId(type, block);
        }
        return false;
    }

    private void mineBlock(int x, int y, int z) {
        Point newPoint = new Point(x, y, z);
        this.awaitingEntityDrop.add(newPoint);
        boolean success = this.player.field_71134_c.func_73084_b(x, y, z);
        ++this.numBlocksMined;
        VeinminerPostUseTool toolUsedEvent = new VeinminerPostUseTool(this.player);
        MinecraftForge.EVENT_BUS.post((Event)toolUsedEvent);
        VeinminerStartCheck continueCheck = new VeinminerStartCheck(this.player, this.targetBlock.id, this.targetBlock.metadata);
        MinecraftForge.EVENT_BUS.post((Event)continueCheck);
        if (success || continueCheck.allowVeinminerStart) {
            this.destroyQueue.add(newPoint);
        } else {
            this.awaitingEntityDrop.remove(newPoint);
        }
    }

    public synchronized void mineVein(int x, int y, int z) {
        if (this.world == null || this.player == null || this.targetBlock == null) {
            this.finished = true;
        }
        if (this.finished || !this.shouldContinue()) {
            return;
        }
        this.player.func_71020_j(0.03f);
        int d = 1;
        for (int dx = -d; dx <= d; ++dx) {
            for (int dy = -d; dy <= d; ++dy) {
                for (int dz = -d; dz <= d; ++dz) {
                    int blockLimit;
                    int radiusLimit;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    Point newBlockPos = new Point(x + dx, y + dy, z + dz);
                    BlockID newBlock = new BlockID(this.world, x + dx, y + dy, z + dz);
                    if (Block.field_71973_m[newBlock.id] == null) continue;
                    ConfigurationSettings configSettings = this.serverInstance.getConfigurationSettings();
                    if (!newBlock.equals(this.targetBlock) && !configSettings.areBlocksCongruent(newBlock, this.targetBlock) || !newBlockPos.isWithinRange(this.initalBlock, radiusLimit = configSettings.getRadiusLimit()) && radiusLimit > 0 || this.awaitingEntityDrop.contains(newBlockPos) || this.numBlocksMined >= (blockLimit = this.serverInstance.getConfigurationSettings().getBlockLimit()) && blockLimit != -1 || !configSettings.getEnableAllBlocks() && !this.toolAllowedForBlock(this.usedItem, newBlock)) continue;
                    this.mineBlock(x + dx, y + dy, z + dz);
                }
            }
        }
    }

    public void mineScheduled() {
        int quantity = this.serverInstance.getConfigurationSettings().getBlocksPerTick();
        for (int i = 0; i < quantity; ++i) {
            if (!this.destroyQueue.isEmpty()) {
                Point target = (Point)this.destroyQueue.remove();
                this.mineVein(target.getX(), target.getY(), target.getZ());
                continue;
            }
            if (this.drops.isEmpty()) continue;
            this.serverInstance.removeInstance(this);
            this.spawnDrops();
            return;
        }
    }

    private void spawnDrops() {
        for (Map.Entry schedDrop : this.drops.entrySet()) {
            EntityItem newEntityItem;
            ItemStack newItemStack;
            int numItems;
            ItemStackID itemStack = (ItemStackID)schedDrop.getKey();
            for (numItems = ((Integer)schedDrop.getValue()).intValue(); numItems > itemStack.getMaxStackSize(); numItems -= itemStack.getMaxStackSize()) {
                newItemStack = new ItemStack(itemStack.getItemId(), itemStack.getMaxStackSize(), itemStack.getDamage());
                newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
                this.world.func_72838_d((Entity)newEntityItem);
            }
            newItemStack = new ItemStack(itemStack.getItemId(), numItems, itemStack.getDamage());
            newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
            this.world.func_72838_d((Entity)newEntityItem);
        }
        this.drops.clear();
    }

    public boolean isRegistered(Point p) {
        return this.awaitingEntityDrop.contains(p);
    }

    public void addDrop(EntityItem entity, Point point) {
        ItemStack item = entity.func_92059_d();
        ItemStackID itemInfo = new ItemStackID(item.field_77993_c, item.func_77960_j(), item.func_77976_d());
        if (this.drops.containsKey(itemInfo)) {
            int oldDropNumber = (Integer)this.drops.get(itemInfo);
            int newDropNumber = oldDropNumber + item.field_77994_a;
            this.drops.put(itemInfo, newDropNumber);
        } else {
            this.drops.put(itemInfo, item.field_77994_a);
        }
        this.awaitingEntityDrop.remove(point);
    }
}

