/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.network.packet;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import portablejim.veinminer.network.PacketTypeHandler;
import portablejim.veinminer.network.packet.PacketVeinMiner;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.server.PlayerStatus;

public class PacketClientPresent
extends PacketVeinMiner {
    private int preferredMode;

    public PacketClientPresent() {
        super(PacketTypeHandler.CLIENT_PRESENT, false);
        this.preferredMode = 0;
    }

    public PacketClientPresent(int preferredMode) {
        super(PacketTypeHandler.CLIENT_PRESENT, false);
        this.preferredMode = preferredMode;
    }

    @Override
    public void readDataStream(DataInputStream dataInputStream) throws IOException {
        this.preferredMode = dataInputStream.readInt();
    }

    @Override
    public void writeDataStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.preferredMode);
    }

    @Override
    public void execute(INetworkManager manager, Player player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer thePlayer = (EntityPlayer)player;
            String playerName = thePlayer.func_70023_ak();
            MinerServer.instance.addClientPlayer(playerName);
            switch (this.preferredMode) {
                case 0: {
                    thePlayer.func_71035_c("mod.veinminer.preferredmode.auto");
                    break;
                }
                case 1: {
                    MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.SNEAK_ACTIVE);
                    thePlayer.func_71035_c("mod.veinminer.preferredmode.sneak");
                    break;
                }
                case 2: {
                    MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.SNEAK_INACTIVE);
                    thePlayer.func_71035_c("mod.veinminer.preferredmode.nosneak");
                }
            }
        }
    }
}

