/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.network.packet;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import portablejim.veinminer.network.PacketTypeHandler;
import portablejim.veinminer.network.packet.PacketVeinMiner;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.server.PlayerStatus;

public class PacketClientSettings
extends PacketVeinMiner {
    private boolean isKeyDown;

    public PacketClientSettings() {
        super(PacketTypeHandler.CLIENT_SETTINGS, false);
    }

    public PacketClientSettings(boolean keyDown) {
        super(PacketTypeHandler.CLIENT_SETTINGS, false);
        this.isKeyDown = keyDown;
    }

    @Override
    public void readDataStream(DataInputStream dataInputStream) throws IOException {
        this.isKeyDown = dataInputStream.readBoolean();
    }

    @Override
    public void writeDataStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.isKeyDown);
    }

    @Override
    public void execute(INetworkManager manager, Player player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer thePlayer = (EntityPlayer)player;
            String playerName = thePlayer.func_70023_ak();
            PlayerStatus status = MinerServer.instance.getPlayerStatus(playerName);
            if (this.isKeyDown) {
                if (status == PlayerStatus.INACTIVE) {
                    MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.ACTIVE);
                }
            } else if (status == PlayerStatus.ACTIVE) {
                MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
            }
        }
    }
}

