/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.server;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.server.PlayerStatus;
import portablejim.veinminer.util.BlockID;

public class MinerCommand
extends CommandBase {
    public static final int COMMAND_MODE = 0;
    public static final int COMMAND_BLOCKLIST = 1;
    public static final int COMMAND_TOOLLIST = 2;
    public static final int COMMAND_BLOCKLIMIT = 3;
    public static final int COMMAND_RANGE = 4;
    public static final int COMMAND_PER_TICK = 5;
    public static final int COMMAND_SAVE = 6;
    public static final int COMMAND_HELP = 7;
    private static final String[] commands = new String[]{"mode", "blocklist", "toollist", "blocklimit", "radius", "per_tick", "saveconfig", "help"};
    private static final String[] modes = new String[]{"disable", "auto", "sneak", "no_sneak"};

    public String func_71517_b() {
        return "veinminer";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return par1ICommandSender instanceof EntityPlayerMP;
    }

    private ConfigurationSettings.ToolType commandTool(String[] commandString, String commandName) {
        if (commandString.length == 1) {
            this.showUsageError("command.veinminer." + commandName);
        }
        ConfigurationSettings.ToolType tool = ConfigurationSettings.ToolType.PICKAXE;
        if ("pickaxe".equals(commandString[1])) {
            tool = ConfigurationSettings.ToolType.PICKAXE;
        } else if ("axe".equals(commandString[1])) {
            tool = ConfigurationSettings.ToolType.AXE;
        } else if ("shovel".equals(commandString[1])) {
            tool = ConfigurationSettings.ToolType.SHOVEL;
        } else {
            this.showUsageError("command.veinminer." + commandName);
        }
        return tool;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        if (!(icommandsender instanceof EntityPlayerMP)) {
            String message = StatCollector.func_74838_a((String)"command.veinminer.cannotuse");
            throw new CommandException(message, new Object[0]);
        }
        EntityPlayerMP senderPlayer = (EntityPlayerMP)icommandsender;
        if (astring.length > 0) {
            if (astring[0].equals(commands[0])) {
                this.runCommandMode(senderPlayer, astring);
            } else if (astring[0].equals(commands[1])) {
                this.needAdmin(senderPlayer);
                this.runCommandBlocklist(senderPlayer, astring);
            } else if (astring[0].equals(commands[2])) {
                this.needAdmin(senderPlayer);
                this.runCommandToollist(senderPlayer, astring);
            } else if (astring[0].equals(commands[3])) {
                this.needAdmin(senderPlayer);
                this.runCommandBlocklimit(senderPlayer, astring);
            } else if (astring[0].equals(commands[4])) {
                this.needAdmin(senderPlayer);
                this.runCommandRange(senderPlayer, astring);
            } else if (astring[0].equals(commands[5])) {
                this.needAdmin(senderPlayer);
                this.runCommandPerTick(senderPlayer, astring);
            } else if (astring[0].equals(commands[6])) {
                this.needAdmin(senderPlayer);
                this.runCommandSave(senderPlayer);
            } else if (astring[0].equals(commands[7])) {
                this.runCommandHelp(senderPlayer, astring);
            } else {
                this.showUsageError("command.veinminer");
            }
        } else {
            this.showUsageError("command.veinminer");
        }
    }

    private void sendProperChatToPlayer(EntityPlayerMP player, String incomingMessage) {
        String message = StatCollector.func_74838_a((String)incomingMessage);
        player.func_71035_c(message);
    }

    private void sendProperChatToPlayer(EntityPlayerMP player, String incomingMessage, Object ... params) {
        String message = StatCollector.func_74837_a((String)incomingMessage, (Object[])params);
        player.func_71035_c(message);
    }

    private void showUsageError(String errorKey) throws WrongUsageException {
        String message = StatCollector.func_74838_a((String)errorKey);
        throw new WrongUsageException(message, new Object[0]);
    }

    private void showUsageError(String errorKey, Object ... params) {
        String message = StatCollector.func_74837_a((String)errorKey, (Object[])params);
        throw new WrongUsageException(message, new Object[0]);
    }

    private void needAdmin(EntityPlayerMP player) {
        MinecraftServer server = player.field_71133_b;
        if (server.func_71262_S() && !server.func_71203_ab().func_72353_e(player.func_70005_c_())) {
            boolean playerNoClient = !MinerServer.instance.playerHasClient(player.func_70023_ak());
            String message = "command.veinminer.permissionDenied";
            if (playerNoClient) {
                message = LanguageRegistry.instance().getStringLocalization(message);
            }
            throw new CommandException(message, new Object[0]);
        }
    }

    private void commandAction(String[] commandString, String commandName) {
        if (commandString.length < 3 || !"add".equals(commandString[2]) && !"remove".equals(commandString[2])) {
            this.showUsageError("command.veinminer." + commandName + ".actionerror", commandString[1]);
        }
    }

    private void runCommandMode(EntityPlayerMP senderPlayer, String[] astring) throws WrongUsageException {
        MinerServer minerServer = MinerServer.instance;
        String player = senderPlayer.func_70005_c_();
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.enable");
        } else if (astring[1].equals(modes[0])) {
            minerServer.setPlayerStatus(player, PlayerStatus.DISABLED);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.set.disable");
        } else if (astring[1].equals(modes[1])) {
            if (minerServer.playerHasClient(player)) {
                minerServer.setPlayerStatus(player, PlayerStatus.INACTIVE);
            } else {
                minerServer.setPlayerStatus(player, PlayerStatus.DISABLED);
            }
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.set.auto");
        } else if (astring[1].equals(modes[2])) {
            minerServer.setPlayerStatus(player, PlayerStatus.SNEAK_ACTIVE);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.set.sneak");
        } else if (astring[1].equals(modes[3])) {
            minerServer.setPlayerStatus(player, PlayerStatus.SNEAK_INACTIVE);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.set.nosneak");
        }
    }

    private void runCommandBlocklist(EntityPlayerMP senderPlayer, String[] astring) {
        ConfigurationSettings configSettings = MinerServer.instance.getConfigurationSettings();
        ConfigurationSettings.ToolType tool = this.commandTool(astring, "blocklist");
        String toolString = astring[1];
        this.commandAction(astring, "blockList");
        String action = astring[2];
        if (astring.length < 4) {
            this.showUsageError("command.veinminer.blocklist.itemerror", toolString, action);
        }
        BlockID blockID = new BlockID(astring[3], ":", -1);
        if (blockID.id <= 0) {
            this.showUsageError("command.veinminer.blocklist.itemerror", toolString, action);
        }
        if ("add".equals(action)) {
            configSettings.addBlockToWhitelist(tool, blockID);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.blocklist.add", blockID.id, blockID.metadata, toolString);
        } else if ("remove".equals(action)) {
            configSettings.removeBlockFromWhitelist(tool, blockID);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.blocklist.remove", blockID.id, blockID.metadata, toolString);
        }
    }

    private void runCommandToollist(EntityPlayerMP senderPlayer, String[] astring) {
        int toolId;
        ConfigurationSettings configSettings = MinerServer.instance.getConfigurationSettings();
        ConfigurationSettings.ToolType tool = this.commandTool(astring, "toollist");
        String toolString = astring[1];
        this.commandAction(astring, "toollist");
        String action = astring[2];
        if (astring.length < 4) {
            this.showUsageError("command.veinminer.toollist.itemerror", toolString, action);
        }
        try {
            toolId = Integer.parseInt(astring[3]);
        }
        catch (NumberFormatException e) {
            toolId = -1;
        }
        if (toolId <= 0) {
            this.showUsageError("command.veinminer.toollist.itemerror", toolString, action);
        }
        if ("add".equals(action)) {
            configSettings.addTool(tool, toolId);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.toollist.add", toolId, toolString);
        } else if ("remove".equals(action)) {
            configSettings.removeTool(tool, toolId);
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.toollist.remove", toolId, toolString);
        }
    }

    private void runCommandBlocklimit(EntityPlayerMP senderPlayer, String[] astring) {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.blocklimit");
        }
        int newBlockPerTick = 0;
        try {
            newBlockPerTick = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.blocklimit");
        }
        MinerServer.instance.getConfigurationSettings().setBlockLimit(newBlockPerTick);
        int actualBlockPerTick = MinerServer.instance.getConfigurationSettings().getBlockLimit();
        this.sendProperChatToPlayer(senderPlayer, "command.veinminer.blocklimit.set", actualBlockPerTick);
    }

    private void runCommandRange(EntityPlayerMP senderPlayer, String[] astring) {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.range");
        }
        int newRange = 0;
        try {
            newRange = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.range");
        }
        MinerServer.instance.getConfigurationSettings().setRadiusLimit(newRange);
        int actualRange = MinerServer.instance.getConfigurationSettings().getRadiusLimit();
        this.sendProperChatToPlayer(senderPlayer, "command.veinminer.range.set", actualRange);
    }

    private void runCommandPerTick(EntityPlayerMP senderPlayer, String[] astring) {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.pertick");
        }
        int newRate = 0;
        try {
            newRate = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.pertick");
        }
        MinerServer.instance.getConfigurationSettings().setRadiusLimit(newRate);
        int actualRate = MinerServer.instance.getConfigurationSettings().getRadiusLimit();
        this.sendProperChatToPlayer(senderPlayer, "command.veinminer.pertick.set", actualRate);
    }

    private void runCommandSave(EntityPlayerMP senderPlayer) {
        MinerServer.instance.getConfigurationSettings().saveConfigs();
        this.sendProperChatToPlayer(senderPlayer, "command.veinminer.saveconfig");
    }

    private void runCommandHelp(EntityPlayerMP senderPlayer, String[] astring) {
        if (astring.length > 1) {
            if (astring[1].equals(commands[0])) {
                this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help.enable1");
                this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help.enable2");
                this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help.enable3");
                this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help.enable4");
                this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help.enable5");
            }
        } else {
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help1");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help2");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help3");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help4");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help5");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help6");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help7");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help8");
            this.sendProperChatToPlayer(senderPlayer, "command.veinminer.help9");
        }
    }

    public List func_71516_a(ICommandSender par1ICommandSender, String[] arguments) {
        switch (arguments.length) {
            case 1: {
                return MinerCommand.func_71530_a((String[])arguments, (String[])commands);
            }
            case 2: {
                if (arguments[0].equals(commands[0])) {
                    return MinerCommand.func_71530_a((String[])arguments, (String[])modes);
                }
                if (arguments[0].equals(commands[1]) || arguments[0].equals(commands[2])) {
                    String[] tools = new String[]{"pickaxe", "axe", "shovel"};
                    return MinerCommand.func_71530_a((String[])arguments, (String[])tools);
                }
                if (arguments[0].equals(commands[2])) {
                    return MinerCommand.func_71530_a((String[])arguments, (String[])commands);
                }
            }
            case 3: {
                if (!arguments[0].equals(commands[1]) && !arguments[0].equals(commands[2])) break;
                String[] actions = new String[]{"add", "remove"};
                return MinerCommand.func_71530_a((String[])arguments, (String[])actions);
            }
        }
        return null;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return LanguageRegistry.instance().getStringLocalization("command.veinminer");
    }
}

