/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.server;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.server.PlayerStatus;
import portablejim.veinminer.util.Point;

public class MinerServer {
    public static MinerServer instance;
    private HashSet minerInstances;
    private HashSet clientPlayers;
    private HashMap players;
    private ConfigurationSettings settings;

    public MinerServer(ConfigurationValues configValues) {
        instance = this;
        this.minerInstances = new HashSet();
        this.clientPlayers = new HashSet();
        this.players = new HashMap();
        this.settings = new ConfigurationSettings(configValues);
    }

    public void setPlayerStatus(String player, PlayerStatus status) {
        if (status == PlayerStatus.DISABLED) {
            this.players.remove(player);
        } else {
            this.players.put(player, status);
        }
    }

    public void removePlayer(String player) {
        if (this.players.containsKey(player)) {
            this.players.remove(player);
        }
    }

    public PlayerStatus getPlayerStatus(String player) {
        if (this.players.containsKey(player)) {
            return (PlayerStatus)((Object)this.players.get(player));
        }
        return PlayerStatus.DISABLED;
    }

    public void addEntity(Entity entity) {
        int eX = (int)Math.floor(entity.field_70165_t);
        int eY = (int)Math.floor(entity.field_70163_u);
        int eZ = (int)Math.floor(entity.field_70161_v);
        Point p = new Point(eX, eY, eZ);
        if (!EntityItem.class.isInstance(entity)) {
            return;
        }
        EntityItem entityItem = (EntityItem)entity;
        for (MinerInstance minerInstance : this.minerInstances) {
            if (!minerInstance.isRegistered(p)) continue;
            minerInstance.addDrop(entityItem, p);
        }
    }

    public void addInstance(MinerInstance ins) {
        this.minerInstances.add(ins);
    }

    public void removeInstance(MinerInstance ins) {
        this.minerInstances.remove(ins);
    }

    public boolean isRegistered(int x, int y, int z) {
        Point p = new Point(x, y, z);
        boolean registered = false;
        for (MinerInstance minerInstance : this.minerInstances) {
            if (!minerInstance.isRegistered(p)) continue;
            registered = true;
        }
        return registered;
    }

    public ConfigurationSettings getConfigurationSettings() {
        return this.settings;
    }

    public HashSet getClientPlayers() {
        return this.clientPlayers;
    }

    public boolean playerHasClient(String playerName) {
        return this.clientPlayers.contains(playerName);
    }

    public void addClientPlayer(String playerName) {
        this.clientPlayers.add(playerName);
        if (this.getPlayerStatus(playerName).equals((Object)PlayerStatus.DISABLED)) {
            this.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
        }
    }

    public void removeClientPlayer(String playerName) {
        this.clientPlayers.remove(playerName);
    }

    public void setClientPlayers(HashSet clientPlayers) {
        this.clientPlayers = clientPlayers;
    }
}

