/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.util;

import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BlockID {
    public int id;
    public int metadata;

    public BlockID(int id, int metadata) {
        this.id = id;
        this.metadata = metadata;
    }

    public BlockID(String format, String delimiter, int defaultVal) {
        String[] s = format.split(delimiter);
        try {
            this.id = Integer.parseInt(s[0]);
        }
        catch (NumberFormatException e) {
            this.id = defaultVal;
        }
        if (s.length < 2) {
            this.metadata = -1;
        } else {
            try {
                this.metadata = Integer.parseInt(s[1]);
            }
            catch (NumberFormatException e) {
                this.metadata = -1;
            }
        }
    }

    public BlockID(String format, String delimiter) {
        this(format, delimiter, 0);
    }

    public BlockID(String format) {
        this(format, ":");
    }

    public BlockID(Block block, int metadata) {
        this(block.field_71990_ca, metadata);
    }

    public BlockID(Block block) {
        this(block.field_71990_ca, -1);
    }

    public BlockID(int id) {
        this(id, -1);
    }

    public BlockID(World world, int x, int y, int z) {
        this(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public BlockID(World world, int x, int y, int z, int metadata) {
        this(world.func_72798_a(x, y, z), metadata);
    }

    public BlockID clone() throws CloneNotSupportedException {
        super.clone();
        return new BlockID(this.id, this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockID)) {
            return false;
        }
        BlockID o = (BlockID)obj;
        if (o.metadata == -1 || this.metadata == -1) {
            return this.id == o.id;
        }
        return this.id == o.id && this.metadata == o.metadata;
    }

    public int hashCode() {
        return (this.id << 8) + this.metadata;
    }

    public String toString() {
        return this.metadata == -1 ? this.id + "" : this.id + ":" + this.metadata;
    }
}

