/*
 * Decompiled with CFR 0.152.
 */
package com.gudenau.minecraft.cooler;

import com.gudenau.minecraft.cooler.EnderManager;
import com.gudenau.minecraft.cooler.GuiHandler;
import com.gudenau.minecraft.cooler.block.BlockCooler;
import com.gudenau.minecraft.cooler.block.BlockEnderCooler;
import com.gudenau.minecraft.cooler.block.tileentity.TileCooler;
import com.gudenau.minecraft.cooler.block.tileentity.TileEnderCooler;
import com.gudenau.minecraft.cooler.compt.IronChestCompt;
import com.gudenau.minecraft.cooler.compt.IronChestTypeEnum;
import com.gudenau.minecraft.cooler.compt.IronChestTypeHelper;
import com.gudenau.minecraft.cooler.item.ItemCooler;
import com.gudenau.minecraft.cooler.item.ItemEnderCooler;
import com.gudenau.minecraft.cooler.proxy.Proxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="gud_cooler", dependencies="after:IronChest")
public class Cooler {
    @Mod.Instance(value="gud_cooler")
    public static Cooler instance;
    @SidedProxy(clientSide="com.gudenau.minecraft.cooler.proxy.ClientProxy", serverSide="com.gudenau.minecraft.cooler.proxy.Proxy")
    public static Proxy proxy;
    public BlockCooler cooler;
    private BlockEnderCooler enderCooler;
    private List<ItemStack> subTypes;
    private int diff;

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        this.subTypes = new ArrayList<ItemStack>();
        Configuration config = new Configuration(new File("config/gudenau/cooler.cfg"));
        config.load();
        this.cooler = new BlockCooler();
        GameRegistry.registerBlock((Block)this.cooler, ItemCooler.class, (String)"gud_cooler_cooler");
        GameRegistry.registerTileEntity(TileCooler.class, (String)"gud_cooler_tile_cooler");
        this.enderCooler = new BlockEnderCooler();
        GameRegistry.registerBlock((Block)this.enderCooler, ItemEnderCooler.class, (String)"gud_cooler_endercooler");
        GameRegistry.registerTileEntity(TileEnderCooler.class, (String)"gud_cooler_tile_endercooler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ItemStack coolerStack = new ItemStack((Block)this.cooler, 1, 0xFFFFFF);
        coolerStack.field_77990_d = new NBTTagCompound();
        this.diff = config.get("misc", "crafting", 0).getInt();
        if (this.diff == 1) {
            GameRegistry.addRecipe((ItemStack)coolerStack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), Blocks.field_150486_ae});
            coolerStack.field_77990_d.func_74757_a("clear", true);
            coolerStack.func_77964_b(0x1FFFFFF);
            GameRegistry.addRecipe((ItemStack)coolerStack.func_77946_l(), (Object[])new Object[]{"SSS", "ScS", "SSS", Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), Blocks.field_150486_ae});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.enderCooler, 1, 0), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), Blocks.field_150477_bB});
        } else {
            GameRegistry.addRecipe((ItemStack)coolerStack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150433_aE, Character.valueOf('c'), Blocks.field_150486_ae});
            coolerStack.field_77990_d.func_74757_a("clear", true);
            coolerStack.func_77964_b(0x1FFFFFF);
            GameRegistry.addRecipe((ItemStack)coolerStack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), Blocks.field_150486_ae});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.enderCooler, 1, 0), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150433_aE, Character.valueOf('c'), Blocks.field_150477_bB});
        }
        proxy.registerRenders();
        config.addCustomCategoryComment("misc", "Mics settings for the mod");
        config.get((String)"misc", (String)"crafting", (int)0).comment = "Crafting recipie:\n  0: Normal\n  1: Hard";
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)new EnderManager.SaveHandler());
        ItemStack stack = new ItemStack((Block)this.cooler, 1, 0xFFFFFF);
        stack.field_77990_d = new NBTTagCompound();
        this.subTypes.add(stack.func_77946_l());
        stack.func_77964_b(0x1FFFFFF);
        stack.field_77990_d.func_74757_a("clear", true);
        this.subTypes.add(stack.func_77946_l());
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        if (IronChestCompt.isInstalled()) {
            this.createIronChestRecipes();
        }
        this.cooler.setSubBlocks(this.subTypes.toArray(new ItemStack[0]));
    }

    private void createIronChestRecipes() {
        int i = 0;
        for (Field f : IronChestTypeHelper.class.getDeclaredFields()) {
            try {
                ItemStack stack = new ItemStack((Block)this.cooler, 1, 0xFFFFFF);
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74778_a("iron", ((IronChestTypeEnum)f.get(null)).friendlyName);
                if (this.diff == 1) {
                    GameRegistry.addRecipe((ItemStack)stack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), new ItemStack(IronChestCompt.getItem(), 1, i)});
                } else {
                    GameRegistry.addRecipe((ItemStack)stack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150433_aE, Character.valueOf('c'), new ItemStack(IronChestCompt.getItem(), 1, i)});
                }
                this.subTypes.add(stack.func_77946_l());
                stack.func_77964_b(0x1FFFFFF);
                stack.field_77990_d.func_74757_a("clear", true);
                this.subTypes.add(stack.func_77946_l());
                if (this.diff == 1) {
                    GameRegistry.addRecipe((ItemStack)stack.func_77946_l(), (Object[])new Object[]{"SSS", "ScS", "SSS", Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), new ItemStack(IronChestCompt.getItem(), 1, i)});
                } else {
                    GameRegistry.addRecipe((ItemStack)stack.func_77946_l(), (Object[])new Object[]{"sSs", "ScS", "sSs", Character.valueOf('s'), Items.field_151126_ay, Character.valueOf('S'), Blocks.field_150432_aD, Character.valueOf('c'), new ItemStack(IronChestCompt.getItem(), 1, i)});
                }
                ++i;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

