/*
 * Decompiled with CFR 0.152.
 */
package com.gudenau.minecraft.cooler;

import com.gudenau.minecraft.cooler.CoolerUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EnderManager {
    private static EnderManager serverManager;
    private static EnderManager clientManager;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<CoolerStorage> dirty;
    private NBTTagCompound saveTag;
    public final boolean client;
    private Map<String, CoolerStorage> storage;

    public EnderManager(boolean client, World world) {
        this.client = client;
        this.storage = Collections.synchronizedMap(new HashMap());
        this.dirty = Collections.synchronizedList(new LinkedList());
        if (!client) {
            this.load(world);
        }
    }

    private void load(World world) {
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "EnderCoolerStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data0.dat"), new File(this.saveDir, "data1.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream in = new FileInputStream(this.saveFiles[2]);
                this.saveTo = in.read() ^ 1;
                in.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                    this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                    din.close();
                } else {
                    this.saveTag = new NBTTagCompound();
                }
            } else {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void save(boolean force) {
        if (!this.dirty.isEmpty() || force) {
            for (CoolerStorage inv : this.dirty) {
                this.saveTag.func_74782_a(inv.freq + 124 + inv.owner, (NBTBase)inv.saveToTag());
                inv.setClean();
            }
            this.dirty.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream out = new DataOutputStream(new FileOutputStream(saveFile));
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)out);
                out.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client, World world) {
        EnderManager manager = new EnderManager(client, world);
        if (client) {
            clientManager = manager;
        } else {
            serverManager = manager;
        }
    }

    public static EnderManager instance(boolean client) {
        return client ? clientManager : serverManager;
    }

    public void markDirty(CoolerStorage coolerStorage) {
        this.dirty.add(coolerStorage);
    }

    public CoolerStorage getStorage(String owner, int freq) {
        String key;
        CoolerStorage storage;
        if (owner == null) {
            owner = "global";
        }
        if ((storage = this.storage.get(key = freq + 124 + owner)) == null) {
            storage = new CoolerStorage(this, owner, freq);
            if (!this.client && this.saveTag.func_74764_b(key)) {
                storage.loadFromTag(this.saveTag);
            }
            this.storage.put(key, storage);
        }
        return storage;
    }

    public static class SaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            EnderManager manager = EnderManager.instance(event.world.field_72995_K);
            if (event.world.field_72995_K) {
                EnderManager.reloadManager(true, null);
            } else {
                EnderManager.reloadManager(false, event.world);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.world.field_72995_K && EnderManager.instance(false) != null) {
                EnderManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onChunkLoad(ChunkDataEvent.Load event) {
            if (serverManager == null) {
                EnderManager.reloadManager(false, event.world);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            if (!event.world.field_72995_K && !MinecraftServer.func_71276_C().func_71278_l()) {
                serverManager = null;
            }
        }
    }

    public static class CoolerStorage
    implements ISidedInventory {
        public final String owner;
        public final int freq;
        private final EnderManager manager;
        private boolean dirty;
        private ItemStack[] items;
        private static final int[] accessibleSlots = new int[0];

        public CoolerStorage(EnderManager manager, String owner, int freq) {
            this.manager = manager;
            this.owner = owner;
            this.freq = freq;
            this.items = new ItemStack[6];
        }

        public NBTTagCompound saveToTag() {
            NBTTagCompound tag = new NBTTagCompound();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                tag.func_74782_a("" + i, (NBTBase)this.items[i].func_77955_b(new NBTTagCompound()));
            }
            return tag;
        }

        public void loadFromTag(NBTTagCompound tag) {
            Set keys = tag.func_150296_c();
            this.items = new ItemStack[this.items.length];
            for (Object o : keys) {
                if (!(o instanceof String)) continue;
                this.items[Integer.parseInt((String)((String)o))] = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l((String)o));
            }
        }

        public void setClean() {
            this.dirty = false;
        }

        public void setDirty() {
            if (this.manager.client) {
                return;
            }
            if (!this.dirty) {
                this.dirty = true;
                this.manager.markDirty(this);
            }
        }

        public int func_70302_i_() {
            return this.items.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.items[slot];
        }

        public ItemStack func_70298_a(int slot, int count) {
            if (this.items[slot] != null) {
                if (this.items[slot].field_77994_a <= count) {
                    ItemStack stack = this.items[slot];
                    this.items[slot] = null;
                    return stack;
                }
                ItemStack stack = this.items[slot].func_77979_a(count);
                if (this.items[slot].field_77994_a == 0) {
                    this.items[slot] = null;
                }
                return stack;
            }
            return null;
        }

        public ItemStack func_70304_b(int slot) {
            if (this.items[slot] != null) {
                ItemStack stack = this.items[slot];
                this.items[slot] = null;
                return stack;
            }
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.items[slot] = stack;
            if (this.items[slot] != null && this.items[slot].field_77994_a > this.func_70297_j_()) {
                this.items[slot].field_77994_a = this.func_70297_j_();
            }
        }

        public String func_145825_b() {
            return "gud_cooler:inv.endercooler.name";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            this.setDirty();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return CoolerUtil.isItemValidforSlot(stack);
        }

        public int[] func_94128_d(int side) {
            return accessibleSlots;
        }

        public boolean func_102007_a(int slot, ItemStack stack, int side) {
            return false;
        }

        public boolean func_102008_b(int slot, ItemStack stack, int side) {
            return false;
        }
    }
}

