/*
 * Decompiled with CFR 0.152.
 */
package rafradek.wallpaint;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import rafradek.wallpaint.ClientProxy;
import rafradek.wallpaint.CommonProxy;
import rafradek.wallpaint.ItemPaintBucket;
import rafradek.wallpaint.WallPaint;
import rafradek.wallpaint.WallPaintMessage;

public class WallPaintEventHandler {
    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        Chunk chunk = event.world.func_72938_d(event.x, event.z);
        if (CommonProxy.map.containsKey(chunk)) {
            Iterator<int[]> iterator = CommonProxy.map.get(chunk).iterator();
            while (iterator.hasNext()) {
                int[] array = iterator.next();
                if (array[0] != event.x || array[1] != event.y || array[2] != event.z) continue;
                array[3] = 0;
                WallPaint.network.sendToDimension((IMessage)new WallPaintMessage.UpdateSend(array, -1), event.world.field_73011_w.field_76574_g);
                iterator.remove();
                break;
            }
        }
    }

    @SubscribeEvent
    public void ChunkLoad(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            WallPaint.network.sendToServer((IMessage)new WallPaintMessage.ArrayRequest(event.getChunk().field_76635_g, event.getChunk().field_76647_h));
        }
    }

    @SubscribeEvent
    public void ChunkUnLoad(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            ClientProxy.map.remove(event.getChunk());
        } else {
            CommonProxy.map.remove(event.getChunk());
        }
    }

    @SubscribeEvent
    public void ChunkDataLoad(ChunkDataEvent.Load event) {
        if (event.getData().func_74764_b("arrays")) {
            NBTTagList taglist = (NBTTagList)event.getData().func_74781_a("arrays");
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                list.add(taglist.func_150306_c(i));
            }
            CommonProxy.map.put(event.getChunk(), list);
        }
    }

    @SubscribeEvent
    public void ChunkDataSave(ChunkDataEvent.Save event) {
        if (CommonProxy.map.containsKey(event.getChunk())) {
            NBTTagList taglist = new NBTTagList();
            ArrayList<int[]> list = CommonProxy.map.get(event.getChunk());
            for (int i = 0; i < list.size(); ++i) {
                if (event.world.func_147439_a(list.get(i)[0], list.get(i)[1], list.get(i)[2]) == Blocks.field_150350_a) continue;
                taglist.func_74742_a((NBTBase)new NBTTagIntArray(list.get(i)));
            }
            event.getData().func_74782_a("arrays", (NBTBase)taglist);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void TextureMake(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            ClientProxy.wallicon = event.map.func_94245_a("wallpaint:wall");
        }
    }

    @SubscribeEvent
    public void ItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting != null && event.crafting.func_77973_b() instanceof ItemPaintBucket) {
            event.craftMatrix.func_70299_a(7, null);
        }
    }
}

