/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.forge;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.net.InetSocketAddress;
import mapwriter.Mw;
import mapwriter.api.MwAPI;
import mapwriter.forge.CommonProxy;
import mapwriter.forge.MwConfig;
import mapwriter.overlay.OverlayGrid;
import mapwriter.overlay.OverlaySlime;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="MapWriter", name="MapWriter", version="2.1.1")
public class MwForge {
    private MwConfig config;
    @Mod.Instance(value="MapWriter")
    public static MwForge instance;
    @SidedProxy(clientSide="mapwriter.forge.ClientProxy", serverSide="mapwriter.forge.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("FML Event: preInit");
        this.config = new MwConfig(event.getSuggestedConfigurationFile());
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        logger.info("FML Event: load");
        proxy.init(this.config);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("FML Event: postInit");
        MwAPI.registerDataProvider("Slime", new OverlaySlime());
        MwAPI.registerDataProvider("Grid", new OverlayGrid());
    }

    @SubscribeEvent
    public void renderMap(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Mw.instance.onTick();
        }
    }

    @SubscribeEvent
    public void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal) {
            InetSocketAddress address = (InetSocketAddress)event.manager.func_74430_c();
            Mw.instance.setServerDetails(address.getHostName(), address.getPort());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Mw.instance.ready && Minecraft.func_71410_x().field_71439_g == null) {
            Mw.instance.close();
        }
    }

    static {
        logger = LogManager.getLogger((String)"MapWriter");
    }
}

