/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.map;

import java.awt.geom.Point2D;
import mapwriter.Render;
import mapwriter.map.MapView;
import mapwriter.map.mapmode.MapMode;

public class Marker {
    public final String name;
    public final String groupName;
    public int x;
    public int y;
    public int z;
    public int dimension;
    public int colour;
    public Point2D.Double screenPos = new Point2D.Double(0.0, 0.0);
    private static int[] colours = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFF8000, 0x8000FF};
    private static int colourIndex = 0;

    public Marker(String name, String groupName, int x, int y, int z, int dimension, int colour) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.colour = colour;
        this.groupName = groupName;
    }

    public String getString() {
        return String.format("%s %s (%d, %d, %d) %d %06x", this.name, this.groupName, this.x, this.y, this.z, this.dimension, this.colour & 0xFFFFFF);
    }

    public static int getCurrentColour() {
        return 0xFF000000 | colours[colourIndex];
    }

    public void colourNext() {
        colourIndex = (colourIndex + 1) % colours.length;
        this.colour = Marker.getCurrentColour();
    }

    public void colourPrev() {
        colourIndex = (colourIndex + colours.length - 1) % colours.length;
        this.colour = Marker.getCurrentColour();
    }

    public void draw(MapMode mapMode, MapView mapView, int borderColour) {
        double scale = mapView.getDimensionScaling(this.dimension);
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, (double)this.x * scale, (double)this.z * scale);
        this.screenPos.setLocation(p.x + (double)mapMode.xTranslation, p.y + (double)mapMode.yTranslation);
        double mSize = mapMode.markerSize;
        double halfMSize = (double)mapMode.markerSize / 2.0;
        Render.setColour(borderColour);
        Render.drawRect(p.x - halfMSize, p.y - halfMSize, mSize, mSize);
        Render.setColour(this.colour);
        Render.drawRect(p.x - halfMSize + 0.5, p.y - halfMSize + 0.5, mSize - 1.0, mSize - 1.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Marker) {
            Marker m = (Marker)o;
            return this.name == m.name && this.groupName == m.groupName && this.x == m.x && this.y == m.y && this.z == m.z && this.dimension == m.dimension;
        }
        return false;
    }
}

