/*
 * Decompiled with CFR 0.152.
 */
package com.lithial.me.handlers;

import com.lithial.me.enchantments.EffectManager;
import com.lithial.me.enchantments.Enchantments;
import com.lithial.me.handlers.utils.ArrowEntityTracker;
import com.lithial.me.handlers.utils.OpenGlHelper;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;

public class ArrowHandler {
    public static Enchantments enchant;
    public EntityArrow trackingArrow = null;
    public ArrowEntityTracker activeTrackingArrowData;
    public int trackingArrow_maxDist = 160;
    public static Random rand;

    @ForgeSubscribe
    public void onShoot(ArrowLooseEvent event) {
        EntityPlayer player;
        int quickdraw;
        if (Enchantments.allowQuickDraw && event.entityLiving instanceof EntityPlayer && (quickdraw = EnchantmentHelper.func_77506_a((int)Enchantments.quickdraw.field_77352_x, (ItemStack)(player = (EntityPlayer)event.entityLiving).func_70694_bm())) != 0) {
            event.charge *= 1 + (int)Math.ceil((double)quickdraw * 0.5);
        }
    }

    @ForgeSubscribe
    public void quickDraw(LivingEvent.LivingUpdateEvent event) {
        if (Enchantments.allowQuickDraw && event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            World world = player.field_70170_p;
            int quickdraw = EnchantmentHelper.func_77506_a((int)Enchantments.quickdraw.field_77352_x, (ItemStack)player.func_70694_bm());
            if (quickdraw != 0) {
                EffectManager.QuickDraw(player, world);
            }
        }
    }

    @ForgeSubscribe
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (Enchantments.allowHoming && event.entityLiving instanceof EntityPlayer) {
            boolean homeIn;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int SharpShooter = EnchantmentHelper.func_77506_a((int)Enchantments.homing.field_77352_x, (ItemStack)player.func_70694_bm());
            boolean bl = homeIn = SharpShooter > 1;
            if (SharpShooter != 0) {
                this.manageArrowTracking(homeIn, player);
            }
        }
    }

    public boolean canArrowBeTracked(EntityArrow arrow, EntityPlayer player) {
        if (arrow == null) {
            return false;
        }
        try {
            return player.func_70032_d((Entity)arrow) < (float)this.trackingArrow_maxDist && arrow.field_70250_c == player && ObfuscationReflectionHelper.getPrivateValue(EntityArrow.class, (Object)arrow, (int)5).equals(false) && !arrow.field_70128_L && ArrowHandler.isArrowCritical(arrow);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public static boolean isArrowCritical(EntityArrow arrow) {
        if (arrow != null) {
            return arrow.func_70241_g();
        }
        return false;
    }

    public boolean trySetTrackingArrow(EntityArrow newArrow, EntityPlayer player) {
        if ((!this.canArrowBeTracked(this.trackingArrow, player) || newArrow.field_70173_aa < this.trackingArrow.field_70173_aa) && this.canArrowBeTracked(newArrow, player)) {
            this.trackingArrow = newArrow;
            this.activeTrackingArrowData = new ArrowEntityTracker(newArrow, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), null);
            return true;
        }
        return false;
    }

    public void manageArrowTracking(boolean homeIn, EntityPlayer player) {
        Object[] list;
        EntityArrow arrow = null;
        boolean newArrow = false;
        for (Object o : list = player.field_70170_p.field_72996_f.toArray()) {
            if (!(o instanceof EntityArrow)) continue;
            arrow = (EntityArrow)o;
            newArrow = this.trySetTrackingArrow(arrow, player);
        }
        if (!this.canArrowBeTracked(this.trackingArrow, player) || this.activeTrackingArrowData == null) {
            return;
        }
        Vec3 lookVector = player.func_70676_i(1.0f).func_72432_b();
        Vec3 start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 end = Vec3.func_72443_a((double)(start.field_72450_a + lookVector.field_72450_a * (double)this.trackingArrow_maxDist * 1000.0), (double)(start.field_72448_b + lookVector.field_72448_b * (double)this.trackingArrow_maxDist * 1000.0), (double)(start.field_72449_c + lookVector.field_72449_c * (double)this.trackingArrow_maxDist * 1000.0));
        Vec3 arrowPos = Vec3.func_72443_a((double)this.trackingArrow.field_70165_t, (double)this.trackingArrow.field_70163_u, (double)this.trackingArrow.field_70161_v);
        double speed = 1.5;
        if (!homeIn) {
            speed = 4.0;
        }
        this.activeTrackingArrowData.speed = speed;
        double mag = Math.sqrt((end.field_72448_b - start.field_72448_b) * (end.field_72448_b - start.field_72448_b) + (end.field_72449_c - start.field_72449_c) * (end.field_72449_c - start.field_72449_c) + (end.field_72450_a - start.field_72450_a) * (end.field_72450_a - start.field_72450_a));
        double targetX = end.field_72450_a;
        double targetY = end.field_72448_b;
        double targetZ = end.field_72449_c;
        Vec3 target = Vec3.func_72443_a((double)targetX, (double)targetY, (double)targetZ);
        MovingObjectPosition m = ArrowHandler.rayTraceBlocks(start, target, player.field_70170_p, 0);
        if (m != null) {
            target.field_72450_a = (double)m.field_72311_b + 0.5;
            target.field_72448_b = (double)m.field_72312_c + 0.5;
            target.field_72449_c = (double)m.field_72309_d + 0.5;
        }
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        end = Vec3.func_72443_a((double)(start.field_72450_a + lookVector.field_72450_a * (double)this.trackingArrow_maxDist), (double)(start.field_72448_b + lookVector.field_72448_b * (double)this.trackingArrow_maxDist), (double)(start.field_72449_c + lookVector.field_72449_c * (double)this.trackingArrow_maxDist));
        for (Object o : player.field_70170_p.field_72996_f) {
            Vec3 touchingEntityAt;
            Entity le;
            double distFromEntityTracked = this.trackingArrow_maxDist * this.trackingArrow_maxDist;
            if (!(o instanceof Entity) || o.equals(this.trackingArrow) || this.trackingArrow.field_70250_c == o || !(distFromEntityTracked > (double)player.func_70032_d(le = (Entity)o)) || (touchingEntityAt = OpenGlHelper.lineIntersectionEntity(start, target, le)) == null) continue;
            distFromEntityTracked = player.func_70032_d(le);
            target.field_72450_a = touchingEntityAt.field_72450_a;
            target.field_72448_b = touchingEntityAt.field_72448_b;
            target.field_72449_c = touchingEntityAt.field_72449_c;
            if (!player.func_70093_af()) continue;
            this.activeTrackingArrowData.setEntityTracked(le);
        }
        Vec3 solution = OpenGlHelper.closestLinePartToPoint(start, end, target);
        if (solution == null) {
            return;
        }
        if (homeIn) {
            if ((this.activeTrackingArrowData.unsetTargetCoord || !player.func_70093_af()) && this.activeTrackingArrowData.target == null) {
                this.activeTrackingArrowData.setTargetCoord(solution.field_72450_a, solution.field_72448_b, solution.field_72449_c);
            }
        } else if (this.activeTrackingArrowData.unsetTargetCoord) {
            this.activeTrackingArrowData.setTargetCoord(solution.field_72450_a, solution.field_72448_b, solution.field_72449_c);
        }
        this.activeTrackingArrowData.update(homeIn);
    }

    public static MovingObjectPosition rayTraceBlocks(Vec3 par1Vec3D, Vec3 par2Vec3D, World world, int allowableBlocksType) {
        return ArrowHandler.rayTraceBlocks_do_do(par1Vec3D, par2Vec3D, false, false, world, allowableBlocksType);
    }

    public static MovingObjectPosition rayTraceBlocks_do(Vec3 par1Vec3D, Vec3 par2Vec3D, boolean par3, World world, int allowableBlocksType) {
        return ArrowHandler.rayTraceBlocks_do_do(par1Vec3D, par2Vec3D, par3, false, world, allowableBlocksType);
    }

    public static MovingObjectPosition rayTraceBlocks_do_do(Vec3 par1Vec3D, Vec3 par2Vec3D, boolean par3, boolean par4, World world, int allowableBlocksType) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(par1Vec3D.field_72450_a) || Double.isNaN(par1Vec3D.field_72448_b) || Double.isNaN(par1Vec3D.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(par2Vec3D.field_72450_a) || Double.isNaN(par2Vec3D.field_72448_b) || Double.isNaN(par2Vec3D.field_72449_c)) {
            return null;
        }
        int i = MathHelper.func_76128_c((double)par2Vec3D.field_72450_a);
        int j = MathHelper.func_76128_c((double)par2Vec3D.field_72448_b);
        int k = MathHelper.func_76128_c((double)par2Vec3D.field_72449_c);
        int l = MathHelper.func_76128_c((double)par1Vec3D.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)par1Vec3D.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)par1Vec3D.field_72449_c);
        int k1 = world.func_72798_a(l, i1, j1);
        int i2 = world.func_72805_g(l, i1, j1);
        Block block = Block.field_71973_m[k1];
        if ((!par4 || block == null || block.func_71872_e(world, l, i1, j1) != null) && k1 > 0 && ArrowHandler.isBlockAllowable(block, i2, par3, allowableBlocksType) && (movingobjectposition = block.func_71878_a(world, l, i1, j1, par1Vec3D, par2Vec3D)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            if (Double.isNaN(par1Vec3D.field_72450_a) || Double.isNaN(par1Vec3D.field_72448_b) || Double.isNaN(par1Vec3D.field_72449_c)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            boolean flag = true;
            boolean flag1 = true;
            boolean flag2 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            } else if (i < l) {
                d = (double)l + 0.0;
            } else {
                flag = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag1 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag2 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = par2Vec3D.field_72450_a - par1Vec3D.field_72450_a;
            double d7 = par2Vec3D.field_72448_b - par1Vec3D.field_72448_b;
            double d8 = par2Vec3D.field_72449_c - par1Vec3D.field_72449_c;
            if (flag) {
                d3 = (d - par1Vec3D.field_72450_a) / d6;
            }
            if (flag1) {
                d4 = (d1 - par1Vec3D.field_72448_b) / d7;
            }
            if (flag2) {
                d5 = (d2 - par1Vec3D.field_72449_c) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                par1Vec3D.field_72450_a = d;
                par1Vec3D.field_72448_b += d7 * d3;
                par1Vec3D.field_72449_c += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                par1Vec3D.field_72450_a += d6 * d4;
                par1Vec3D.field_72448_b = d1;
                par1Vec3D.field_72449_c += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                par1Vec3D.field_72450_a += d6 * d5;
                par1Vec3D.field_72448_b += d7 * d5;
                par1Vec3D.field_72449_c = d2;
            }
            Vec3 vec3d = Vec3.func_72443_a((double)par1Vec3D.field_72450_a, (double)par1Vec3D.field_72448_b, (double)par1Vec3D.field_72449_c);
            vec3d.field_72450_a = MathHelper.func_76128_c((double)par1Vec3D.field_72450_a);
            l = (int)vec3d.field_72450_a;
            if (byte0 == 5) {
                --l;
                vec3d.field_72450_a += 1.0;
            }
            vec3d.field_72448_b = MathHelper.func_76128_c((double)par1Vec3D.field_72448_b);
            i1 = (int)vec3d.field_72448_b;
            if (byte0 == 1) {
                --i1;
                vec3d.field_72448_b += 1.0;
            }
            vec3d.field_72449_c = MathHelper.func_76128_c((double)par1Vec3D.field_72449_c);
            j1 = (int)vec3d.field_72449_c;
            if (byte0 == 3) {
                --j1;
                vec3d.field_72449_c += 1.0;
            }
            int j2 = world.func_72798_a(l, i1, j1);
            int k2 = world.func_72805_g(l, i1, j1);
            Block block1 = Block.field_71973_m[j2];
            if (par4 && block1 != null && block1.func_71872_e(world, l, i1, j1) == null || j2 <= 0 || !ArrowHandler.isBlockAllowable(block1, k2, par3, allowableBlocksType) || (movingobjectposition1 = block1.func_71878_a(world, l, i1, j1, par1Vec3D, par2Vec3D)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public static boolean isBlockAllowable(Block block, int i2, boolean par3, int allowCrops) {
        boolean isAllowable = true;
        switch (allowCrops) {
            case 0: {
                isAllowable = ArrowHandler.isSolidBlock(block, i2, par3);
            }
        }
        return isAllowable;
    }

    public static boolean isSolidBlock(Block block, int par1, boolean par2) {
        if (block.func_71913_a(par1, par2) && block.field_72018_cp.func_76220_a() && block.field_72018_cp.func_76218_k()) {
            return true;
        }
        return block.field_72018_cp == Material.field_76268_x || block.field_72018_cp == Material.field_76257_i || block == Block.field_72014_bd;
    }

    static {
        rand = new Random();
    }
}

