/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry;

import cpw.mods.fml.client.FMLClientHandler;
import mods.battlegear2.api.IHeraldyItem;
import mods.battlegear2.client.heraldry.HeraldryIcon;
import mods.battlegear2.client.heraldry.HeraldryPositions;
import mods.battlegear2.client.heraldry.HeraldyPattern;
import mods.battlegear2.common.heraldry.SigilHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class HeraldryItemRenderer
implements IItemRenderer {
    Minecraft mc;
    RenderItem itemRenderer;
    private float trimZRaiseFactor;

    public HeraldryItemRenderer() {
        this(1.0f);
    }

    public HeraldryItemRenderer(float trimZRaiseFactor) {
        this.trimZRaiseFactor = trimZRaiseFactor;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY) && item.func_77973_b() instanceof IHeraldyItem && ((IHeraldyItem)item.func_77973_b()).hasHeraldry(item);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && (helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71375_t());
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.mc == null) {
            this.mc = FMLClientHandler.instance().getClient();
            this.itemRenderer = new RenderItem();
        }
        if (item != null) {
            if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                this.drawEquippedHeraldryItem(item, data);
            }
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                this.drawInventoryHeraldryItem(item, data);
            }
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                this.drawIEntityHeraldryItem(item, data);
            }
        }
    }

    protected void drawIEntityHeraldryItem(ItemStack item, Object[] data) {
        EntityItem entiyItem = (EntityItem)data[1];
        GL11.glPushMatrix();
        if (RenderItem.field_82407_g) {
            GL11.glScalef((float)1.2f, (float)1.2f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.375f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.mc.field_71451_h.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.drawEquippedHeraldryItem(item, data);
        GL11.glPopMatrix();
    }

    protected void drawInventoryHeraldryItem(ItemStack item, Object[] data) {
        this.mc.field_71446_o.func_98187_b("/gui/items.png");
        Tessellator tessellator = Tessellator.field_78398_a;
        IHeraldyItem heraldryItem = (IHeraldyItem)item.func_77973_b();
        int code = heraldryItem.getHeraldryCode(item);
        Icon icon = heraldryItem.getBaseIcon();
        float[] colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour1(code)]);
        GL11.glColor4f((float)colour[2], (float)colour[1], (float)colour[0], (float)1.0f);
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.PrimaryColourBase) && icon != null) {
            this.itemRenderer.func_94149_a(0, 0, icon, 16, 16);
        }
        GL11.glDepthFunc((int)518);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour2(code)]);
        GL11.glColor4f((float)colour[2], (float)colour[1], (float)colour[0], (float)1.0f);
        this.mc.field_71446_o.func_98187_b(HeraldyPattern.values()[SigilHelper.getPattern(code)].getPath());
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.SecondaryColourPattern)) {
            this.renderTexturedQuad(0, 0, 16, 16, this.itemRenderer.field_77023_b);
        }
        float[] colourIconPrimary = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getIconColour1(code)]);
        float[] colourIconSconondary = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getIconColour2(code)]);
        HeraldryPositions position = HeraldryPositions.values()[SigilHelper.getIconPos(code)];
        HeraldryIcon sigil = HeraldryIcon.values()[SigilHelper.getIcon(code)];
        if (!HeraldryIcon.Blank.equals((Object)sigil) && heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.Sigil)) {
            boolean flipColours;
            boolean flip;
            float width;
            float y;
            float x;
            int i;
            this.mc.field_71446_o.func_98187_b(sigil.getForegroundImagePath());
            for (i = 0; i < position.getPassess(); ++i) {
                x = position.getSourceX(i);
                y = position.getSourceY(i);
                width = position.getWidth();
                flip = position.getPatternFlip(i);
                flipColours = position.getAltColours(i);
                if (flipColours) {
                    GL11.glColor4f((float)colourIconSconondary[2], (float)colourIconSconondary[1], (float)colourIconSconondary[0], (float)1.0f);
                } else {
                    GL11.glColor4f((float)colourIconPrimary[2], (float)colourIconPrimary[1], (float)colourIconPrimary[0], (float)1.0f);
                }
                if (flip) {
                    this.renderTexturedQuad(0, 0, 16, 16, this.itemRenderer.field_77023_b - 10.0f, x + width, y, x, y + width);
                    continue;
                }
                this.renderTexturedQuad(0, 0, 16, 16, this.itemRenderer.field_77023_b - 10.0f, x, y, x + width, y + width);
            }
            this.mc.field_71446_o.func_98187_b(sigil.getBackgroundImagePath());
            for (i = 0; i < position.getPassess(); ++i) {
                x = position.getSourceX(i);
                y = position.getSourceY(i);
                width = position.getWidth();
                flip = position.getPatternFlip(i);
                flipColours = position.getAltColours(i);
                if (!flipColours) {
                    GL11.glColor4f((float)colourIconSconondary[2], (float)colourIconSconondary[1], (float)colourIconSconondary[0], (float)1.0f);
                } else {
                    GL11.glColor4f((float)colourIconPrimary[2], (float)colourIconPrimary[1], (float)colourIconPrimary[0], (float)1.0f);
                }
                if (flip) {
                    this.renderTexturedQuad(0, 0, 16, 16, this.itemRenderer.field_77023_b - 10.0f, x + width, y, x, y + width);
                    continue;
                }
                this.renderTexturedQuad(0, 0, 16, 16, this.itemRenderer.field_77023_b - 10.0f, x, y, x + width, y + width);
            }
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
        this.mc.field_71446_o.func_98187_b("/gui/items.png");
        colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour2(code)]);
        GL11.glColor4f((float)colour[2], (float)colour[1], (float)colour[0], (float)1.0f);
        icon = heraldryItem.getTrimIcon();
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.SecondaryColourTrim) && icon != null) {
            this.itemRenderer.func_94149_a(0, 0, icon, 16, 16);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        icon = heraldryItem.getPostRenderIcon();
        this.itemRenderer.func_94149_a(0, 0, icon, 16, 16);
    }

    public void drawEquippedHeraldryItem(ItemStack item, Object ... data) {
        this.mc.field_71446_o.func_98187_b("/gui/items.png");
        Tessellator tessellator = Tessellator.field_78398_a;
        IHeraldyItem heraldryItem = (IHeraldyItem)item.func_77973_b();
        int code = heraldryItem.getHeraldryCode(item);
        Icon icon = heraldryItem.getBaseIcon();
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        float[] colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour1(code)]);
        GL11.glColor3f((float)colour[2], (float)colour[1], (float)colour[0]);
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.PrimaryColourBase) && icon != null) {
            ItemRenderer cfr_ignored_0 = RenderManager.field_78727_a.field_78721_f;
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94213_j(), (int)icon.func_94208_k(), (float)0.0625f);
        }
        icon = HeraldyPattern.values()[SigilHelper.getPattern(code)].getIcon();
        colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour2(code)]);
        GL11.glColor3f((float)colour[2], (float)colour[1], (float)colour[0]);
        GL11.glDepthFunc((int)514);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        this.mc.field_71446_o.func_98187_b(HeraldyPattern.values()[SigilHelper.getPattern(code)].getPath());
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.SecondaryColourPattern) && icon != null) {
            HeraldryItemRenderer.renderItemIn2D_2(tessellator, 0.0f, 0.0f, 1.0f, 1.0f, 16, 16, 0.0625f);
        }
        float[] colourIconPrimary = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getIconColour1(code)]);
        float[] colourIconSconondary = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getIconColour2(code)]);
        HeraldryPositions position = HeraldryPositions.values()[SigilHelper.getIconPos(code)];
        HeraldryIcon sigil = HeraldryIcon.values()[SigilHelper.getIcon(code)];
        GL11.glDisable((int)2896);
        if (!HeraldryIcon.Blank.equals((Object)sigil) && heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.Sigil)) {
            boolean flipColours;
            boolean flip;
            float width;
            float y;
            float x;
            int i;
            this.mc.field_71446_o.func_98187_b(sigil.getForegroundImagePath());
            for (i = 0; i < position.getPassess(); ++i) {
                x = position.getSourceX(i);
                y = position.getSourceY(i);
                width = position.getWidth();
                flip = position.getPatternFlip(i);
                flipColours = position.getAltColours(i);
                if (flipColours) {
                    GL11.glColor4f((float)colourIconSconondary[2], (float)colourIconSconondary[1], (float)colourIconSconondary[0], (float)1.0f);
                } else {
                    GL11.glColor4f((float)colourIconPrimary[2], (float)colourIconPrimary[1], (float)colourIconPrimary[0], (float)1.0f);
                }
                if (flip) {
                    ItemRenderer cfr_ignored_1 = RenderManager.field_78727_a.field_78721_f;
                    ItemRenderer.func_78439_a((Tessellator)tessellator, (float)(x + width), (float)y, (float)x, (float)(width + y), (int)16, (int)16, (float)0.0625f);
                    continue;
                }
                ItemRenderer cfr_ignored_2 = RenderManager.field_78727_a.field_78721_f;
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)x, (float)y, (float)(x + width), (float)(width + y), (int)16, (int)16, (float)0.0625f);
            }
            this.mc.field_71446_o.func_98187_b(sigil.getBackgroundImagePath());
            for (i = 0; i < position.getPassess(); ++i) {
                x = position.getSourceX(i);
                y = position.getSourceY(i);
                width = position.getWidth();
                flip = position.getPatternFlip(i);
                flipColours = position.getAltColours(i);
                if (!flipColours) {
                    GL11.glColor4f((float)colourIconSconondary[2], (float)colourIconSconondary[1], (float)colourIconSconondary[0], (float)1.0f);
                } else {
                    GL11.glColor4f((float)colourIconPrimary[2], (float)colourIconPrimary[1], (float)colourIconPrimary[0], (float)1.0f);
                }
                if (flip) {
                    ItemRenderer cfr_ignored_3 = RenderManager.field_78727_a.field_78721_f;
                    ItemRenderer.func_78439_a((Tessellator)tessellator, (float)(x + width), (float)y, (float)x, (float)(width + y), (int)16, (int)16, (float)0.0625f);
                    continue;
                }
                ItemRenderer cfr_ignored_4 = RenderManager.field_78727_a.field_78721_f;
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)x, (float)y, (float)(x + width), (float)(width + y), (int)16, (int)16, (float)0.0625f);
            }
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
        this.mc.field_71446_o.func_98187_b("/gui/items.png");
        colour = SigilHelper.convertColourToARGBArray(SigilHelper.colours[SigilHelper.getColour2(code)]);
        GL11.glColor3f((float)colour[2], (float)colour[1], (float)colour[0]);
        icon = heraldryItem.getTrimIcon();
        if (heraldryItem.shouldDoPass(IHeraldyItem.HeraldyRenderPassess.SecondaryColourTrim) && icon != null) {
            ItemRenderer cfr_ignored_5 = RenderManager.field_78727_a.field_78721_f;
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94213_j(), (int)icon.func_94208_k(), (float)(0.0625f * this.trimZRaiseFactor));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        icon = heraldryItem.getPostRenderIcon();
        ItemRenderer cfr_ignored_6 = RenderManager.field_78727_a.field_78721_f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94213_j(), (int)icon.func_94208_k(), (float)(0.0625f * this.trimZRaiseFactor));
        if (item != null && item.func_77962_s()) {
            HeraldryItemRenderer.renderEnchantmentEffects(tessellator);
        }
    }

    public void renderTexturedQuad(int par1, int par2, int par4, int par5, float zLevel) {
        this.renderTexturedQuad(par1, par2, par4, par5, zLevel, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void renderTexturedQuad(int par1, int par2, int par4, int par5, float zLevel, float minX, float minY, float maxX, float maxY) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), (double)zLevel, (double)minX, (double)maxY);
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), (double)zLevel, (double)maxX, (double)maxY);
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), (double)zLevel, (double)maxX, (double)minY);
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)minX, (double)minY);
        tessellator.func_78381_a();
    }

    public static void renderItemIn2D_2(Tessellator par0Tessellator, float par1, float par2, float par3, float par4, int par5, int par6, float par7) {
        par0Tessellator.func_78382_b();
        par0Tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        par0Tessellator.func_78374_a(0.0, 0.0, 0.0, (double)par1, (double)par4);
        par0Tessellator.func_78374_a(1.0, 0.0, 0.0, (double)par3, (double)par4);
        par0Tessellator.func_78374_a(1.0, 1.0, 0.0, (double)par3, (double)par2);
        par0Tessellator.func_78374_a(0.0, 1.0, 0.0, (double)par1, (double)par2);
        par0Tessellator.func_78381_a();
        par0Tessellator.func_78382_b();
        par0Tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        par0Tessellator.func_78374_a(0.0, 1.0, (double)(0.0f - par7), (double)par1, (double)par2);
        par0Tessellator.func_78374_a(1.0, 1.0, (double)(0.0f - par7), (double)par3, (double)par2);
        par0Tessellator.func_78374_a(1.0, 0.0, (double)(0.0f - par7), (double)par3, (double)par4);
        par0Tessellator.func_78374_a(0.0, 0.0, (double)(0.0f - par7), (double)par1, (double)par4);
        par0Tessellator.func_78381_a();
    }

    public static void renderEnchantmentEffects(Tessellator tessellator) {
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("%blur%/misc/glint.png");
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)768, (int)1);
        float f7 = 0.76f;
        GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        float f8 = 0.125f;
        GL11.glScalef((float)f8, (float)f8, (float)f8);
        float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
        GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ItemRenderer cfr_ignored_0 = RenderManager.field_78727_a.field_78721_f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)f8, (float)f8, (float)f8);
        f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
        GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ItemRenderer cfr_ignored_1 = RenderManager.field_78727_a.field_78721_f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }
}

