/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.battlegear2.common.BattleGear;
import mods.battlegear2.common.gui.ContainerHeraldry;
import mods.battlegear2.common.inventory.InventoryPlayerBattle;
import mods.battlegear2.common.utils.BattlegearUtils;
import mods.battlegear2.common.utils.EnumBGAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BattlegearPacketHandeler
implements IPacketHandler {
    public static final String guiPackets = "MB-GUI";
    public static final String syncBattlePackets = "MB-SyncAllItems";
    public static final String mbAnimation = "MB-animation";
    public static final String guiHeraldryIconChange = "MB-HeraldChange";

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (packet.field_73630_a.equals(syncBattlePackets)) {
            this.processBattleItemsSync(packet, (EntityPlayer)player);
        } else if (packet.field_73630_a.equals(guiPackets)) {
            this.processBattlegearGUIPacket(packet, (EntityPlayer)player);
        } else if (packet.field_73630_a.equals(mbAnimation)) {
            this.processOffHandAnimationPacket(packet, ((EntityPlayer)player).field_70170_p);
        } else if (packet.field_73630_a.equals(guiHeraldryIconChange)) {
            this.processHeraldryChangePacket(packet, (EntityPlayer)player);
        }
    }

    public static Packet250CustomPayload generateHeraldryChangeGUIPacket(int code, EntityPlayer player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(player.field_71070_bA.field_75152_c);
            outputStream.writeInt(code);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = guiHeraldryIconChange;
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        return packet;
    }

    private void processHeraldryChangePacket(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        int windowID = 0;
        int code = 0;
        try {
            windowID = inputStream.readInt();
            code = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(player.field_71070_bA.field_75152_c + ", " + windowID);
        if (player.field_71070_bA.field_75152_c == windowID && player.field_71070_bA.func_75129_b(player)) {
            ((ContainerHeraldry)player.field_71070_bA).setCode(code);
            player.field_71070_bA.func_75142_b();
        }
    }

    public static Packet250CustomPayload generateGUIPacket(int equipid) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(equipid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = guiPackets;
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        return packet;
    }

    private void processBattlegearGUIPacket(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        int windowID = 0;
        try {
            windowID = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        player.openGui((Object)BattleGear.instance, windowID, player.field_70170_p, 0, 0, 0);
    }

    public static Packet250CustomPayload generateSyncBattleItemsPacket(String user, InventoryPlayer inventory) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(5120);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            Packet.func_73271_a((String)user, (DataOutputStream)outputStream);
            outputStream.writeInt(inventory.field_70461_c);
            Packet.func_73270_a((ItemStack)inventory.func_70448_g(), (DataOutputStream)outputStream);
            for (int i = 0; i < InventoryPlayerBattle.EXTRA_INV_SIZE; ++i) {
                Packet.func_73270_a((ItemStack)inventory.func_70301_a(i + InventoryPlayerBattle.OFFSET), (DataOutputStream)outputStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = syncBattlePackets;
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        return packet;
    }

    private void processBattleItemsSync(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            EntityPlayer targetPlayer = player.field_70170_p.func_72924_a(Packet.func_73282_a((DataInputStream)inputStream, (int)30));
            targetPlayer.field_71071_by.field_70461_c = inputStream.readInt();
            BattlegearUtils.setPlayerCurrentItem(targetPlayer, Packet.func_73276_c((DataInputStream)inputStream));
            for (int i = 0; i < InventoryPlayerBattle.EXTRA_INV_SIZE; ++i) {
                ItemStack stack = Packet.func_73276_c((DataInputStream)inputStream);
                if (stack == null) continue;
                targetPlayer.field_71071_by.func_70299_a(InventoryPlayerBattle.OFFSET + i, stack);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static Packet250CustomPayload generateBgAnimationPacket(EnumBGAnimations animation, String username) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(300);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(animation.ordinal());
            Packet.func_73271_a((String)username, (DataOutputStream)outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = mbAnimation;
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        return packet;
    }

    private void processOffHandAnimationPacket(Packet250CustomPayload packet, World world) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        String playername = null;
        EnumBGAnimations animation = null;
        try {
            animation = EnumBGAnimations.values()[inputStream.readInt()];
            playername = Packet.func_73282_a((DataInputStream)inputStream, (int)16);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (playername != null && animation != null) {
            EntityPlayer entity = world.func_72924_a(playername);
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_73039_n().func_72784_a((Entity)entity, (Packet)packet);
            }
            animation.processAnimation((Entity)entity);
        }
    }
}

