/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common.heraldry;

public class SigilHelper {
    public static final int defaultSigil = SigilHelper.packSigil(0, 4, 4, 0, 0, 0, 0);
    public static final int[] colours_16 = new int[]{0x191919, 0xCC4C4C, 6717235, 8349260, 0x3366CC, 11691749, 5020082, 0x999999, 0x4C4C4C, 15905484, 8375321, 0xE5E533, 10072818, 15040472, 15905331, 0xFFFFFF};
    public static final int[] colours = new int[]{0x191919, 0x4C4C4C, 0x808080, 0x999999, 0xFFFFFF, 0x800000, 0xFF0000, 0xFF8080, 0xFF8000, 0x808000, 0xFFFF00, 0xFFFF80, 32768, 65280, 0x80FF00, 0x80FF80, 65408, 32896, 65535, 0x80FFFF, 128, 255, 33023, 0x8080FF, 0x8000FF, 0x800080, 0xFF00FF, 0xFF80FF, 0xFF0080, 0x804000, 0xC08000};

    public static float[] convertColourToARGBArray(int value) {
        return new float[]{(float)(value & 0xFF) / 256.0f, (float)((value & 0xFF00) >> 8) / 256.0f, (float)((value & 0xFF0000) >> 16) / 256.0f};
    }

    public static int packSigil(int pattern, int colour1, int colour2, int icon, int iconColour1, int iconColour2, int iconPos) {
        return pattern | colour1 << 4 | colour2 << 9 | icon << 14 | iconColour1 << 19 | iconColour2 << 24 | iconPos << 29;
    }

    public static int extractBit(int code, int begin, int end) {
        return code << 31 - end >>> 31 + begin - end;
    }

    public static int getPattern(int code) {
        return SigilHelper.extractBit(code, 0, 3);
    }

    public static int getColour1(int code) {
        return SigilHelper.extractBit(code, 4, 8);
    }

    public static int getColour2(int code) {
        return SigilHelper.extractBit(code, 9, 13);
    }

    public static int getIcon(int code) {
        return SigilHelper.extractBit(code, 14, 18);
    }

    public static int getIconColour1(int code) {
        return SigilHelper.extractBit(code, 19, 23);
    }

    public static int getIconColour2(int code) {
        return SigilHelper.extractBit(code, 24, 28);
    }

    public static int getIconPos(int code) {
        return SigilHelper.extractBit(code, 29, 31);
    }
}

