/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryPlayerBattle
extends InventoryPlayer {
    public static int OFFSET = 150;
    public static int WEAPON_SETS = 3;
    public static int EXTRA_INV_SIZE = WEAPON_SETS * 2 + 6 + 6;
    public ItemStack[] extraItems = new ItemStack[EXTRA_INV_SIZE];

    public InventoryPlayerBattle(EntityPlayer par1EntityPlayer) {
        super(par1EntityPlayer);
    }

    public boolean isBattlemode() {
        return this.field_70461_c < OFFSET + 2 * WEAPON_SETS && this.field_70461_c >= OFFSET;
    }

    public static boolean isValidSwitch(int id) {
        return id >= 0 && id < InventoryPlayerBattle.func_70451_h() || id >= OFFSET && id < OFFSET + 2 * WEAPON_SETS;
    }

    public ItemStack func_70448_g() {
        return this.isBattlemode() ? this.extraItems[this.field_70461_c - OFFSET] : super.func_70448_g();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70433_a(int par1, int par2, boolean par3, boolean par4) {
        if (!this.isBattlemode()) {
            super.func_70433_a(par1, par2, par3, par4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70453_c(int direction) {
        if (this.isBattlemode()) {
            direction = Math.min(direction, 1);
            direction = Math.max(direction, -1);
            this.field_70461_c -= direction;
            while (this.field_70461_c < OFFSET) {
                this.field_70461_c += WEAPON_SETS;
            }
            while (this.field_70461_c >= OFFSET + WEAPON_SETS) {
                this.field_70461_c -= WEAPON_SETS;
            }
        } else {
            super.func_70453_c(direction);
        }
    }

    public int func_82347_b(int targetId, int targetDamage) {
        int stacks = super.func_82347_b(targetId, targetDamage);
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null || targetId > -1 && this.extraItems[i].field_77993_c != targetId || targetDamage > -1 && this.extraItems[i].func_77960_j() != targetDamage) continue;
            stacks += this.extraItems[i].field_77994_a;
            this.extraItems[i] = null;
        }
        return stacks;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot >= OFFSET) {
            ItemStack targetStack = this.extraItems[slot - OFFSET];
            if (targetStack != null) {
                if (targetStack.field_77994_a <= amount) {
                    this.extraItems[slot - InventoryPlayerBattle.OFFSET] = null;
                    return targetStack;
                }
                targetStack = this.extraItems[slot - OFFSET].func_77979_a(amount);
                if (this.extraItems[slot].field_77994_a == 0) {
                    this.extraItems[slot] = null;
                }
                return targetStack;
            }
            return null;
        }
        return super.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= OFFSET) {
            return this.extraItems[slot - OFFSET];
        }
        return super.func_70304_b(slot);
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= OFFSET) {
            return this.extraItems[slot - OFFSET];
        }
        return super.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77993_c == 0) {
            itemStack = null;
        }
        if (slot >= OFFSET) {
            this.extraItems[slot - InventoryPlayerBattle.OFFSET] = itemStack;
        } else {
            super.func_70299_a(slot, itemStack);
        }
    }

    public void func_70455_b(InventoryPlayer par1InventoryPlayer) {
        this.extraItems = new ItemStack[EXTRA_INV_SIZE];
        super.func_70455_b(par1InventoryPlayer);
        if (par1InventoryPlayer instanceof InventoryPlayerBattle) {
            for (int i = 0; i < this.extraItems.length; ++i) {
                this.extraItems[i] = par1InventoryPlayer.func_70301_a(i + OFFSET);
            }
        }
    }

    public NBTTagList func_70442_a(NBTTagList par1nbtTagList) {
        NBTTagList nbtList = super.func_70442_a(par1nbtTagList);
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)(i + OFFSET));
            this.extraItems[i].func_77955_b(nbttagcompound);
            nbtList.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbtList;
    }

    public void func_70443_b(NBTTagList nbtTagList) {
        super.func_70443_b(nbtTagList);
        this.extraItems = new ItemStack[EXTRA_INV_SIZE];
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            ItemStack itemstack;
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbtTagList.func_74743_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < OFFSET || (itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound)) == null) continue;
            this.extraItems[j - InventoryPlayerBattle.OFFSET] = itemstack;
        }
    }

    public float func_70438_a(Block block) {
        if (this.isBattlemode()) {
            ItemStack currentItemStack = this.func_70448_g();
            return currentItemStack != null ? currentItemStack.func_77967_a(block) : 1.0f;
        }
        return super.func_70438_a(block);
    }

    public int func_70444_a(Entity par1Entity) {
        if (this.isBattlemode()) {
            ItemStack currentItemStack = this.func_70448_g();
            return currentItemStack != null ? currentItemStack.func_77971_a(par1Entity) : 1;
        }
        return super.func_70444_a(par1Entity);
    }

    public ItemStack getCurrentOffItem() {
        if (this.isBattlemode()) {
            return this.func_70301_a(this.field_70461_c + 3);
        }
        return null;
    }
}

