/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.api.IHeraldyArmour;
import mods.battlegear2.api.IHeraldyItem;
import mods.battlegear2.client.heraldry.HeraldryArmourModel;
import mods.battlegear2.client.heraldry.HeraldyPattern;
import mods.battlegear2.common.BattleGear;
import mods.battlegear2.common.heraldry.SigilHelper;
import mods.battlegear2.common.inventory.InventoryPlayerBattle;
import mods.battlegear2.common.utils.BattlegearConfig;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.IArmorTextureProvider;

public class ItemKnightArmour
extends ItemArmor
implements IHeraldyArmour,
IArmorTextureProvider {
    private Icon baseIcon;
    private Icon postRenderIcon;
    private Icon trimRenderIcon;

    public ItemKnightArmour(int id, int armourType) {
        super(id, BattleGear.knightArmourMaterial, 1, armourType);
        this.func_77637_a(BattlegearConfig.customTab);
        this.func_77655_b("battlegear2:knights_armour." + BattlegearConfig.armourTypes[armourType]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.baseIcon = par1IconRegister.func_94245_a("battlegear2:armours/knight-base-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        this.postRenderIcon = par1IconRegister.func_94245_a("battlegear2:armours/knight-post-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        if (this.field_77881_a == 2) {
            this.trimRenderIcon = par1IconRegister.func_94245_a("battlegear2:armours/knight-trim-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        }
    }

    @Override
    public Icon getBaseIcon() {
        return this.baseIcon;
    }

    @Override
    public Icon getPostRenderIcon() {
        return this.postRenderIcon;
    }

    @Override
    public Icon getTrimIcon() {
        return this.trimRenderIcon;
    }

    @Override
    public boolean hasHeraldry(ItemStack stack) {
        return true;
    }

    @Override
    public int getHeraldryCode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("heraldry")) {
            stack.func_77978_p().func_74768_a("heraldry", SigilHelper.defaultSigil);
            return SigilHelper.defaultSigil;
        }
        return stack.func_77978_p().func_74762_e("heraldry");
    }

    @Override
    public void setHeraldryCode(ItemStack stack, int code) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("heraldry", code);
    }

    @Override
    public void removeHeraldry(ItemStack item) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74768_a("heraldry", SigilHelper.defaultSigil);
        }
    }

    @Override
    public boolean shouldDoPass(IHeraldyItem.HeraldyRenderPassess pass) {
        if (pass.equals((Object)IHeraldyItem.HeraldyRenderPassess.PrimaryColourBase) || pass.equals((Object)IHeraldyItem.HeraldyRenderPassess.SecondaryColourTrim) || pass.equals((Object)IHeraldyItem.HeraldyRenderPassess.PostRenderIcon)) {
            return true;
        }
        return this.field_77881_a == 1;
    }

    public String getArmorTextureFile(ItemStack itemstack) {
        return null;
    }

    @Override
    public boolean useDefaultRenderer() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, int layer) {
        return BattleGear.imageFolder + "armours/knights/knights-" + (slot == 2 ? 1 : 0) + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLiving entityLiving, ItemStack itemStack, int armorSlot) {
        HeraldryArmourModel model = new HeraldryArmourModel(armorSlot);
        model.setItemStack(itemStack);
        model.field_78116_c.field_78806_j = armorSlot == 0;
        model.field_78114_d.field_78806_j = false;
        model.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
        model.field_78112_f.field_78806_j = armorSlot == 1;
        model.field_78113_g.field_78806_j = armorSlot == 1;
        model.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
        model.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
        int n = model.field_78120_m = entityLiving.func_70694_bm() == null ? 0 : 1;
        if (entityLiving instanceof EntityPlayer) {
            if (entityLiving.func_70694_bm() != null && ((EntityPlayer)entityLiving).func_71052_bv() > 0) {
                EnumAction enumaction = entityLiving.func_70694_bm().func_77975_n();
                if (enumaction == EnumAction.block) {
                    model.field_78120_m = 3;
                }
                model.field_78118_o = enumaction == EnumAction.bow;
            }
            model.field_78119_l = ((EntityPlayer)entityLiving).field_71071_by.func_70301_a(((EntityPlayer)entityLiving).field_71071_by.field_70461_c + InventoryPlayerBattle.WEAPON_SETS) == null ? 0 : 1;
        }
        model.field_78117_n = entityLiving.func_70093_af();
        return model;
    }

    @Override
    public String getBaseArmourPath(int armourSlot) {
        return BattleGear.imageFolder + "armours/knights/knights-base-" + (armourSlot == 2 ? 1 : 0) + ".png";
    }

    @Override
    public String getPatternArmourPath(HeraldyPattern pattern, int armourSlot) {
        return BattleGear.imageFolder + "armours/knights/patterns/knights-pattern-" + (armourSlot == 2 ? 1 : 0) + "-" + pattern.ordinal() + ".png";
    }
}

