/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common.utils;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import mods.battlegear2.common.inventory.CreativeTabMB_B_2;
import mods.battlegear2.common.items.ItemDagger;
import mods.battlegear2.common.items.ItemHeradryIcon;
import mods.battlegear2.common.items.ItemMace;
import mods.battlegear2.common.items.ItemSpear;
import mods.battlegear2.common.items.ItemWaraxe;
import mods.battlegear2.common.items.ItemWeapon;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;

public class BattlegearConfigBackup {
    public static final CreativeTabs customTab = new CreativeTabMB_B_2("Battlegear2");
    public static boolean forceBackSheath = false;
    public static int[] setID = new int[8];
    public static int[] validWeaponsID = new int[]{11, 12, 16, 20, 27};
    public static final String[] itemNames = new String[]{"Banner", "Quiver", "Chain", "Dagger", "Waraxe", "Mace", "Spear", "Shield"};
    public static ItemWeapon[] dagger = new ItemWeapon[5];
    public static ItemWeapon[] warAxe = new ItemWeapon[5];
    public static ItemWeapon[] mace = new ItemWeapon[5];
    public static ItemWeapon[] spear = new ItemWeapon[5];
    public static ItemWeapon[] shield = new ItemWeapon[5];
    public static Item chains;
    public static Item quiver;
    public static Item banner;
    public static Item heradricItem;
    public static ItemArmor[] knightArmor;

    public static void getConfig(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile(), true);
        config.load();
        for (int i = 0; i < itemNames.length; ++i) {
            BattlegearConfigBackup.setID[i] = config.get("item", itemNames[i] + " ID", i < 3 ? 22000 + i : 22003 + 5 * (i - 3), "Warning, real ID range goes from 22256 to 22282").getInt();
        }
        forceBackSheath = config.get("general", "Force Back Sheath", false).getBoolean(false);
        validWeaponsID = config.get("general", "Valid Weapon IDs", new int[]{11, 12, 16, 20, 27}).getIntList();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setItems() {
        banner = new Item(setID[0]);
        quiver = new Item(setID[1]).func_77655_b("battlegear2:" + itemNames[1]).func_77637_a(customTab);
        chains = new Item(setID[2]).func_77655_b("battlegear2:" + itemNames[2]).func_77637_a(customTab);
        for (int i = 0; i < 5; ++i) {
            EnumToolMaterial material = EnumToolMaterial.values()[i];
            BattlegearConfigBackup.dagger[i] = new ItemDagger(setID[3] + i, material, "Dagger-" + i);
            BattlegearConfigBackup.warAxe[i] = new ItemWaraxe(setID[4] + i, material, "Waraxe-" + i, i == 4 ? 2 : 1);
            BattlegearConfigBackup.mace[i] = new ItemMace(setID[5] + i, material, "Mace-" + i);
            BattlegearConfigBackup.spear[i] = new ItemSpear(setID[6] + i, material, "Spear-" + i);
        }
        heradricItem = new ItemHeradryIcon(21999);
    }

    public static void registerRecipes() {
        int i;
        for (i = 0; i < 15; ++i) {
            for (int j = 0; j < 15 && i != j; ++j) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(banner, 1, i), (Object[])new Object[]{new ItemStack(banner, 1, j), new ItemStack(Item.field_77756_aW, 1, i)});
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack(banner, 1, i), (Object[])new Object[]{"B", "B", "S", Character.valueOf('B'), new ItemStack(Block.field_72101_ab, 1, i), Character.valueOf('S'), Item.field_77669_D});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(quiver), (Object[])new Object[]{"L L", "L L", "LLL", Character.valueOf('L'), Item.field_77770_aF});
        for (i = 0; i < 5; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)dagger[i]), (Object[])new Object[]{"L", "S", Character.valueOf('S'), Item.field_77669_D, Character.valueOf('L'), i == 0 ? Block.field_71988_x : new ItemStack(dagger[i].getMaterial().func_82844_f(), 1, 0)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)warAxe[i], 1), (Object[])new Object[]{"L L", "LSL", " S ", Character.valueOf('S'), Item.field_77669_D, Character.valueOf('L'), i == 0 ? Block.field_71988_x : new ItemStack(warAxe[i].getMaterial().func_82844_f(), 1, 0)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)mace[i], 1), (Object[])new Object[]{" LL", " LL", "S  ", Character.valueOf('S'), Item.field_77669_D, Character.valueOf('L'), i == 0 ? Block.field_71988_x : new ItemStack(mace[i].getMaterial().func_82844_f(), 1, 0)});
            if (i == 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spear[i]), (Object[])new Object[]{"  S", " S ", "S  ", Character.valueOf('S'), Item.field_77669_D});
                continue;
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spear[i]), (Object[])new Object[]{"  I", " S ", Character.valueOf('S'), new ItemStack((Item)spear[0], 1), Character.valueOf('I'), new ItemStack(spear[i].getMaterial().func_82844_f(), 1, 0)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(chains, 2), (Object[])new Object[]{Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77694_Z), (Object[])new Object[]{"LLL", "L L", Character.valueOf('L'), chains});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77814_aa), (Object[])new Object[]{"L L", "LLL", "LLL", Character.valueOf('L'), chains});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77816_ab), (Object[])new Object[]{"LLL", "L L", "L L", Character.valueOf('L'), chains});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77810_ac), (Object[])new Object[]{"L L", "L L", Character.valueOf('L'), chains});
    }

    public static void addNames() {
        LanguageRegistry.instance();
        LanguageRegistry.addName((Object)banner, (String)itemNames[0]);
        LanguageRegistry.instance();
        LanguageRegistry.addName((Object)quiver, (String)itemNames[1]);
        LanguageRegistry.instance();
        LanguageRegistry.addName((Object)chains, (String)itemNames[2]);
        for (int i = 0; i < 5; ++i) {
            LanguageRegistry.instance();
            LanguageRegistry.addName((Object)dagger[i], (String)(dagger[i].getMaterial().name().toLowerCase() + " " + itemNames[3]));
            LanguageRegistry.instance();
            LanguageRegistry.addName((Object)warAxe[i], (String)(warAxe[i].getMaterial().name().toLowerCase() + " " + itemNames[4]));
            LanguageRegistry.instance();
            LanguageRegistry.addName((Object)mace[i], (String)(mace[i].getMaterial().name().toLowerCase() + " " + itemNames[5]));
            LanguageRegistry.instance();
            LanguageRegistry.addName((Object)spear[i], (String)(spear[i].getMaterial().name().toLowerCase() + " " + itemNames[6]));
        }
    }

    static {
        knightArmor = new ItemArmor[4];
    }
}

