/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.common.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import mods.battlegear2.api.IBattlegearWeapon;
import mods.battlegear2.common.utils.ReflectionMethod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public class BattlegearUtils {
    private static boolean[] weapons;
    private static boolean[] mainHandDualWeapons;
    private static boolean[] offhandDualWeapons;
    private static final ReflectionMethod[] itemMmethods;

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack, int offset) {
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c + offset, stack);
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        BattlegearUtils.setPlayerCurrentItem(player, stack, 0);
    }

    public static boolean isWeapon(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return true;
        }
        return weapons[id];
    }

    public static boolean isMainHand(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return ((IBattlegearWeapon)Item.field_77698_e[id]).willAllowOffhandWeapon();
        }
        return mainHandDualWeapons[id];
    }

    public static boolean isOffHand(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return ((IBattlegearWeapon)Item.field_77698_e[id]).isOffhandHandDualWeapon();
        }
        return offhandDualWeapons[id];
    }

    public static void scanAndProcessItems() {
        weapons = new boolean[Item.field_77698_e.length];
        mainHandDualWeapons = new boolean[Item.field_77698_e.length];
        offhandDualWeapons = new boolean[Item.field_77698_e.length];
        for (int i = 0; i < Item.field_77698_e.length; ++i) {
            boolean valid;
            Item item = Item.field_77698_e[i];
            BattlegearUtils.weapons[i] = false;
            BattlegearUtils.mainHandDualWeapons[i] = false;
            BattlegearUtils.offhandDualWeapons[i] = false;
            if (item == null) continue;
            boolean bl = valid = item.func_77639_j() == 1 && item.func_77645_m();
            if (!valid) continue;
            boolean bl2 = BattlegearUtils.weapons[i] = item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemTool;
            if (!weapons[i]) continue;
            boolean rightClickFunction = BattlegearUtils.checkForRightClickFunction(item);
            BattlegearUtils.offhandDualWeapons[i] = !(item instanceof ItemTool) && !(item instanceof ItemBow) && !rightClickFunction;
            BattlegearUtils.mainHandDualWeapons[i] = !(item instanceof ItemBow) && !rightClickFunction;
        }
    }

    public static boolean checkForRightClickFunction(Item item) {
        try {
            if (item.func_77661_b(null) == EnumAction.block || item.func_77661_b(null) == EnumAction.none) {
                Class<?> c = item.getClass();
                while (!(c.equals(Item.class) || c.equals(ItemTool.class) || c.equals(ItemSword.class))) {
                    for (Method method : c.getDeclaredMethods()) {
                        for (ReflectionMethod reflector : itemMmethods) {
                            if (!reflector.getName(false).equals(method.getName()) || !Arrays.deepEquals(reflector.getParameterTypes(), method.getParameterTypes())) continue;
                            return true;
                        }
                    }
                    c = c.getSuperclass();
                }
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    static {
        itemMmethods = new ReflectionMethod[]{new ReflectionMethod("onItemUse", "", new Class[]{ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}), new ReflectionMethod("onItemRightClick", "", new Class[]{ItemStack.class, World.class, EntityPlayer.class})};
    }
}

