/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IFilterFactory;

public class FilterRegistry {
    private static FilterRegistry instance;
    private LinkedList<IFilterFactory> mFactories = new LinkedList();

    public static FilterRegistry getInstance() {
        if (instance == null) {
            instance = new FilterRegistry();
        }
        return instance;
    }

    public static void registerFilterFactory(IFilterFactory factory) {
        FilterRegistry.getInstance().mFactories.add(factory);
    }

    public IFilter createFilter(ItemStack heldItem, IFilter existing, int button, boolean shift, boolean ctrl, boolean mustHavePayload) {
        for (IFilterFactory factory : this.mFactories) {
            IFilter filter = factory.getFilterFrom(heldItem, existing, button, shift, ctrl, mustHavePayload);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public void writeFilter(IFilter filter, NBTTagCompound tag) {
        tag.func_74778_a("FilterType", filter.getType());
        filter.write(tag);
    }

    public void writeFilter(IFilter filter, MCDataOutput output) {
        output.writeString(filter.getType());
        filter.write(output);
    }

    public IFilter readFilter(NBTTagCompound tag) {
        String type = tag.func_74779_i("FilterType");
        for (IFilterFactory factory : this.mFactories) {
            IFilter filter = factory.loadFilter(type, tag);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public IFilter readFilter(MCDataInput input) {
        String type = input.readString();
        for (IFilterFactory factory : this.mFactories) {
            IFilter filter = factory.loadFilter(type, input);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }
}

