/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import schmoller.tubes.api.Payload;

public class FluidPayload
extends Payload {
    public FluidStack fluid;
    public int lastDirection;
    public float lastProgress;
    public float coordX;
    public float coordY;
    public float coordZ;
    public int tickNo;

    public FluidPayload() {
    }

    public FluidPayload(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public Object get() {
        return this.fluid;
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        this.fluid.writeToNBT(tag);
    }

    @Override
    public void read(MCDataInput input) {
        this.fluid = input.readFluidStack();
    }

    @Override
    public void write(MCDataOutput output) {
        super.write(output);
        output.writeFluidStack(this.fluid);
    }

    @Override
    public FluidPayload copy() {
        return new FluidPayload(this.fluid.copy());
    }

    @Override
    public boolean isPayloadEqual(Payload other) {
        if (!this.isPayloadTypeEqual(other)) {
            return false;
        }
        return this.fluid.amount == ((FluidStack)other.get()).amount;
    }

    @Override
    public boolean isPayloadTypeEqual(Payload other) {
        if (!(other instanceof FluidPayload)) {
            return false;
        }
        return this.fluid.isFluidEqual((FluidStack)other.get());
    }

    @Override
    public int size() {
        return this.fluid.amount;
    }

    @Override
    public void setSize(int size) {
        this.fluid.amount = size;
    }

    @Override
    public int maxSize() {
        return 1000;
    }

    public String toString() {
        return this.fluid.toString();
    }
}

