/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.texture.IconRegister;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.client.ITubeRender;

public class TubeRegistry
implements MultiPartRegistry.IPartFactory {
    private static TubeRegistry mInstance;
    private boolean mCanAdd = true;
    private HashMap<String, TubeDefinition> mRegisteredTubes = new HashMap();
    private HashMap<TubeDefinition, ITubeRender> mRenderers = new HashMap();

    public static TubeRegistry instance() {
        if (mInstance == null) {
            mInstance = new TubeRegistry();
        }
        return mInstance;
    }

    public static void registerTube(TubeDefinition tube, String name) {
        assert (TubeRegistry.instance().mCanAdd);
        TubeRegistry.instance().mRegisteredTubes.put(name, tube);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderer(String typeName, ITubeRender render) {
        assert (TubeRegistry.instance().mCanAdd);
        assert (TubeRegistry.instance().mRegisteredTubes.containsKey(typeName));
        assert (render != null);
        TubeRegistry.instance().mRenderers.put(TubeRegistry.instance().mRegisteredTubes.get(typeName), render);
    }

    public void registerIcons(IconRegister register) {
        for (TubeDefinition def : this.mRegisteredTubes.values()) {
            def.registerIcons(register);
        }
    }

    public void finalizeTubes() {
        this.mCanAdd = false;
        String[] names = new String[this.mRegisteredTubes.size()];
        int index = 0;
        for (String key : this.mRegisteredTubes.keySet()) {
            names[index++] = "tubes_" + key;
        }
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)this, (String[])names);
    }

    public Set<String> getTypeNames() {
        return Collections.unmodifiableSet(this.mRegisteredTubes.keySet());
    }

    public TubeDefinition getDefinition(String name) {
        TubeDefinition def = this.mRegisteredTubes.get(name);
        if (def != null) {
            return def;
        }
        return this.mRegisteredTubes.get("basic");
    }

    @SideOnly(value=Side.CLIENT)
    public ITubeRender getRender(TubeDefinition def) {
        ITubeRender render = this.mRenderers.get(def);
        if (render != null) {
            return render;
        }
        this.mRenderers.put(def, this.mRenderers.get(this.getDefinition("basic")));
        return this.mRenderers.get(def);
    }

    public TMultiPart createPart(String name, boolean client) {
        String actualName = name.replaceFirst("tubes_", "");
        TubeDefinition def = this.getDefinition(actualName);
        return def.createTube();
    }
}

