/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api.gui;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.interfaces.IFilter;

public abstract class FakeSlot
extends Slot {
    private IFilter mFilter;
    private IFilter mLast;

    public FakeSlot(IFilter initial, int x, int y) {
        super((IInventory)new InventoryBasic("", false, 1), 0, x, y);
        this.mFilter = initial;
        this.mLast = initial;
        this.field_75224_c.func_70299_a(0, FakeSlot.toItem(initial));
    }

    public static ItemStack toItem(IFilter filter) {
        if (filter == null) {
            return null;
        }
        ItemStack item = new ItemStack(1, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound data = new NBTTagCompound();
        FilterRegistry.getInstance().writeFilter(filter, data);
        tag.func_74782_a("Filter", (NBTBase)data);
        item.func_77982_d(tag);
        return item;
    }

    public static IFilter fromItem(ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return null;
        }
        if (!item.func_77978_p().func_74764_b("Filter")) {
            return null;
        }
        return FilterRegistry.getInstance().readFilter(item.func_77978_p().func_74775_l("Filter"));
    }

    public final boolean func_82869_a(EntityPlayer player) {
        return false;
    }

    public final IFilter getFilter() {
        return this.mFilter;
    }

    public final void setFilter(IFilter filter) {
        this.mFilter = filter;
        this.field_75224_c.func_70299_a(0, FakeSlot.toItem(filter));
        this.setIfChanged();
    }

    public final ItemStack func_75209_a(int amount) {
        return super.func_75209_a(amount);
    }

    public int func_75219_a() {
        return Integer.MAX_VALUE;
    }

    private void setIfChanged() {
        if (this.mFilter != null && (this.mLast == null || !this.mFilter.equals(this.mLast)) || this.mFilter == null && this.mLast != null) {
            this.setValue(this.mFilter);
            this.mLast = this.mFilter == null ? null : this.mFilter.copy();
        }
    }

    public void func_75218_e() {
        this.field_75224_c.func_70299_a(0, FakeSlot.toItem(this.mFilter));
        this.setIfChanged();
    }

    public final boolean func_75214_a(ItemStack par1ItemStack) {
        return false;
    }

    public final void func_82870_a(EntityPlayer player, ItemStack stack) {
    }

    public final void func_75215_d(ItemStack item) {
        this.mFilter = FakeSlot.fromItem(item);
        this.field_75224_c.func_70299_a(0, this.mFilter == null ? null : item);
        this.setValue(this.mFilter);
    }

    protected abstract void setValue(IFilter var1);

    public List<String> getTooltip(List<String> existing) {
        return existing;
    }

    public boolean resetFilter() {
        this.setFilter(null);
        return true;
    }

    public boolean shouldRespectSizes() {
        return true;
    }

    public boolean filterNeedsPayload() {
        return true;
    }
}

