/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api.helpers;

import codechicken.multipart.TileMultipart;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.TubesAPI;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class TubeHelper {
    public static final Random rand = new Random();

    public static ITubeConnectable getTubeConnectable(IBlockAccess world, int x, int y, int z) {
        return TubeHelper.getTubeConnectable(world.func_72796_p(x, y, z));
    }

    public static ITubeConnectable getTubeConnectable(TileEntity entity) {
        if (entity instanceof TileMultipart) {
            if (((TileMultipart)entity).partMap(6) instanceof ITubeConnectable) {
                return (ITubeConnectable)((TileMultipart)entity).partMap(6);
            }
        } else if (entity instanceof ITubeConnectable) {
            return (ITubeConnectable)entity;
        }
        return null;
    }

    public static boolean isTubeConnectable(ITubeConnectable other, IBlockAccess world, int x, int y, int z, int side) {
        TileEntity ent = world.func_72796_p(x, y, z);
        ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
        if (con != null) {
            if ((con.getConnectableMask() & 1 << side) == 0) {
                return false;
            }
            if (other instanceof ITube) {
                if (!((ITube)other).canConnectTo(con)) {
                    return false;
                }
                if (con instanceof ITube && !((ITube)con).canConnectTo(other)) {
                    return false;
                }
            }
            return true;
        }
        if (other instanceof ITube && !((ITube)other).canConnectToInventories()) {
            return false;
        }
        return InteractionHandler.isInteractable(world, x, y, z, side ^ 1);
    }

    public static int getConnectivity(IBlockAccess world, Position position) {
        return TubeHelper.getConnectivity(world, position.x, position.y, position.z);
    }

    public static int getConnectivity(IBlockAccess world, int x, int y, int z) {
        int map = 0;
        ITubeConnectable tube = TubeHelper.getTubeConnectable(world, x, y, z);
        if (tube == null) {
            return 0;
        }
        int mask = tube.getConnectableMask();
        for (int side = 0; side < 6; ++side) {
            if ((mask & 1 << side) == 0 || !TubeHelper.isTubeConnectable(tube, world, x + ForgeDirection.getOrientation((int)side).offsetX, y + ForgeDirection.getOrientation((int)side).offsetY, z + ForgeDirection.getOrientation((int)side).offsetZ, side ^ 1)) continue;
            map |= 1 << side;
        }
        return map;
    }

    public static int findNextDirection(IBlockAccess world, int x, int y, int z, TubeItem item) {
        BaseRouter.PathLocation path = null;
        if (item.state == 0) {
            path = TubesAPI.instance.getOutputRouter(world, new Position(x, y, z), item).route();
        } else if (item.state == 1) {
            path = TubesAPI.instance.getImportRouter(world, new Position(x, y, z), item).route();
            if (path == null) {
                path = TubesAPI.instance.getOutputRouter(world, new Position(x, y, z), item).route();
                item.state = 0;
            }
        } else if (item.state == 2) {
            path = TubesAPI.instance.getOutputRouter(world, new Position(x, y, z), item).route();
            if (path == null) {
                path = TubesAPI.instance.getOverflowRouter(world, new Position(x, y, z), item).route();
            } else {
                item.state = 0;
            }
        }
        if (path != null) {
            return path.initialDir;
        }
        return -1;
    }

    public static boolean renderAsInventoryConnection(IBlockAccess world, int x, int y, int z, int side) {
        ITubeConnectable con = TubeHelper.getTubeConnectable(world, x + ForgeDirection.getOrientation((int)side).offsetX, y + ForgeDirection.getOrientation((int)side).offsetY, z + ForgeDirection.getOrientation((int)side).offsetZ);
        if (con != null) {
            return con.showInventoryConnection(side ^ 1);
        }
        return InteractionHandler.isInteractable(world, x + ForgeDirection.getOrientation((int)side).offsetX, y + ForgeDirection.getOrientation((int)side).offsetY, z + ForgeDirection.getOrientation((int)side).offsetZ, side);
    }
}

