/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.items;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JItemMultiPart;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import schmoller.tubes.parts.TubeCap;

public class ItemTubeCap
extends JItemMultiPart {
    public ItemTubeCap(int id) {
        super(id);
    }

    public TMultiPart newPart(ItemStack item, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 hitPos) {
        return null;
    }

    private int getHitSlot(Vector3 hit, int side) {
        int s1 = (side + 2) % 6;
        int s2 = (side + 4) % 6;
        double u = hit.copy().add(-0.5, -0.5, -0.5).scalarProject(Rotation.axes[s1]);
        double v = hit.copy().add(-0.5, -0.5, -0.5).scalarProject(Rotation.axes[s2]);
        double size = 0.25;
        if (Math.abs(u) < size && Math.abs(v) < size) {
            return side ^ 1;
        }
        if (Math.abs(u) > Math.abs(v)) {
            return u > 0.0 ? s1 : s1 ^ 1;
        }
        return v > 0.0 ? s2 : s2 ^ 1;
    }

    private TMultiPart create(int slot) {
        TubeCap part = (TubeCap)MultiPartRegistry.createPart((String)"tubeCap", (boolean)false);
        part.setSlot(slot);
        return part;
    }

    private boolean placeInternal(TileMultipart tile, int slot) {
        TMultiPart part = this.create(slot);
        if (tile.canAddPart(part)) {
            if (!tile.field_70331_k.field_72995_K) {
                TileMultipart.addPart((World)tile.field_70331_k, (BlockCoord)new BlockCoord(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n), (TMultiPart)part);
            }
            return true;
        }
        return false;
    }

    private boolean placeExternal(World world, BlockCoord pos, int slot) {
        TMultiPart part = this.create(slot);
        if (TileMultipart.canPlacePart((World)world, (BlockCoord)pos, (TMultiPart)part)) {
            if (!world.field_72995_K) {
                TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            }
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        if (hit != null && hit.field_72313_a == EnumMovingObjectType.TILE) {
            boolean useOp;
            Vector3 vhit = new Vector3((double)hitX, (double)hitY, (double)hitZ);
            int slot = this.getHitSlot(vhit, side);
            if (slot < 0) {
                return false;
            }
            BlockCoord pos = new BlockCoord(x, y, z);
            TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
            double depth = this.getHitDepth(vhit, side);
            boolean internal = depth < 1.0 && tile != null;
            int oslot = slot ^ 1;
            boolean bl = useOp = slot == (side ^ 1);
            if (internal) {
                if (!useOp ? !this.placeInternal(tile, slot) : (depth < 0.5 ? !this.placeInternal(tile, slot) && !this.placeInternal(tile, oslot) : !this.placeInternal(tile, oslot) && !this.placeExternal(world, pos.copy().offset(side), slot))) {
                    return false;
                }
            } else if (!this.placeExternal(world, pos.copy().offset(side), slot)) {
                if (!useOp) {
                    return false;
                }
                if (!this.placeExternal(world, pos.copy().offset(side), oslot)) {
                    return false;
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, Block.field_71974_j.func_82593_b(), Block.field_71974_j.func_72677_b() * 5.0f, Block.field_71974_j.func_72678_c() * 0.9f);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int itemId, CreativeTabs tab, List items) {
        items.add(new ItemStack(itemId, 1, 0));
    }
}

