/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import schmoller.tubes.network.IModPacketHandler;
import schmoller.tubes.network.ModBlockPacket;
import schmoller.tubes.network.ModPacket;

public class PacketManager
implements IPacketHandler {
    protected String mChannel;
    protected static HashMap<Class<? extends ModPacket>, Integer> mTypeMap = new HashMap();
    protected static HashMap<Integer, Class<? extends ModPacket>> mTypeMapRev = new HashMap();
    private static int sNextId = 0;
    private static HashMap<IModPacketHandler, Class<? extends ModPacket>[]> mHandlerFilters = new HashMap();
    private static HashSet<IModPacketHandler> mHandlers = new HashSet();

    public static int registerPacket(Class<? extends ModPacket> type) {
        if (mTypeMap.containsKey(type)) {
            throw new RuntimeException("Packet already registered!");
        }
        mTypeMap.put(type, sNextId);
        mTypeMapRev.put(sNextId, type);
        return ++sNextId - 1;
    }

    public static void registerHandler(IModPacketHandler handler, Class<? extends ModPacket> ... filter) {
        mHandlers.add(handler);
        if (filter != null && filter.length != 0) {
            mHandlerFilters.put(handler, filter);
        }
    }

    public static void deregisterHandler(IModPacketHandler handler) {
        mHandlers.remove(handler);
        mHandlerFilters.remove(handler);
    }

    public void initialize(String channel) {
        this.mChannel = channel;
        NetworkRegistry.instance().registerChannel((IPacketHandler)this, channel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected Packet250CustomPayload toPacket(ModPacket packet) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        if (!mTypeMap.containsKey(packet.getClass())) {
            throw new RuntimeException("ModPacket '" + packet.getClass().getName() + "' has not been registered!");
        }
        int id = mTypeMap.get(packet.getClass());
        try {
            output.write(id);
            packet.write(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Packet250CustomPayload finalPacket = new Packet250CustomPayload();
        finalPacket.field_73630_a = this.mChannel;
        finalPacket.field_73287_r = false;
        finalPacket.field_73629_c = bytes.toByteArray();
        finalPacket.field_73628_b = finalPacket.field_73629_c.length;
        return finalPacket;
    }

    public void sendPacketToServer(ModPacket packet) {
    }

    public void sendPacketToClient(ModPacket packet, EntityPlayer player) {
        PacketDispatcher.sendPacketToPlayer((Packet)this.toPacket(packet), (Player)((Player)player));
    }

    public void sendPacketToAllClients(ModPacket packet) {
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.toPacket(packet));
    }

    public void sendPacketForBlock(ModBlockPacket packet, World world) {
        PacketDispatcher.sendPacketToAllAround((double)packet.xCoord, (double)packet.yCoord, (double)packet.zCoord, (double)200.0, (int)world.field_73011_w.field_76574_g, (Packet)this.toPacket(packet));
    }

    public void sendPacketToWorld(ModPacket packet, World world) {
        PacketDispatcher.sendPacketToAllInDimension((Packet)this.toPacket(packet), (int)world.field_73011_w.field_76574_g);
    }

    @ForgeSubscribe
    private void onServerStop(FMLServerStoppingEvent event) {
        mHandlers.clear();
        mHandlerFilters.clear();
    }

    private ModPacket getPacket(int id) {
        try {
            Class<? extends ModPacket> clazz = mTypeMapRev.get(id);
            if (clazz == null) {
                return null;
            }
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet.field_73629_c);
        DataInputStream input = new DataInputStream(stream);
        try {
            byte id = input.readByte();
            ModPacket modPacket = this.getPacket(id);
            if (modPacket == null) {
                FMLLog.warning((String)(this.mChannel + " got bad packet id %d"), (Object[])new Object[]{(int)id});
                return;
            }
            modPacket.read(input);
            for (IModPacketHandler handler : mHandlers) {
                Class<? extends ModPacket>[] filter = mHandlerFilters.get(handler);
                if (filter != null) {
                    boolean found = false;
                    for (Class<? extends ModPacket> clazz : filter) {
                        if (!clazz.isInstance(modPacket)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (!handler.onPacketArrive(modPacket, player)) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

