/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network.packets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import schmoller.tubes.PullMode;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.network.ModBlockPacket;

public class ModPacketSetRequestingModes
extends ModBlockPacket {
    public PullMode mode;
    public SizeMode sizeMode;

    public ModPacketSetRequestingModes(int x, int y, int z, PullMode mode) {
        super(x, y, z);
        this.mode = mode;
    }

    public ModPacketSetRequestingModes(int x, int y, int z, SizeMode mode) {
        super(x, y, z);
        this.sizeMode = mode;
    }

    public ModPacketSetRequestingModes() {
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        if (this.mode != null) {
            output.writeBoolean(true);
            output.writeByte(this.mode.ordinal());
        } else {
            output.writeBoolean(false);
            output.writeByte(this.sizeMode.ordinal());
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        super.read(input);
        if (input.readBoolean()) {
            byte val = input.readByte();
            this.mode = val >= 0 && val < PullMode.values().length ? PullMode.values()[val] : PullMode.RedstoneConstant;
        } else {
            byte val = input.readByte();
            this.sizeMode = val >= 0 && val < SizeMode.values().length ? SizeMode.values()[val] : SizeMode.Max;
        }
    }
}

