/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network.packets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import schmoller.tubes.network.ModBlockPacket;
import schmoller.tubes.types.RoutingTube;

public class ModPacketSetRoutingOptions
extends ModBlockPacket {
    public int colour;
    public RoutingTube.RouteDirection direction;
    public boolean hasColour;
    public int column;

    public ModPacketSetRoutingOptions() {
    }

    public ModPacketSetRoutingOptions(int x, int y, int z, int column, int colour) {
        super(x, y, z);
        this.column = column;
        this.colour = colour;
        this.hasColour = true;
    }

    public ModPacketSetRoutingOptions(int x, int y, int z, int column, RoutingTube.RouteDirection dir) {
        super(x, y, z);
        this.column = column;
        this.direction = dir;
        this.hasColour = false;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeByte(this.column);
        output.writeBoolean(this.hasColour);
        if (this.hasColour) {
            output.writeShort(this.colour);
        } else {
            output.writeByte(this.direction.ordinal());
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        super.read(input);
        this.column = input.readByte();
        this.hasColour = input.readBoolean();
        if (this.hasColour) {
            this.colour = input.readShort();
        } else {
            this.direction = RoutingTube.RouteDirection.from(input.readByte());
        }
    }
}

