/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.parts;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.TubeRegistry;
import schmoller.tubes.api.TubesAPI;
import schmoller.tubes.api.helpers.RenderHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.ITube;

@InterfaceDependancies
public abstract class BaseTubePart
extends JCuboidPart
implements ITube,
JNormalOcclusion,
JIconHitEffects,
TSlottedPart,
ISidedHollowConnect {
    private String mType;
    private TubeDefinition mDef;
    public static final int CHANNEL_DATA = 254;
    public static final int CHANNEL_RENDER = 255;

    public BaseTubePart(String type) {
        this.mDef = TubeRegistry.instance().getDefinition(type);
        this.mType = type;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return player.getCurrentPlayerStrVsBlock(Block.field_72012_bb, false, 0) / Block.field_72012_bb.field_71989_cb;
    }

    public String getType() {
        return "tubes_" + this.mType;
    }

    public Cuboid6 getBounds() {
        return this.mDef.getSize();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        boxes.add(this.getBounds());
        return boxes;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        boxes.add(this.getBounds());
        if (this.tile() != null) {
            int connections = this.getConnections();
            block8: for (int i = 0; i < 6; ++i) {
                if ((connections & 1 << i) == 0) continue;
                switch (i) {
                    case 0: {
                        boxes.add(new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.25, 0.75));
                        continue block8;
                    }
                    case 1: {
                        boxes.add(new Cuboid6(0.25, 0.75, 0.25, 0.75, 1.0, 0.75));
                        continue block8;
                    }
                    case 2: {
                        boxes.add(new Cuboid6(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
                        continue block8;
                    }
                    case 3: {
                        boxes.add(new Cuboid6(0.25, 0.25, 0.75, 0.75, 0.75, 1.0));
                        continue block8;
                    }
                    case 4: {
                        boxes.add(new Cuboid6(0.0, 0.25, 0.25, 0.25, 0.75, 0.75));
                        continue block8;
                    }
                    case 5: {
                        boxes.add(new Cuboid6(0.75, 0.25, 0.25, 1.0, 0.75, 0.75));
                    }
                }
            }
        }
        return boxes;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        List boxes = (List)this.getCollisionBoxes();
        ArrayList<IndexedCuboid6> parts = new ArrayList<IndexedCuboid6>(boxes.size());
        for (int i = 0; i < boxes.size(); ++i) {
            parts.add(new IndexedCuboid6((Object)i, (Cuboid6)boxes.get(i)));
        }
        return parts;
    }

    public int getHollowSize(int side) {
        int cons = this.getConnections();
        if ((cons & 1 << side) != 0 && TubeHelper.getTubeConnectable((IBlockAccess)this.world(), this.x() + ForgeDirection.getOrientation((int)side).offsetX, this.y() + ForgeDirection.getOrientation((int)side).offsetY, this.z() + ForgeDirection.getOrientation((int)side).offsetZ) == null) {
            return 10;
        }
        return 8;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return TubesAPI.instance.createTubeForType(this.mType);
    }

    public final Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(1);
        stacks.add(TubesAPI.instance.createTubeForType(this.mType));
        this.onDropItems(stacks);
        return stacks;
    }

    public void bind(TileMultipart t) {
        super.bind(t);
    }

    public boolean doesTick() {
        return true;
    }

    public final void read(MCDataInput packet) {
        int id = packet.readUByte();
        if (id == 254) {
            this.readDesc(packet);
        } else if (id == 255) {
            this.tile().markRender();
        } else {
            this.onRecieveDataClient(id, packet);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderHelper.renderDynamic(this, this.mDef, pos, frame);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        RenderHelper.renderStatic(this, this.mDef);
    }

    @SideOnly(value=Side.CLIENT)
    public final void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public final void addDestroyEffects(EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public final Icon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public final Icon getBrokenIcon(int side) {
        return this.mDef.getCenterIcon();
    }

    public final int getSlotMask() {
        return 64;
    }

    protected void onRecieveDataClient(int channel, MCDataInput input) {
    }

    protected MCDataOutput openChannel(int channel) {
        assert (channel < 254);
        return this.tile().getWriteStream((TMultiPart)this).writeByte(channel);
    }

    protected void markForUpdate() {
        if (this.world().field_72995_K) {
            return;
        }
        this.writeDesc(this.tile().getWriteStream((TMultiPart)this).writeByte(254));
    }

    protected void markForRender() {
        if (this.world().field_72995_K) {
            this.tile().markRender();
        } else {
            this.tile().getWriteStream((TMultiPart)this).writeByte(255);
        }
    }

    protected void onDropItems(List<ItemStack> itemsToDrop) {
    }
}

