/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.parts;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.Items;

public class TubeCap
extends JCuboidPart
implements TFacePart,
JNormalOcclusion {
    private int mSlot = 0;
    public static Icon icon;
    @SideOnly(value=Side.CLIENT)
    private AdvRender mRender;
    private static Cuboid6[] boxes;

    public void setSlot(int slot) {
        this.mSlot = slot;
    }

    public int getSlotMask() {
        return 1 << this.mSlot;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int side) {
        return false;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return player.getCurrentPlayerStrVsBlock(Block.field_72012_bb, false, 0) / Block.field_72012_bb.field_71989_cb;
    }

    public Cuboid6 getBounds() {
        return boxes[this.mSlot];
    }

    public String getType() {
        return "tubeCap";
    }

    public boolean doesTick() {
        return false;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(Items.TubeCap.getItem(), 1, 0);
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(Items.TubeCap.getItem(), 1, 0));
        return items;
    }

    public void save(NBTTagCompound tag) {
        tag.func_74774_a("Side", (byte)this.mSlot);
    }

    public void load(NBTTagCompound tag) {
        this.mSlot = tag.func_74771_c("Side");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.mSlot);
    }

    public void readDesc(MCDataInput packet) {
        this.mSlot = packet.readByte();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (this.mRender == null) {
            this.mRender = new AdvRender();
        }
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)this.world(), this.x(), this.y(), this.z());
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetColor();
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(this.x(), this.y(), this.z());
        this.mRender.setIcon(icon);
        this.mRender.drawBox(63, (float)TubeCap.boxes[this.mSlot].min.x, (float)TubeCap.boxes[this.mSlot].min.y, (float)TubeCap.boxes[this.mSlot].min.z, (float)TubeCap.boxes[this.mSlot].max.x, (float)TubeCap.boxes[this.mSlot].max.y, (float)TubeCap.boxes[this.mSlot].max.z);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        boxes.add(this.getBounds());
        return boxes;
    }

    static {
        boxes = new Cuboid6[6];
        Vector3 center = new Vector3(0.5, 0.5, 0.5);
        for (int i = 0; i < 6; ++i) {
            Transformation trans = Rotation.sideRotations[i].at(center);
            TubeCap.boxes[i] = new Cuboid6(0.25, 0.0625, 0.25, 0.75, 0.25, 0.75).apply(trans);
        }
    }
}

