/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IDirectionalTube;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeBufferTube;
import schmoller.tubes.render.NormalTubeRender;
import schmoller.tubes.types.BufferTube;

public class BufferTubeRender
extends NormalTubeRender {
    private ITube mTube;

    @Override
    public void renderStatic(TubeDefinition type, ITube tube, World world, int x, int y, int z) {
        int connections = tube.getConnections();
        int direction = ((IDirectionalTube)((Object)tube)).getFacing();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(x, y, z);
        connections -= connections & 1 << direction;
        int invCons = 0;
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0 || !TubeHelper.renderAsInventoryConnection((IBlockAccess)world, x, y, z, i)) continue;
            invCons |= 1 << i;
        }
        this.mTube = tube;
        int tubeCons = connections - invCons;
        this.renderCenter(((IDirectionalTube)((Object)tube)).getFacing());
        this.renderConnections(tubeCons, type);
        this.renderInventoryConnections(1 << ((IDirectionalTube)((Object)tube)).getFacing(), type);
    }

    @Override
    protected void renderConnections(int connections, TubeDefinition def) {
        this.mRender.setIcon(TypeBufferTube.center);
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BufferTube other = CommonHelper.getMultiPart((IBlockAccess)this.mTube.world(), this.mTube.x() + dir.offsetX, this.mTube.y() + dir.offsetY, this.mTube.z() + dir.offsetZ, BufferTube.class);
            if (other != null && other.getFacing() != (i ^ 1)) continue;
            this.mRender.resetTextureRotation();
            switch (i) {
                case 0: {
                    this.mRender.setupBox(0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
                    break;
                }
                case 1: {
                    this.mRender.setTextureRotation(0, 0, 2, 2, 2, 2);
                    this.mRender.setupBox(0.25f, 0.75f, 0.25f, 0.75f, 1.0f, 0.75f);
                    break;
                }
                case 2: {
                    this.mRender.setTextureRotation(0, 2, 0, 0, 0, 0);
                    this.mRender.setupBox(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.25f);
                    break;
                }
                case 3: {
                    this.mRender.setTextureRotation(2, 0, 0, 0, 0, 0);
                    this.mRender.setupBox(0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 4: {
                    this.mRender.setTextureRotation(0, 0, 2, 0, 0, 0);
                    this.mRender.setupBox(0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.mRender.setTextureRotation(0, 0, 2, 0, 0, 0);
                    this.mRender.setupBox(0.75f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                }
            }
            this.mRender.drawFaces(63 - (1 << (i ^ 1)) - (1 << i));
        }
        this.mRender.resetTextureRotation();
    }

    private void renderCenter(int facing) {
        this.mRender.setIcon(TypeBufferTube.center);
        this.mRender.drawBox(63 - (1 << facing), 0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f);
        this.mRender.setIcon(TypeBufferTube.centerExport);
        this.mRender.drawBox(1 << facing, 0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f);
    }

    @Override
    protected void renderCore(int connections, TubeDefinition def, int col) {
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)2884);
        FMLClientHandler.instance().getClient().field_71438_f.field_72770_i.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.renderCenter(3);
        this.mRender.setIcon(type.getCenterIcon());
        this.mRender.drawBox(63, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        this.renderInventoryConnections(8, type);
        tes.func_78381_a();
        GL11.glEnable((int)2884);
    }
}

