/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.client.IPayloadRender;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.definitions.TypeNormalTube;

public class ItemPayloadRender
implements IPayloadRender {
    public static ResourceLocation itemGlint = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private RenderBlocks itemRenderBlocks = new RenderBlocks();
    private AdvRender mAdv = new AdvRender();
    private EntityItem mDummy = new EntityItem(null);
    private TextureManager mRender;
    private Random mRand = new Random();

    @Override
    public void render(Payload payload, int color, double x, double y, double z, int direction, float progress) {
        this.renderItemStack((ItemStack)payload.get(), x, y, z);
        if (color != -1) {
            this.mRender.func_110577_a(TextureMap.field_110575_b);
            this.mAdv.enableNormals = false;
            this.mAdv.resetLighting(0xF000F0);
            this.mAdv.resetColor();
            this.mAdv.resetAO();
            this.mAdv.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            this.mAdv.resetTransform();
            this.mAdv.setColorRGB(CommonHelper.getDyeColor(color));
            this.mAdv.translate(-0.5f, -0.5f, -0.5f);
            this.mAdv.scale(0.4f, 0.4f, 0.4f);
            this.mAdv.translate((float)x, (float)y, (float)z);
            this.mAdv.setIcon(TypeNormalTube.itemBorder);
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            this.mAdv.drawBox(63, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            tes.func_78381_a();
        }
    }

    public void renderItemStack(ItemStack item, double x, double y, double z) {
        if (this.mRender == null) {
            this.mRender = FMLClientHandler.instance().getClient().field_71438_f.field_72770_i;
        }
        this.mDummy.func_92058_a(item);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)32826);
        Block block = null;
        if (item.field_77993_c < Block.field_71973_m.length) {
            block = Block.field_71973_m[item.field_77993_c];
        }
        int count = this.getMiniBlockCount(item);
        if (item.func_94608_d() == 0 && block != null && RenderBlocks.func_78597_b((int)Block.field_71973_m[item.field_77993_c].func_71857_b()) || MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY) != null) {
            this.mRand.setSeed(1234L);
            for (int i = 0; i < count; ++i) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                if (i > 0) {
                    float xx = (this.mRand.nextFloat() * 2.0f - 1.0f) * 0.1f;
                    float yy = (this.mRand.nextFloat() * 2.0f - 1.0f) * 0.1f;
                    float zz = (this.mRand.nextFloat() * 2.0f - 1.0f) * 0.1f;
                    GL11.glTranslatef((float)xx, (float)yy, (float)zz);
                }
                this.renderSingleItem(item, block);
                GL11.glPopMatrix();
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.04f * (float)(count - 1) / -2.0f));
            for (int i = 0; i < count; ++i) {
                GL11.glPushMatrix();
                if (i != 0) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.04f * (float)i));
                }
                this.renderSingleItem(item, block);
                GL11.glPopMatrix();
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderSingleItem(ItemStack item, Block block) {
        if (!this.renderCustomItem(item)) {
            if (item.func_94608_d() == 0 && block != null && RenderBlocks.func_78597_b((int)Block.field_71973_m[item.field_77993_c].func_71857_b())) {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.mRender.func_110577_a(TextureMap.field_110575_b);
                int renderType = block.func_71857_b();
                float scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                this.itemRenderBlocks.func_78600_a(block, item.func_77960_j(), 1.0f);
            } else if (item.func_77973_b().func_77623_v()) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.mRender.func_110577_a(TextureMap.field_110576_c);
                for (int pass = 0; pass < item.func_77973_b().getRenderPasses(item.func_77960_j()); ++pass) {
                    GL11.glPushMatrix();
                    Icon icon = item.func_77973_b().getIcon(item, pass);
                    int color = Item.field_77698_e[item.field_77993_c].func_82790_a(item, pass);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
                    this.renderDroppedItem(item, icon, red, green, blue);
                    GL11.glPopMatrix();
                }
            } else {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                Icon icon = item.func_77954_c();
                if (item.func_94608_d() == 0) {
                    this.mRender.func_110577_a(TextureMap.field_110575_b);
                } else {
                    this.mRender.func_110577_a(TextureMap.field_110576_c);
                }
                int color = Item.field_77698_e[item.field_77993_c].func_82790_a(item, 0);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                this.renderDroppedItem(item, icon, red, green, blue);
            }
        }
    }

    private void renderDroppedItem(ItemStack item, Icon icon, float red, float green, float blue) {
        if (icon == null) {
            ResourceLocation resourcelocation = this.mRender.func_130087_a(item.func_94608_d());
            icon = ((TextureMap)this.mRender.func_110581_b(resourcelocation)).func_110572_b("missingno");
        }
        float minU = icon.func_94209_e();
        float minV = icon.func_94206_g();
        float maxU = icon.func_94212_f();
        float maxV = icon.func_94210_h();
        if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
            this.mRender.func_110577_a(this.mRender.func_130087_a(item.func_94608_d()));
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            if (item != null && item.hasEffect(0)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                this.mRender.func_110577_a(itemGlint);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f13 = 0.76f;
                GL11.glColor4f((float)(0.5f * f13), (float)(0.25f * f13), (float)(0.8f * f13), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f14 = 0.125f;
                GL11.glScalef((float)f14, (float)f14, (float)f14);
                float f15 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f15, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f14, (float)f14, (float)f14);
                f15 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f15), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
        } else {
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            Tessellator.field_78398_a.func_78374_a(-0.5, -0.5, 0.0, (double)minU, (double)maxV);
            Tessellator.field_78398_a.func_78374_a(0.5, -0.5, 0.0, (double)maxU, (double)maxV);
            Tessellator.field_78398_a.func_78374_a(0.5, 0.5, 0.0, (double)maxU, (double)minV);
            Tessellator.field_78398_a.func_78374_a(-0.5, 0.5, 0.0, (double)minU, (double)minV);
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    private boolean renderCustomItem(ItemStack item) {
        Block block;
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer == null) {
            return false;
        }
        boolean is3D = customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        this.mRender.func_110577_a(this.mRender.func_130087_a(item.func_94608_d()));
        Block block2 = block = item.field_77993_c < Block.field_71973_m.length ? Block.field_71973_m[item.field_77993_c] : null;
        if (is3D || block != null && RenderBlocks.func_78597_b((int)block.func_71857_b())) {
            int renderType = block != null ? block.func_71857_b() : 1;
            float scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{this.itemRenderBlocks, this.mDummy});
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{this.itemRenderBlocks, this.mDummy});
        }
        return true;
    }

    private byte getMiniBlockCount(ItemStack stack) {
        byte ret = 1;
        if (stack.field_77994_a > 1) {
            ret = 2;
        }
        if (stack.field_77994_a > 5) {
            ret = 3;
        }
        if (stack.field_77994_a > 20) {
            ret = 4;
        }
        if (stack.field_77994_a > 40) {
            ret = 5;
        }
        return ret;
    }
}

