/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IDirectionalTube;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeValveTube;
import schmoller.tubes.render.NormalTubeRender;
import schmoller.tubes.types.ValveTube;

public class ValveTubeRender
extends NormalTubeRender {
    @Override
    public void renderStatic(TubeDefinition type, ITube tube, World world, int x, int y, int z) {
        int connections = tube.getConnections();
        int direction = ((IDirectionalTube)((Object)tube)).getFacing();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(x, y, z);
        connections -= connections & 1 << direction;
        int invCons = 0;
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0 || !TubeHelper.renderAsInventoryConnection((IBlockAccess)world, x, y, z, i)) continue;
            invCons |= 1 << i;
        }
        int tubeCons = connections - invCons;
        int col = tube.getColor();
        this.renderCore(connections | 1 << direction, type, col);
        this.renderConnections(tubeCons, type);
        this.renderInventoryConnections(invCons, type);
        this.renderValve(direction, ((ValveTube)tube).isOpen());
    }

    private void renderValve(int side, boolean open) {
        this.mRender.setIcon(TypeValveTube.valve);
        switch (side) {
            case 0: {
                this.mRender.drawBox(60, 0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
                this.mRender.setIcon(TypeValveTube.valveEdge, TypeValveTube.valveEdge, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve);
                this.mRender.drawBox(63, 0.1875f, 0.0f, 0.1875f, 0.8125f, 0.0625f, 0.8125f);
                this.mRender.drawBox(63, 0.1875f, 0.125f, 0.1875f, 0.8125f, 0.1875f, 0.8125f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.125f, 0.0625f, 0.125f, 0.875f, 0.125f, 0.875f);
                break;
            }
            case 1: {
                this.mRender.drawBox(60, 0.25f, 0.75f, 0.25f, 0.75f, 1.0f, 0.75f);
                this.mRender.setIcon(TypeValveTube.valveEdge, TypeValveTube.valveEdge, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve);
                this.mRender.drawBox(63, 0.1875f, 0.9375f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
                this.mRender.drawBox(63, 0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.875f, 0.8125f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.125f, 0.875f, 0.125f, 0.875f, 0.9375f, 0.875f);
                break;
            }
            case 2: {
                this.mRender.setTextureRotation(0, 0, 0, 0, 3, 1);
                this.mRender.drawBox(51, 0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.25f);
                this.mRender.setIcon(TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valveEdge, TypeValveTube.valveEdge, TypeValveTube.valve, TypeValveTube.valve);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.0f, 0.8125f, 0.8125f, 0.0625f);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.125f, 0.8125f, 0.8125f, 0.1875f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.125f, 0.125f, 0.0625f, 0.875f, 0.875f, 0.125f);
                break;
            }
            case 3: {
                this.mRender.setTextureRotation(0, 0, 0, 0, 3, 1);
                this.mRender.drawBox(51, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 1.0f);
                this.mRender.setIcon(TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valveEdge, TypeValveTube.valveEdge, TypeValveTube.valve, TypeValveTube.valve);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.9375f, 0.8125f, 0.8125f, 1.0f);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f, 0.875f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f, 0.9375f);
                break;
            }
            case 4: {
                this.mRender.setTextureRotation(1, 1, 1, 1, 0, 0);
                this.mRender.drawBox(15, 0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                this.mRender.setIcon(TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valveEdge, TypeValveTube.valveEdge);
                this.mRender.drawBox(63, 0.0f, 0.1875f, 0.1875f, 0.0625f, 0.8125f, 0.8125f);
                this.mRender.drawBox(63, 0.125f, 0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.0625f, 0.125f, 0.125f, 0.125f, 0.875f, 0.875f);
                break;
            }
            case 5: {
                this.mRender.setTextureRotation(1, 1, 1, 1, 0, 0);
                this.mRender.drawBox(15, 0.75f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                this.mRender.setIcon(TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valve, TypeValveTube.valveEdge, TypeValveTube.valveEdge);
                this.mRender.drawBox(63, 0.9375f, 0.1875f, 0.1875f, 1.0f, 0.8125f, 0.8125f);
                this.mRender.drawBox(63, 0.8125f, 0.1875f, 0.1875f, 0.875f, 0.8125f, 0.8125f);
                this.mRender.setIcon(open ? TypeValveTube.valveOpen : TypeValveTube.valveClosed);
                this.mRender.drawBox(63, 0.875f, 0.125f, 0.125f, 0.9375f, 0.875f, 0.875f);
            }
        }
        this.mRender.resetTextureRotation();
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)2884);
        FMLClientHandler.instance().getClient().field_71438_f.field_72770_i.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.mRender.setIcon(type.getCenterIcon());
        this.mRender.drawBox(63, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        this.renderValve(3, false);
        tes.func_78381_a();
        GL11.glEnable((int)2884);
    }
}

