/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.routing;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class OutputRouter
extends BaseRouter {
    private TubeItem mItem;
    private int mDirection = -1;

    public OutputRouter(IBlockAccess world, Position position, TubeItem item) {
        this.mItem = item.clone();
        this.mItem.state = 0;
        this.setup(world, position);
    }

    public OutputRouter(IBlockAccess world, Position position, TubeItem item, int direction) {
        this.mItem = item.clone();
        this.mItem.state = 0;
        this.mDirection = direction;
        this.setup(world, position);
    }

    @Override
    protected void getNextLocations(BaseRouter.PathLocation current) {
        this.mItem.colour = current.color;
        this.mItem.direction = current.dir;
        int conns = TubeHelper.getConnectivity(this.getWorld(), current.position);
        ITubeConnectable myCon = TubeHelper.getTubeConnectable(this.getWorld(), current.position.x, current.position.y, current.position.z);
        int allowed = myCon != null ? myCon.getRoutableDirections(this.mItem) : 63;
        conns &= allowed;
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            this.mItem.colour = current.color;
            this.mItem.direction = current.dir;
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(current, i);
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                this.mItem.direction = loc.dir;
                this.mItem.colour = loc.color;
                this.mItem.state = 0;
                if (!con.canItemEnter(this.mItem)) continue;
                myCon.simulateEffects(this.mItem);
                loc.color = this.mItem.colour;
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected void getInitialLocations(Position position) {
        int conns = TubeHelper.getConnectivity(this.getWorld(), position);
        ITubeConnectable myCon = TubeHelper.getTubeConnectable(this.getWorld(), position.x, position.y, position.z);
        int allowed = myCon != null ? myCon.getRoutableDirections(this.mItem) : 63;
        conns &= allowed;
        int initialColor = this.mItem.colour;
        int initialDir = this.mItem.direction;
        for (int i = 0; i < 6; ++i) {
            if (this.mDirection != -1 && this.mDirection != i || (conns & 1 << i) == 0) continue;
            this.mItem.colour = initialColor;
            this.mItem.direction = initialDir;
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(position, i);
            loc.color = this.mItem.colour;
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                this.mItem.direction = loc.dir;
                this.mItem.colour = loc.color;
                this.mItem.state = 0;
                if (!con.canItemEnter(this.mItem)) continue;
                myCon.simulateEffects(this.mItem);
                loc.color = this.mItem.colour;
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected boolean isTerminator(Position current, int side) {
        Payload remaining;
        IPayloadHandler handler;
        TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), current);
        ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
        this.mItem.direction = side;
        return con == null ? (handler = InteractionHandler.getHandler(this.mItem.item.getClass(), this.getWorld(), current)) != null && ((remaining = handler.insert(this.mItem.item, side ^ 1, false)) == null || remaining.size() != this.mItem.item.size()) : !con.canPathThrough() && con.canItemEnter(this.mItem);
    }
}

