/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.helpers.InventoryHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class CompressorTube
extends BaseTube
implements IInventory {
    private TubeItem mCurrent = null;
    private IFilter mTarget = new AnyFilter(64, 64);

    public CompressorTube() {
        super("compressor");
    }

    @Override
    public boolean canAddItem(Payload item, int direction) {
        if (this.mCurrent != null) {
            return this.mCurrent.item.isPayloadTypeEqual(item);
        }
        return true;
    }

    @Override
    public boolean hasCustomRouting() {
        return true;
    }

    @Override
    public int onDetermineDestination(TubeItem item) {
        if (this.mCurrent != null) {
            if (!item.item.isPayloadTypeEqual(item.item)) {
                return item.direction ^ 1;
            }
            int amt = Math.min(item.item.size(), Math.min(this.mTarget.size(), this.mCurrent.item.maxSize()) - this.mCurrent.item.size());
            this.mCurrent.item.setSize(this.mCurrent.item.size() + amt);
            item.item.setSize(item.item.size() - amt);
            if (this.mCurrent.item.size() == this.mTarget.size() || this.mCurrent.item.size() == this.mCurrent.item.maxSize()) {
                this.mCurrent.updated = true;
                this.addItem(this.mCurrent, true);
                this.mCurrent = null;
                if (item.item.size() > 0) {
                    this.mCurrent = item.clone();
                }
            }
            return -2;
        }
        if (this.mTarget.matches(item.item, SizeMode.LessEqual) && item.item.size() < this.mTarget.size() && item.item.maxSize() != item.item.size()) {
            this.mCurrent = item.clone();
            return -2;
        }
        int conns = this.getConnections();
        int count = 0;
        int dir = 0;
        conns -= conns & 1 << (item.direction ^ 1);
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            ++count;
            dir = i;
        }
        if (count > 1) {
            dir = TubeHelper.findNextDirection((IBlockAccess)this.world(), this.x(), this.y(), this.z(), item);
        }
        return dir;
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return !(con instanceof CompressorTube);
    }

    public IFilter getTargetType() {
        return this.mTarget;
    }

    public void setTargetType(IFilter item) {
        this.mTarget = item == null ? new AnyFilter(64, 64) : item;
        if (!(this.mCurrent == null || this.mTarget.matches(this.mCurrent, SizeMode.LessEqual) && this.mCurrent.item.size() < this.mTarget.size() && this.mCurrent.item.size() < this.mCurrent.item.maxSize())) {
            this.addItem(this.mCurrent, true);
            this.mCurrent = null;
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (this.mCurrent != null && this.mCurrent.item instanceof ItemPayload) {
            return (ItemStack)this.mCurrent.item.get();
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack;
        if (this.mCurrent == null || !(this.mCurrent.item instanceof ItemPayload)) {
            return null;
        }
        if (this.mCurrent.item.size() <= count) {
            itemstack = (ItemStack)this.mCurrent.item.get();
            this.mCurrent = null;
        } else {
            itemstack = ((ItemStack)this.mCurrent.item.get()).func_77979_a(count);
            if (this.mCurrent.item.size() == 0) {
                this.mCurrent = null;
            }
        }
        this.func_70296_d();
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        if (this.mCurrent == null || !(this.mCurrent.item instanceof ItemPayload)) {
            return null;
        }
        ItemStack item = (ItemStack)this.mCurrent.item.get();
        this.mCurrent = null;
        return item;
    }

    public void func_70299_a(int i, ItemStack item) {
        if (item == null) {
            this.mCurrent = null;
            return;
        }
        if (this.mCurrent == null) {
            this.mCurrent = new TubeItem(new ItemPayload(item));
            this.mCurrent.direction = 6;
            this.mCurrent.setProgress(0.5f);
        } else {
            this.mCurrent.item = new ItemPayload(item);
        }
        if (this.mCurrent.item.size() >= this.mTarget.size() || this.mCurrent.item.size() >= this.mCurrent.item.maxSize()) {
            this.addItem(this.mCurrent, true);
            this.mCurrent = null;
        }
    }

    public String func_70303_b() {
        return "container.inventory";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return this.mTarget.size();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.x(), (double)this.y(), (double)this.z()) <= 25.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack item) {
        if (this.mTarget.getType().equals("any")) {
            return true;
        }
        if (this.mTarget.getType().equals("item")) {
            return InventoryHelper.areItemsEqual(((ItemFilter)this.mTarget).getItem(), item);
        }
        return false;
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        super.onDropItems(itemsToDrop);
        if (this.mCurrent != null && this.mCurrent.item instanceof ItemPayload) {
            itemsToDrop.add((ItemStack)this.mCurrent.item.get());
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        player.openGui((Object)ModTubes.instance, 2, this.world(), this.x(), this.y(), this.z());
        return true;
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        NBTTagCompound target = (NBTTagCompound)root.func_74781_a("Target");
        this.mTarget = FilterRegistry.getInstance().readFilter(target);
        if (this.mTarget == null) {
            ItemStack oldTarget = ItemStack.func_77949_a((NBTTagCompound)target);
            this.mTarget = oldTarget == null ? new AnyFilter(64, 64) : new ItemFilter(oldTarget, false);
        }
        if (root.func_74764_b("Current")) {
            NBTTagCompound current = (NBTTagCompound)root.func_74781_a("Current");
            this.mCurrent = TubeItem.readFromNBT(current);
        }
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        NBTTagCompound target = new NBTTagCompound();
        FilterRegistry.getInstance().writeFilter(this.mTarget, target);
        root.func_74782_a("Target", (NBTBase)target);
        if (this.mCurrent != null) {
            NBTTagCompound current = new NBTTagCompound();
            this.mCurrent.writeToNBT(current);
            root.func_74782_a("Current", (NBTBase)current);
        }
    }

    @Override
    public void readDesc(MCDataInput input) {
        super.readDesc(input);
        this.mCurrent = input.readBoolean() ? TubeItem.read(input) : null;
    }

    @Override
    public void writeDesc(MCDataOutput output) {
        super.writeDesc(output);
        if (this.mCurrent != null) {
            output.writeBoolean(true);
            this.mCurrent.write(output);
        } else {
            output.writeBoolean(false);
        }
    }
}

