/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.interfaces.IDirectionalTube;

public abstract class DirectionalTube
extends BaseTube
implements IDirectionalTube {
    private int mDirection = 0;

    public DirectionalTube(String type) {
        super(type);
    }

    @Override
    protected int getConnectableSides() {
        return 63 - (0x3F & 1 << this.mDirection);
    }

    @Override
    public int getFacing() {
        return this.mDirection;
    }

    @Override
    public boolean canFaceDirection(int face) {
        return true;
    }

    @Override
    public void setFacing(int face) {
        this.mDirection = face;
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        root.func_74774_a("Dir", (byte)this.mDirection);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        this.mDirection = root.func_74771_c("Dir");
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.mDirection = packet.readByte();
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte(this.mDirection);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        IToolWrench wrench;
        if (item != null && item.func_77973_b() instanceof IToolWrench && (wrench = (IToolWrench)item.func_77973_b()).canWrench(player, this.x(), this.y(), this.z())) {
            ++this.mDirection;
            if (this.mDirection >= 6) {
                this.mDirection = 0;
            }
            this.markForRender();
            wrench.wrenchUsed(player, this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }
}

