/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.definitions.TypeRoutingTube;
import schmoller.tubes.routing.OutputRouter;

public class RoutingTube
extends BaseTube {
    private IFilter[][] mFilters = new IFilter[9][4];
    private int[] mColours = new int[9];
    private RouteDirection[] mDir = new RouteDirection[9];

    public RoutingTube() {
        super("routing");
        Arrays.fill((Object[])this.mDir, (Object)RouteDirection.Closed);
        Arrays.fill(this.mColours, -1);
    }

    public void setFilter(int column, int row, IFilter item) {
        this.mFilters[column][row] = item;
    }

    public IFilter getFilter(int column, int row) {
        return this.mFilters[column][row];
    }

    public void setColour(int column, int colour) {
        this.mColours[column] = colour;
    }

    public int getColour(int column) {
        return this.mColours[column];
    }

    public void setDirection(int column, RouteDirection direction) {
        this.mDir[column] = direction;
    }

    public RouteDirection getDirection(int column) {
        return this.mDir[column];
    }

    private boolean doesItemMatchFilter(int column, TubeItem item) {
        boolean empty = true;
        for (int i = 0; i < 4; ++i) {
            if (this.mFilters[column][i] == null) continue;
            empty = false;
            if (!this.mFilters[column][i].matches(item, SizeMode.Max)) continue;
            return true;
        }
        return empty;
    }

    @Override
    public boolean hasCustomRouting() {
        return true;
    }

    @Override
    public void simulateEffects(TubeItem item) {
        int[] matches = new int[9];
        int highest = -1;
        int conns = this.getConnections();
        for (int col = 0; col < 9; ++col) {
            if (this.mDir[col] != RouteDirection.Closed) {
                if (this.mDir[col] != RouteDirection.Any && (conns & 1 << this.mDir[col].ordinal()) == 0) continue;
                boolean empty = true;
                boolean match = false;
                int level = 0;
                for (int i = 0; i < 4; ++i) {
                    if (this.mFilters[col][i] == null) continue;
                    empty = false;
                    if (!this.mFilters[col][i].matches(item, SizeMode.Max)) continue;
                    match = true;
                    level = i;
                    break;
                }
                if (!match && !empty) {
                    matches[col] = -1;
                } else if (empty) {
                    matches[col] = 0;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                } else {
                    matches[col] = 5 - level;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                }
                if (matches[col] <= highest) continue;
                highest = matches[col];
                continue;
            }
            matches[col] = -1;
        }
        int color = -1;
        for (int col = 0; col < 9; ++col) {
            if (matches[col] != highest || highest == -1) continue;
            if (color == -1) {
                color = this.mColours[col];
                continue;
            }
            item.colour = -1;
            return;
        }
        item.colour = color;
    }

    @Override
    public int getRoutableDirections(TubeItem item) {
        int col;
        int allowed = 0;
        int[] matches = new int[9];
        int highest = -1;
        int conns = this.getConnections();
        for (col = 0; col < 9; ++col) {
            if (this.mDir[col] != RouteDirection.Closed) {
                if (this.mDir[col] != RouteDirection.Any && (conns & 1 << this.mDir[col].ordinal()) == 0) continue;
                boolean empty = true;
                boolean match = false;
                int level = 0;
                for (int i = 0; i < 4; ++i) {
                    if (this.mFilters[col][i] == null) continue;
                    empty = false;
                    if (!this.mFilters[col][i].matches(item, SizeMode.Max)) continue;
                    match = true;
                    level = i;
                    break;
                }
                if (!match && !empty) {
                    matches[col] = -1;
                } else if (empty) {
                    matches[col] = 0;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                } else {
                    matches[col] = 5 - level;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                }
                if (matches[col] <= highest) continue;
                highest = matches[col];
                continue;
            }
            matches[col] = -1;
        }
        for (col = 0; col < 9; ++col) {
            if (matches[col] != highest || highest == -1) continue;
            if (this.mDir[col] != RouteDirection.Any) {
                allowed |= 1 << this.mDir[col].ordinal();
                continue;
            }
            allowed = 63;
        }
        return allowed;
    }

    @Override
    public int onDetermineDestination(TubeItem item) {
        int[] matches = new int[9];
        int highest = -1;
        int conns = this.getConnections();
        int fromDir = item.direction;
        for (int col = 0; col < 9; ++col) {
            if (this.mDir[col] != RouteDirection.Closed) {
                if (this.mDir[col] != RouteDirection.Any && (conns & 1 << this.mDir[col].ordinal()) == 0) continue;
                boolean empty = true;
                boolean match = false;
                int level = 0;
                for (int i = 0; i < 4; ++i) {
                    if (this.mFilters[col][i] == null) continue;
                    empty = false;
                    if (!this.mFilters[col][i].matches(item, SizeMode.Max)) continue;
                    match = true;
                    level = i;
                    break;
                }
                if (!match && !empty) {
                    matches[col] = -1;
                } else if (empty) {
                    matches[col] = 0;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                } else {
                    matches[col] = 5 - level;
                    if (this.mDir[col] != RouteDirection.Any) {
                        int n = col;
                        matches[n] = matches[n] + 1;
                    }
                }
                if (matches[col] <= highest) continue;
                highest = matches[col];
                continue;
            }
            matches[col] = -1;
        }
        int count = 0;
        int[] routes = new int[9];
        int[] routeColours = new int[9];
        int[] routeLength = new int[9];
        int smallestDist = Integer.MAX_VALUE;
        int smallCount = 0;
        int[] smallest = new int[9];
        for (int col = 0; col < 9; ++col) {
            if (matches[col] != highest || highest == -1) continue;
            TubeItem copy = item.clone();
            copy.colour = this.mColours[col];
            BaseRouter.PathLocation loc = this.mDir[col] == RouteDirection.Any ? new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item).route() : new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item, this.mDir[col].ordinal()).route();
            if (loc != null) {
                routes[count] = loc.initialDir;
                routeLength[count] = loc.dist;
                routeColours[count] = this.mColours[col];
                if (routeLength[count] < smallestDist) {
                    smallCount = 1;
                    smallest[0] = count;
                    smallestDist = routeLength[count];
                } else if (routeLength[count] == smallestDist) {
                    smallest[smallCount++] = count;
                }
                ++count;
                continue;
            }
            if (this.mDir[col] == RouteDirection.Closed) continue;
            fromDir = this.mDir[col].ordinal();
        }
        if (count == 0) {
            return fromDir;
        }
        int route = smallest[TubeHelper.rand.nextInt(smallCount)];
        item.colour = routeColours[route];
        return routes[route];
    }

    @Override
    public boolean canPathThrough() {
        return true;
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        if (item.state == 2) {
            int fromDir = item.direction;
            item.lastDirection = item.direction;
            item.state = 2;
            item.direction = TubeHelper.findNextDirection((IBlockAccess)this.world(), this.x(), this.y(), this.z(), item);
            if (item.direction == -1) {
                fromDir ^= 1;
                int con = this.getConnections();
                int total = Integer.bitCount(con &= this.getRoutableDirections(item));
                if (total == 1) {
                    item.direction = Integer.numberOfTrailingZeros(con);
                    item.updated = true;
                    this.addToClient(item);
                    return true;
                }
                if (total == 0) {
                    item.direction = 6;
                    return true;
                }
                int num = TubeHelper.rand.nextInt(total - 1);
                int index = 0;
                for (int i = 0; i < 6; ++i) {
                    if (i == fromDir || (con & 1 << i) == 0) continue;
                    if (num == index) {
                        item.direction = i;
                        item.updated = true;
                        this.addToClient(item);
                        return true;
                    }
                    ++index;
                }
                item.direction = fromDir;
                item.updated = true;
                this.addToClient(item);
                return true;
            }
            this.addToClient(item);
            return true;
        }
        return super.onItemJunction(item);
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        int conns = this.getConnections();
        for (int col = 0; col < 9; ++col) {
            if (this.mDir[col] == RouteDirection.Closed || this.mDir[col] != RouteDirection.Any && (conns & 1 << this.mDir[col].ordinal()) == 0 || !this.doesItemMatchFilter(col, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(NBTTagCompound root) {
        int i;
        super.save(root);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = j + i * 4;
                if (this.mFilters[i][j] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Slot", index);
                FilterRegistry.getInstance().writeFilter(this.mFilters[i][j], tag);
                list.func_74742_a((NBTBase)tag);
            }
        }
        root.func_74782_a("NewFilter", (NBTBase)list);
        list = new NBTTagList();
        for (i = 0; i < 9; ++i) {
            list.func_74742_a((NBTBase)new NBTTagInt("", this.mColours[i]));
        }
        root.func_74782_a("Colours", (NBTBase)list);
        list = new NBTTagList();
        for (i = 0; i < 9; ++i) {
            list.func_74742_a((NBTBase)new NBTTagInt("", this.mDir[i].ordinal()));
        }
        root.func_74782_a("Dirs", (NBTBase)list);
    }

    @Override
    public void load(NBTTagCompound root) {
        int i;
        int column;
        int row;
        NBTTagCompound tag;
        int i2;
        NBTTagList filters;
        super.load(root);
        NBTTagList colours = root.func_74761_m("Colours");
        NBTTagList directions = root.func_74761_m("Dirs");
        if (root.func_74764_b("Filter")) {
            filters = root.func_74761_m("Filter");
            for (i2 = 0; i2 < filters.func_74745_c(); ++i2) {
                tag = (NBTTagCompound)filters.func_74743_b(i2);
                row = tag.func_74762_e("Slot") % 4;
                column = tag.func_74762_e("Slot") / 4;
                this.mFilters[column][row] = new ItemFilter(ItemStack.func_77949_a((NBTTagCompound)tag), false);
            }
        } else {
            filters = root.func_74761_m("NewFilter");
            for (i2 = 0; i2 < filters.func_74745_c(); ++i2) {
                tag = (NBTTagCompound)filters.func_74743_b(i2);
                row = tag.func_74762_e("Slot") % 4;
                column = tag.func_74762_e("Slot") / 4;
                this.mFilters[column][row] = FilterRegistry.getInstance().readFilter(tag);
            }
        }
        for (i = 0; i < 9; ++i) {
            this.mColours[i] = ((NBTTagInt)colours.func_74743_b((int)i)).field_74748_a;
        }
        for (i = 0; i < 9; ++i) {
            this.mDir[i] = RouteDirection.from(((NBTTagInt)directions.func_74743_b((int)i)).field_74748_a);
        }
    }

    @Override
    public void writeDesc(MCDataOutput output) {
        int i;
        super.writeDesc(output);
        for (i = 0; i < 9; ++i) {
            output.writeShort(this.mColours[i]);
        }
        for (i = 0; i < 9; ++i) {
            output.writeByte(this.mDir[i].ordinal());
        }
    }

    @Override
    public void readDesc(MCDataInput input) {
        int i;
        super.readDesc(input);
        for (i = 0; i < 9; ++i) {
            this.mColours[i] = input.readShort();
        }
        for (i = 0; i < 9; ++i) {
            this.mDir[i] = RouteDirection.from(input.readByte());
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        player.openGui((Object)ModTubes.instance, 4, this.world(), this.x(), this.y(), this.z());
        return true;
    }

    public static enum RouteDirection {
        Down,
        Up,
        North,
        South,
        West,
        East,
        Any,
        Closed;


        public static RouteDirection from(int dir) {
            if (dir < 0 || dir > 7) {
                return Closed;
            }
            return RouteDirection.values()[dir];
        }

        public String toString() {
            if (this == Any || this == Closed) {
                return StatCollector.func_74838_a((String)("gui.routingtube.direction." + this.name()));
            }
            return TypeRoutingTube.sideColoursText[this.ordinal()].toString() + StatCollector.func_74838_a((String)("gui.routingtube.direction." + this.name()));
        }
    }
}

