/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.interfaces.IFilter;

public class FluidFilter
implements IFilter {
    private FluidStack mTemplate;
    @SideOnly(value=Side.CLIENT)
    private AdvRender mRender;

    public FluidFilter(FluidStack template) {
        assert (template != null);
        this.mTemplate = template;
    }

    @Override
    public String getType() {
        return "fluid";
    }

    @Override
    public Class<? extends Payload> getPayloadType() {
        return FluidPayload.class;
    }

    public FluidStack getFluid() {
        return this.mTemplate;
    }

    @Override
    public boolean matches(Payload payload, SizeMode mode) {
        if (!(payload instanceof FluidPayload) || !this.mTemplate.isFluidEqual((FluidStack)payload.get())) {
            return false;
        }
        FluidStack other = (FluidStack)payload.get();
        switch (mode) {
            case Exact: {
                return other.amount == this.mTemplate.amount;
            }
            case GreaterEqual: {
                return other.amount >= this.mTemplate.amount;
            }
            case LessEqual: {
                return other.amount <= this.mTemplate.amount;
            }
            case Max: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(TubeItem item, SizeMode mode) {
        return this.matches(item.item, mode);
    }

    @Override
    public void increase(boolean useMax, boolean shift) {
        this.mTemplate.amount = this.mTemplate.amount + (shift ? 250 : 125);
        if (useMax && this.mTemplate.amount > this.getMax()) {
            this.mTemplate.amount = this.getMax();
        }
    }

    @Override
    public void decrease(boolean shift) {
        this.mTemplate.amount = this.mTemplate.amount - (shift ? 250 : 125);
        if (this.mTemplate.amount < 0) {
            this.mTemplate.amount = 0;
        }
    }

    @Override
    public int getMax() {
        if (this.mTemplate.getFluid().isGaseous(this.mTemplate)) {
            return 8000;
        }
        return 1000;
    }

    @Override
    public int size() {
        return this.mTemplate.amount;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlock(Icon icon, int x, int y, int sprite) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(sprite));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)197.0f);
        GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
        GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.mRender.resetLighting();
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.mRender.enableNormals = true;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        this.mRender.setIcon(icon);
        this.mRender.drawBox(63, 0.0f, 0.0f, 0.0f, 1.0f, 0.8f, 1.0f);
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFilter(int x, int y) {
        if (this.mRender == null) {
            this.mRender = new AdvRender();
        }
        GL11.glEnable((int)2929);
        Icon icon = this.mTemplate.getFluid().getIcon(this.mTemplate);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(this.mTemplate.getFluid().getSpriteNumber()));
        this.renderBlock(icon, x, y, this.mTemplate.getFluid().getSpriteNumber());
        String text = String.valueOf(this.mTemplate.amount);
        int fwidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 17 - fwidth), (double)(y + 9), (double)0.0);
        if (fwidth > 16) {
            GL11.glTranslatef((float)(fwidth / 2 - 1), (float)((float)Minecraft.func_71410_x().field_71466_p.field_78288_b / 2.0f - 1.0f), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        Minecraft.func_71410_x().field_71466_p.func_78261_a(text, 0, 0, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void write(NBTTagCompound tag) {
        this.mTemplate.writeToNBT(tag);
    }

    @Override
    public void write(MCDataOutput output) {
        output.writeFluidStack(this.mTemplate);
    }

    public static FluidFilter from(NBTTagCompound tag) {
        return new FluidFilter(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
    }

    public static FluidFilter from(MCDataInput input) {
        return new FluidFilter(input.readFluidStack());
    }

    @Override
    public IFilter copy() {
        return new FluidFilter(this.mTemplate);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(List<String> current) {
        return Arrays.asList("\u00a7" + Integer.toHexString(this.mTemplate.getFluid().getRarity((FluidStack)this.mTemplate).field_77937_e) + this.mTemplate.getFluid().getLocalizedName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FluidFilter)) {
            return false;
        }
        return this.mTemplate.isFluidStackIdentical(((FluidFilter)obj).mTemplate);
    }
}

