/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Payload;

public class TubeItem
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int IMPORT = 1;
    public static final int BLOCKED = 2;
    public Payload item;
    public int direction = 0;
    public int lastDirection = 0;
    public float progress = 0.0f;
    public float lastProgress = 0.0f;
    public boolean updated = false;
    public int state = 0;
    public int colour = -1;
    public int speed = 1;
    public int tickNo = 0;

    public TubeItem(Payload item) {
        this.item = item;
    }

    public void setProgress(float progress) {
        this.progress = this.lastProgress = progress;
    }

    public String toString() {
        return this.item.toString() + " " + ForgeDirection.getOrientation((int)this.direction).name() + " U:" + this.updated + " P:" + this.progress + " S:" + this.state;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("D", this.direction | (this.updated ? 128 : 0));
        tag.func_74776_a("P", this.progress);
        tag.func_74768_a("S", this.state);
        tag.func_74777_a("C", (short)this.colour);
        this.item.write(tag);
    }

    public void write(MCDataOutput output) {
        output.writeByte(this.direction | (this.updated ? 128 : 0));
        output.writeFloat(this.progress);
        this.item.write(output);
        output.writeByte(this.state);
        output.writeShort(this.colour);
    }

    public static TubeItem read(MCDataInput input) {
        int direction = input.readByte() & 0xFF;
        boolean updated = (direction & 0x80) != 0;
        direction -= direction & 0x80;
        float progress = input.readFloat();
        TubeItem item = new TubeItem(Payload.load(input));
        item.direction = direction;
        item.updated = updated;
        item.progress = progress;
        item.state = input.readByte();
        item.colour = input.readShort();
        item.lastProgress = progress;
        item.lastDirection = direction;
        return item;
    }

    public static TubeItem readFromNBT(NBTTagCompound tag) {
        Payload payload = null;
        payload = tag.func_74764_b("Type") ? Payload.load(tag) : new ItemPayload(ItemStack.func_77949_a((NBTTagCompound)tag));
        TubeItem tItem = new TubeItem(payload);
        tItem.direction = tag.func_74762_e("D") & 0xFF;
        tItem.updated = (tItem.direction & 0x80) != 0;
        tItem.direction -= tItem.direction & 0x80;
        tItem.lastProgress = tItem.progress = tag.func_74760_g("P");
        tItem.state = tag.func_74762_e("S");
        tItem.colour = tag.func_74765_d("C");
        return tItem;
    }

    public TubeItem clone() {
        TubeItem item = new TubeItem(this.item.copy());
        item.direction = this.direction;
        item.lastDirection = this.lastDirection;
        item.state = this.state;
        item.progress = this.progress;
        item.lastProgress = this.lastProgress;
        item.updated = this.updated;
        item.colour = this.colour;
        return item;
    }
}

