/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.inventory;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.helpers.InventoryHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IPayloadHandler;

public class SidedInvHandler
implements IPayloadHandler<ItemPayload> {
    private ISidedInventory mInv;

    public SidedInvHandler(ISidedInventory inventory) {
        this.mInv = inventory;
    }

    @Override
    public ItemPayload insert(ItemPayload payload, int side, boolean doAdd) {
        int toAdd;
        ItemStack existing;
        int[] slots;
        ItemStack remaining = ((ItemStack)payload.get()).func_77946_l();
        for (int i : slots = this.mInv.func_94128_d(side)) {
            existing = this.mInv.func_70301_a(i);
            if (existing == null) continue;
            if (InventoryHelper.areItemsEqual(existing, remaining) && (toAdd = Math.min(remaining.field_77994_a, Math.min(this.mInv.func_70297_j_(), existing.func_77976_d() - existing.field_77994_a))) > 0) {
                remaining.field_77994_a -= toAdd;
                if (doAdd) {
                    existing.field_77994_a += toAdd;
                }
            }
            if (remaining.field_77994_a > 0) continue;
            if (doAdd) {
                this.mInv.func_70296_d();
            }
            return null;
        }
        for (int i : slots) {
            existing = this.mInv.func_70301_a(i);
            if (existing != null) continue;
            if (this.mInv.func_102007_a(i, (ItemStack)payload.get(), side) && this.mInv.func_94041_b(i, remaining) && (toAdd = Math.min(remaining.field_77994_a, this.mInv.func_70297_j_())) > 0) {
                remaining.field_77994_a -= toAdd;
                if (doAdd) {
                    existing = remaining.func_77946_l();
                    existing.field_77994_a = toAdd;
                    this.mInv.func_70299_a(i, existing);
                }
            }
            if (remaining.field_77994_a > 0) continue;
            if (doAdd) {
                this.mInv.func_70296_d();
            }
            return null;
        }
        if (remaining.field_77994_a != payload.size() && doAdd) {
            this.mInv.func_70296_d();
        }
        return new ItemPayload(remaining);
    }

    @Override
    public ItemPayload extract(IFilter template, int side, boolean doExtract) {
        return this.extract(template, side, 0, SizeMode.Max, doExtract);
    }

    @Override
    public ItemPayload extract(IFilter template, int side, int count, SizeMode mode, boolean doExtract) {
        int[] slots;
        assert (template != null);
        assert (template instanceof AnyFilter || template instanceof ItemFilter);
        ItemStack pulled = null;
        if (doExtract && this.extract(template, side, count, mode, false) == null) {
            return null;
        }
        for (int i : slots = this.mInv.func_94128_d(side)) {
            ItemStack existing = this.mInv.func_70301_a(i);
            if (existing == null || !this.mInv.func_102008_b(i, existing, side) || pulled != null && !InventoryHelper.areItemsEqual(pulled, existing) || !(template instanceof AnyFilter) && !template.matches(new ItemPayload(existing), SizeMode.Max)) continue;
            int toGrab = 0;
            switch (mode) {
                case Max: 
                case GreaterEqual: {
                    toGrab = Math.min(existing.field_77994_a, pulled != null ? existing.func_77976_d() - pulled.field_77994_a : existing.func_77976_d());
                    break;
                }
                case Exact: 
                case LessEqual: {
                    toGrab = Math.min(existing.field_77994_a, pulled != null ? count - pulled.field_77994_a : count);
                }
            }
            if (pulled == null) {
                pulled = existing.func_77946_l();
                pulled.field_77994_a = toGrab;
            } else {
                pulled.field_77994_a += toGrab;
            }
            if (!doExtract) continue;
            this.mInv.func_70298_a(i, toGrab);
        }
        if (pulled != null && !doExtract) {
            if (mode == SizeMode.Exact) {
                if (pulled.field_77994_a != count) {
                    pulled = null;
                }
            } else if (mode == SizeMode.GreaterEqual) {
                if (pulled.field_77994_a < count) {
                    pulled = null;
                }
            } else if (mode == SizeMode.LessEqual && pulled.field_77994_a > count) {
                pulled = null;
            }
        }
        if (pulled != null && doExtract) {
            this.mInv.func_70296_d();
        }
        return pulled == null ? null : new ItemPayload(pulled);
    }

    private static boolean isNullOrEmpty(int[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    @Override
    public boolean isSideAccessable(int side) {
        return !SidedInvHandler.isNullOrEmpty(this.mInv.func_94128_d(side));
    }
}

