/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeColoringTube;
import schmoller.tubes.render.NormalTubeRender;

public class ColoringTubeRender
extends NormalTubeRender {
    @Override
    public void renderStatic(TubeDefinition type, ITube tube, World world, int x, int y, int z) {
        int connections = tube.getConnections();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetColor();
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(x, y, z);
        int col = tube.getColor();
        int invCons = 0;
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0 || !TubeHelper.renderAsInventoryConnection((IBlockAccess)world, x, y, z, i)) continue;
            invCons |= 1 << i;
        }
        int tubeCons = connections - invCons;
        this.renderCore(connections, type, col);
        this.renderConnections(tubeCons, type);
        this.renderInventoryConnections(invCons, type);
    }

    @Override
    protected void renderCore(int connections, TubeDefinition def, int col) {
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) != 0) continue;
            switch (i) {
                case 0: {
                    this.mRender.setupBox(0.25f, 0.1875f, 0.25f, 0.75f, 0.25f, 0.75f);
                    break;
                }
                case 1: {
                    this.mRender.setupBox(0.25f, 0.75f, 0.25f, 0.75f, 0.8125f, 0.75f);
                    break;
                }
                case 2: {
                    this.mRender.setupBox(0.25f, 0.25f, 0.1875f, 0.75f, 0.75f, 0.25f);
                    break;
                }
                case 3: {
                    this.mRender.setupBox(0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 0.8125f);
                    break;
                }
                case 4: {
                    this.mRender.setupBox(0.1875f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.mRender.setupBox(0.75f, 0.25f, 0.25f, 0.8125f, 0.75f, 0.75f);
                }
            }
            this.mRender.setIcon(TypeColoringTube.center);
            this.mRender.drawFaces(63);
            if (col == -1) continue;
            this.mRender.setIcon(TypeColoringTube.paint);
            this.mRender.setColorRGB(CommonHelper.getDyeColor(col));
            this.mRender.drawFaces(1 << i);
            this.mRender.resetColor();
        }
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.resetColor();
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        FMLClientHandler.instance().getClient().field_71438_f.field_72770_i.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.renderCore(0, type, (int)(System.currentTimeMillis() / 1000L % 16L));
        tes.func_78381_a();
    }
}

